package model.visio;

import java.util.*;

public class Page {
	private String name;
	private double w;
	private double h;
	private XForm xf;
	private List<Shape> shapes = new LinkedList<Shape>();
	
	public Page(String name, String w, String h, XForm xf){
		this.name = name;
		this.w = Double.parseDouble(w);
		this.h = Double.parseDouble(h);
		this.xf = xf;
	}
	
	public void addShape(Shape shape){
		shapes.add(shape);
	}
	
	public String toString(){
		String s = "<Container widthC='" + w + "' heightC='" + h + "'>\n<Shape " + xf + ">\n";
		for(Shape shape : shapes){
			s += shape + "\n";
		}
		s += "</Shape>\n</Container>\n";
		return s;
	}
	
	public void executeGui(Hashtable<String, Page> pages, Container container, XForm xxf){
		container.appendShape("<Container widthC='" + w + "' heightC='" + h + "' " + xxf + ">\n<Shape " + xf + ">\n");
		for(Shape shape : shapes){
			shape.executeGui(pages, container, "Page");
		}
		container.appendShape("</Shape>\n"+container.getLines()+ container.getContainer()+"</Container>\n");
	}
	
	public void executeSim(Document document, Hashtable<Integer, Master> masters, ModuleParam moduleParam){
		xf.setPinY(h-xf.getPinY());
		Simulation simPage = new Simulation();
		for(Shape shape : shapes){
			shape.executeSim(document, masters, xf, simPage, null);
		}
		for(Shape shape : shapes){
			shape.executeSimLines(simPage, moduleParam);
		}
	}
	
	public String getName(){
		return name;
	}

	public void setName(String name){
		this.name = name;
	}
}
