package model.visio;
import java.util.*;

public class Master {
	private int id;
	private String name;
	private Map<String, String> properties = new HashMap<String, String>();
	private List<Shape> shapes = new LinkedList<Shape>();

	public Master(String id, String name){
		this.id = Integer.parseInt(id);
		this.name = name.split("[.]")[0].replace(" ", "");
		
	}
	public String getName(){
		return name;
	}
	
	public void setName(String name){
		this.name = name.split("[.]")[0].replace(" ", "");
	}
	
	public void setId(int id){
		this.id = id;
	}
	
	public int getId(){
		return id;
	}
	
	public void addShape(Shape shape){
		shapes.add(shape);
	}
	
	public Shape getShape(int i){
		return shapes.get(i);
	}
	
	public void addProperties(String key, String value){
		properties.put(key, value);
	}
	
	public Map<String, String> getProperties(){
		return properties;
	}
	
	public String toString(){
		String s = "<Master ID='"+id+"' NameU='"+name+"'>\n";
		for(Shape shape : shapes){
			s += shape + "\n";
		}
		s += "</Master>\n";
		return s;
	}
}
