package model.visio;



public class EllipArcTo implements Streak {	
	private double x;
	private double y;
	private double a;
	private double b;
	private double c;
	private double d;
	
	private Point firstControl = new Point();
	private Point secondControl = new Point();
	
	public EllipArcTo(String x, String y, String a, String b, String c, String d){
		this.x = Double.parseDouble(x);
		this.y = Double.parseDouble(y);
		this.a = Double.parseDouble(a);
		this.b = Double.parseDouble(b);
		this.c = Double.parseDouble(c);
		this.d = Double.parseDouble(d);
	}
	public EllipArcTo(double x, double y, double a, double b, double c, double d){
		this.x = x;
		this.y = y;
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
	}	
	
	public Streak clone(){
		return new EllipArcTo(x, y, a, b, c, d);
	}
	
	public Point recalculate(XForm xf, Point begin){
		x += xf.getPinX();
		y = xf.getPinY() - y;
		a += xf.getPinX();
		b = xf.getPinY() - b;
		calculateControlPiont(begin, new Point(x, y), new Point(a, b), c, d);
		return new Point(x, y);
		
	}
	public String toString(){
		return "<EllipticalArcTo x='" + firstControl.getX() + "' y='" + firstControl.getY() + "' a='" + secondControl.getX() + 
				"' b='" + secondControl.getY() + "' c='" + x + "' d='" + y + "'/>";
	}
	
	public void calculateControlPiont(Point begin, Point end, Point control, double C, double D){
		Point P0 = new Point(), 
	    P1 = new Point(),
	    P2 = new Point(),
	    P3 = new Point(),
	    P4 = new Point(),
	    P5 = new Point(),
	    Q = new Point(),
	    T0 = new Point(),
	    T1 = new Point(),
	    T2 = new Point(),
	    T3 = new Point();
	    double R, sinC, cosC;
	    double a, b, c, d, e, f, g;
	    
	    sinC = Math.sin(C); cosC = Math.cos(C);
	    P0.setX((begin.getX()*cosC + begin.getY()*sinC)/D);
	    P0.setY(-begin.getX()*sinC + begin.getY()*cosC);
	    P3.setX((end.getX()*cosC + end.getY()*sinC)/D);
	    P3.setY(-end.getX()*sinC + end.getY()*cosC);
	    P4.setX((control.getX()*cosC + control.getY()*sinC)/D);
	    P4.setY(-control.getX()*sinC + control.getY()*cosC);

	    a = P3.getX() - P0.getX();
	    b = P3.getY() - P0.getY();
	    c = P4.getX() - P0.getX();
	    d = P4.getY() - P0.getY();
	    e = a*(P0.getX() + P3.getX()) + b*(P0.getY() + P3.getY());
	    f = c*(P0.getX() + P4.getX()) + d*(P0.getY() + P4.getY());
	    g = 2.0*(a*(P4.getY() - P3.getY()) - b*(P4.getX() - P3.getX()));
	    Q.setX((d*e - b*f)/g);
	    Q.setY((a*f - c*e)/g);
	    R = Math.sqrt((P0.getX() - Q.getX())*(P0.getX() - Q.getX()) + (P0.getY() - Q.getY())*(P0.getY() - Q.getY()));
	    
	    T0.setY(Q.getX() - P0.getX()); 
	    T0.setX(-(Q.getY() - P0.getY()));
	    a = Math.sqrt(T0.getX()*T0.getX() + T0.getY()*T0.getY());
	    T0.setX(T0.getX()/a);
	    T0.setY(T0.getY()/a);

	    T3.setY(Q.getX() - P3.getX());
	    T3.setX(-(Q.getY() - P3.getY()));
	    a = Math.sqrt(T3.getX()*T3.getX() + T3.getY()*T3.getY());
	    T3.setX(T3.getX()/a);
	    T3.setY(T3.getY()/a);

	    d = T3.getX()*T0.getY() - T3.getY()*T0.getX();
	    if(Math.abs(d) < EPSILON){
	        T3 = T0;
	    }else{
	        a =  (P3.getY() * T3.getX() - P0.getY() * T3.getX() + T3.getY() * P0.getX() - T3.getY() * P3.getX()) / d;
	        b = -(P0.getY() * T0.getX() - P3.getY() * T0.getX() + T0.getY() * P3.getX() - T0.getY() * P0.getX()) / d;
	        if(a < 0 && b > 0){
	        	T0.setX(- T0.getX());
	            T0.setY(- T0.getY());
	        }
	        if(a > 0 && b < 0){
	            T3.setX(- T3.getX());
	            T3.setY(- T3.getY());
	        }
	    }
	    T1.setX((P0.getX() + P3.getX())/2.0);
	    T1.setY((P0.getY() + P3.getY())/2.0);
	    
	    T2.setX(T1.getX() - Q.getX());
	    T2.setY(T1.getY() - Q.getY());
	    a = Math.sqrt(T2.getX()*T2.getX() + T2.getY()*T2.getY());
	    if(Math.abs(a) < EPSILON){
	        T2 = T0;
	        a = Math.sqrt(T2.getX()*T2.getX() + T2.getY()*T2.getY());
	    }
	    T2.setX(T2.getX()/a);
	    T2.setY(T2.getY()/a);

	    a = T2.getX() * (P4.getX() - Q.getX()) + T2.getY() * (P4.getY() - Q.getY());
	    if(a < 0){
	    	T2.setX(- T2.getX()); 
	    	T2.setY(- T2.getY()); 
	    }

	    P5.setX(Q.getX() + R * T2.getX());
	    P5.setY(Q.getY() + R * T2.getY());
	    if(Math.abs(T0.getX()+T3.getX()) < EPSILON){
	        a = (P5.getY() - (P0.getY() + P3.getY())/2.0)*8.0/3.0/(T0.getY() + T3.getY());
	    }else{
	        a = (P5.getX() - (P0.getX() + P3.getX())/2.0)*8.0/3.0/(T0.getX() + T3.getX());
	    }
	    /* Construct P1 and P2 */
	    P1.setX(P0.getX() + a * T0.getX());
	    P1.setY(P0.getY() + a * T0.getY());
	    P2.setX(P3.getX() + a * T3.getX());
	    P2.setY(P3.getY() + a * T3.getY());

	    firstControl.setX((P1.getX()*D*cosC - P1.getY()*sinC));
	    firstControl.setY((P1.getX()*D*sinC + P1.getY()*cosC));
	    secondControl.setX((P2.getX()*D*cosC - P2.getY()*sinC));
	    secondControl.setY((P2.getX()*D*sinC + P2.getY()*cosC));
	    
	}
	
}
