package model.sim;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import simgen.ElementModel;
import simgen.SimGenModel;
import system.AppConstants;


public class ElementSim {
	private static Hashtable<Integer, ElementSim> elementsPool = new Hashtable<Integer, ElementSim>();
	private static Hashtable<String, Integer> marks = new Hashtable<String, Integer>();
	private static Map<String, Integer> registers = new HashMap<String, Integer>();
	private static Map<String, Integer> inSignals = new HashMap<String, Integer>();
	private static List<String> inSignalsList = new LinkedList<String>();
		
	protected static Simulation  changingList = new Simulation(); 
	
	private static void addElement(int id, ElementSim element){
		elementsPool.put(new Integer(id), element);
	}
	
	public static ElementSim getElement(int id){
		return elementsPool.get(new Integer(id));
	}
	
	public static void addRegister(String key, Integer id){
		registers.put(key, id);
	}
	
	public static Map<String, Integer> getRegisters(){
		return new HashMap<String, Integer>(registers);
	}
	
	public static Integer getRegister(String key){
		return registers.get(key);
	}
	
	public static void addInSignal(String key, Integer id){
		inSignals.put(key, id);
	}
	
	public static Map<String, Integer> getInSignals(){
		return new HashMap<String, Integer>(inSignals);
	}
	
	public static Integer getInSignal(String key){
		return inSignals.get(key);
	}
	
	public static List<String> getInSignalsList(){
		return new LinkedList<String>(inSignalsList);
	}
	
	public static void xMLParserSim(String fileName, HashMap<Integer, Integer> memorija, String projectName){
		try{
			SimGenModel simGenModel = SimGenModel.getInstance();
			simGenModel.init(AppConstants.PROJECTS_DIR + projectName + "/config.xml");
			HashMap<String, ElementModel> elementsModelMap = simGenModel.getElementsMap();
			
			Document doc = null;
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			XPathFactory xpathFactory = XPathFactory.newInstance();
			DocumentBuilder builder = null;
			builder = factory.newDocumentBuilder();
			File file = new File(fileName);
			doc = builder.parse(file);
			XPath xpath = xpathFactory.newXPath();
			XPathExpression expr = null;

			int id=0, vrednost=0, brLinija=0;
			int[] ins, outs;
			String[] insS, outsS;
			String text = "";
			expr = xpath.compile("//element");
			Object result = expr.evaluate(doc, XPathConstants.NODESET);
			NodeList nodes = (NodeList) result;
			for(int i = 0; i < nodes.getLength(); i++){
				Node node = nodes.item(i);
				String name = node.getAttributes().getNamedItem(AppConstants.NAME).getNodeValue();
				id = Integer.parseInt(node.getAttributes().getNamedItem(AppConstants.ID).getNodeValue());
				insS = node.getAttributes().getNamedItem(AppConstants.INS).getNodeValue().split(" ");
				outsS = node.getAttributes().getNamedItem(AppConstants.OUTS).getNodeValue().split(" ");
				vrednost = Integer.parseInt(node.getAttributes().getNamedItem(AppConstants.VALUE).getNodeValue());
				brLinija = Integer.parseInt(node.getAttributes().getNamedItem(AppConstants.COUNT).getNodeValue());
				text = node.getAttributes().getNamedItem(AppConstants.TEXT).getNodeValue();
				if(!"".equals(text)){
					if(text.startsWith("reg_")){
						registers.put(text, id);
					}else if(text.startsWith("in_")){
						inSignals.put(text, id);
						inSignalsList.add(text);
					}else{
						marks.put(text, id);
					}
				}
				ins = new int[insS.length];
				for(int j=0; j<insS.length; j++){
					ins[j] = Integer.parseInt(insS[j]);
				}
				outs = new int[outsS.length];
				for(int j=0; j<outsS.length; j++){
					outs[j] = Integer.parseInt(outsS[j]);
				}
				
//				String newName = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
//				newName = newName.split("_")[0];
				ElementModel elementModel = elementsModelMap.get(name.split("_")[0]);
//				System.out.println("Name: " + name + " - elementModel: " + elementModel);
				String newName = elementModel != null ? elementModel.getClassName() : name.split("_")[0];
				if(name.contains("Bracket")){ 
					newName = "Container";
				}
				Class<?> clas = Class.forName("elements." + newName);
				Object array = Array.newInstance(int.class, 256);
				Class<?> partypes[] = {int.class, array.getClass(), array.getClass(), int.class, int.class, String.class};
	            Constructor<?> ct = clas.getConstructor(partypes);
	            Object arglist[] = new Object[6];
	            arglist[0] = id;
	            arglist[1] = ins;
	            arglist[2] = outs;
	            arglist[3] = vrednost;
	            arglist[4] = brLinija;
	            arglist[5] = text;
	            ElementSim retobj = (ElementSim)ct.newInstance(arglist);
	            addElement(id, retobj);
			}
			elementsModelMap.clear();
			changingList.execute();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public static int parserInteger(int number, int index1, int index2){
		return  (number >> index1) & ((1<<(index2-index1+1))-1);
	}
	
	public static void reset(){
		Enumeration<ElementSim> elements = elementsPool.elements();
		
		while(elements.hasMoreElements()){
			elements.nextElement().init();
		}
		changingList.execute();
		
	}
	
	public static int getMarkId(String mark){
		return marks.get(mark) != null ? marks.get(mark).intValue() : -1;
	}
	
	protected int id;
	protected int[] ins;
	protected int[] outs;
	protected int numLines = 1;
	protected int value = 0;
	protected String mark = "";
	
	public ElementSim(int id, int[] ins, int[] outs, int value, int numLines, String mark){
		this.id = id;		
		this.ins = ins;
		this.outs = outs;
		this.value = value;
		this.numLines = numLines;
		this.mark = mark;
		addElement(id, this);
	}
	
	public void execute(){
		
	}
	
	public int getValue(int id){
		return -1;
	}
	
	public int getNumLines(){
		return 1;
	}
	
	public int getId(){
		return id;
	}
	
	public void init(){
	}
}
