package model.gui;

import java.awt.*;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.*;

public class Text {
	
	private double apsX;
	private double apsY;
	private double width;
	private double height;
	private double angle;
	private double size;
	private String text;
	
//	private final static double visinaProzora = 4.5;
	
	public Text(double apsX, double apsY, double width, double height, double angle, double size, String text) {
		this.apsX = apsX;
		this.apsY = apsY;
		this.width = width;
		this.height = height;
		this.angle = angle;
		this.size = size;
		this.text = text;
	}
	
	public void paint(Graphics g, double scaleX, double scaleY){
		if(text.length() != 0){
			Graphics2D g2d = (Graphics2D)g;
			AffineTransform reset = new AffineTransform();
//			double size1 = height/visinaProzora*600;
			
			FontRenderContext frc = g2d.getFontRenderContext();			
			Font f;
			f = new Font("Times New Roman", Font.PLAIN, (int)scaleX/4);
			if(size < 1){
				f = new Font("Times New Roman", Font.PLAIN, (int)(size*100));
			}
//			if (size1<20){
//				f = new Font("Times New Roman", Font.PLAIN, (int)size1);
//			}else{
//				f = new Font("Times New Roman", Font.PLAIN, 20);
//			}
			g2d.setFont(f);
			TextLayout tl = new TextLayout(text, f, frc);
			AffineTransform at = AffineTransform.getTranslateInstance(apsX*scaleX+(width*scaleX - tl.getBounds().getWidth()/2)/2, apsY*scaleY-(height*scaleY - tl.getBounds().getHeight()/2)/2);
			g2d.setTransform(at);
			g2d.drawString(text, (float) (apsX*scaleX+(width*scaleX - tl.getBounds().getWidth()/2)/2), (float)(apsY*scaleY-(height*scaleY - tl.getBounds().getHeight()/2)/2));
			g2d.setTransform(reset);
		}
	}
	
	public void drawValue(Graphics g, String value, double scaleX, double scaleY){
		if(value.length() != 0){
			Graphics2D g2d = (Graphics2D)g;
			g2d.setPaint(Color.MAGENTA);
			FontRenderContext frc = g2d.getFontRenderContext();
//			Font f = new Font("Times New Roman", Font.PLAIN, 15);
			Font f = new Font("Times New Roman", Font.PLAIN, (int)scaleX/4);
			
			TextLayout tl = new TextLayout(value, f, frc);
			AffineTransform at = AffineTransform.getTranslateInstance(apsX*scaleX+(width*scaleX - tl.getBounds().getWidth()/2)/2, apsY*scaleY-(height*scaleY - tl.getBounds().getHeight()/2)/2);
			g2d.setTransform(at);
			java.awt.Shape oblik = tl.getOutline(at);
			g2d.fill(oblik);
			g2d.setPaint(Color.BLACK);
		}
	}
}