package model.gui;

import java.awt.*;
import java.awt.geom.*;
import java.util.ArrayList;

import util.Arrow;

public class Shape {
	
	private double apsX;
	private double apsY;
	private double width;
	private double height;
	private GeneralPath generalPath;
	private Point2D endPoint = null;

	private ArrayList<Text> texts = new ArrayList<Text>();
	
	public Shape(double apsX, double apsY, double width, double height, GeneralPath generalPath){
		this.apsX = apsX;
		this.apsY = apsY;
		this.width = width;
		this.height = height;
		this.generalPath = generalPath;
	}
	
	public void addText(Text text){
		texts.add(text);
	}
	
	public Text getText(int i){
		return texts.get(i);
	}
	
	public void paint(Graphics g){
		Graphics2D g2d = (Graphics2D)g;
		// strelice na linijama
//		if(endPoint == null){
//			System.out.println("UsaoShape");
//			endPoint = generalPath.getCurrentPoint();
//			Point2D beginPoint = new Point2D.Double(endPoint.getX() - 0.5, endPoint.getY());
//			double deltaX = endPoint.getX() - beginPoint.getX();
//			double deltaY = endPoint.getY() - beginPoint.getY();
//			double frac = 0.2;
//			generalPath.lineTo(beginPoint.getX() + (1-frac)*deltaX + frac*deltaY, beginPoint.getY() + (1-frac)*deltaY - frac*deltaX);
//			generalPath.moveTo(endPoint.getX(), endPoint.getY());
//			generalPath.lineTo(beginPoint.getX() + (1-frac)*deltaX - frac*deltaY, beginPoint.getY() + (1-frac)*deltaY + frac*deltaX);
//		}
		
		g2d.draw(generalPath);
	}
	
	public void drawText(Graphics g, double scaleX, double scaleY){
		Graphics2D g2d = (Graphics2D)g;
		for(Text text : texts){
			text.paint(g, scaleX, scaleY);
		}
	}
	
	public GeneralPath getGeneralPath(){
		return generalPath;
	}

	public void setGeneralPath(GeneralPath generalPath) {
		this.generalPath = generalPath;
	}
}
