package model.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Container {
	
	private Container parent;
	private double widthC;
	private double heightC;
	private double apsX;
	private double apsY;
	private double width;
	private double height;
	
	private ArrayList<Container> containers = new ArrayList<Container>();
	private ArrayList<Shape> shapes = new ArrayList<Shape>();
	private ArrayList<Line> lines = new ArrayList<Line>();
	
	public Container(Container parent, double widthC, double heightC, double apsX, double apsY, double width, double height){
		this.parent = parent;
		this.widthC = widthC;
		this.heightC = heightC;
		this.apsX = apsX;
		this.apsY = apsY;
		this.width = width;
		this.height = height;
	}
	
	public void addContainer(Container container){
		containers.add(container);
	}
	
	public Container getContainer(int i){
		return containers.get(i);
	}
	
	public void addShape(Shape shape){
		shapes.add(shape);
	}
	
	public Shape getShape(int i){
		return shapes.get(i);
	}
	
	public void addLine(Line line) {
		lines.add(line);
	}
	
	public Line getLine(int i) {
		return lines.get(i);
	}
	
	public Container getParent(){
		return parent;
	}
	
	public void paint(Graphics g, Graphics g2, boolean change, double scaleX, double scaleY){
		Graphics2D g2d = (Graphics2D)g;		
		for(Line line : lines){
			line.paint(g);
		}
		if(change){
			for(Shape shape : shapes){
				shape.paint(g);
			}
		}
		for(Line line : lines){	
			line.drawText(g, scaleX/2, scaleY/2);
		}
		if(change){
			for(Shape shape : shapes){	
				shape.drawText(g, scaleX/2, scaleY/2);
			}
		}
	}
	
	public boolean containerFocus(Point t, double scaleX, double scaleY){
		Point begin = new Point(apsX*scaleX, (apsY-height)*scaleY);
		Point end = new Point((apsX + width)*scaleX, apsY*scaleY);
		return (t.greaterThen(begin) && end.greaterThen(t)); 
	}

	public Container containerListener(Point t, double scaleX, double scaleY){
		for(Container container : containers){
			if(container.containerFocus(t, scaleX, scaleY))
				return container;
		}
		return null;
	}
}
