package gui;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;

import javax.swing.JFrame;
import javax.swing.UIManager;

import model.gui.Container;
import model.gui.MouseWheelListenerOnPicture;
import model.gui.Picture;
import system.AppConstants;
import xml.GuiParser;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;

/*
 * SimGui.java
 *
 * Created on 25.11.2009., 14.42.28
 */

/**
 *
 * @author User
 */
public class SimGui extends javax.swing.JFrame {
    private InterfaceSimGui interfejsSimGui;
    
    /** Creates new form SimGui */
    public SimGui(InterfaceSimGui iinterfejsSimGui){
        super("Simulator");
//        initLookAndFeel();
        interfejsSimGui = iinterfejsSimGui;
        initMem = new InitMemory(this, interfejsSimGui);
		initReg = new InitRegister(interfejsSimGui);
		memory = new MemoryView(interfejsSimGui);
		fAbout = new FrameAbout();
		signalGen = new SignalGenerator(interfejsSimGui, this);
		
        initComponents();
        picture.addMouseWheelListener(new MouseWheelListenerOnPicture(picture));
        picture.setPreferredSize(new Dimension(995, 740));
        jScrollPane2.setPreferredSize(picture.getSize());
        output.setText("Start");
    }

    @SuppressWarnings("unchecked")
    private void initComponents(){
    	jScrollPane1 = new javax.swing.JScrollPane();
    	jScrollPane2 = new javax.swing.JScrollPane();
        output = new javax.swing.JTextArea();
        controlPanel = new javax.swing.JPanel();
        up = new javax.swing.JButton();
        tact = new javax.swing.JButton();
        instruction = new javax.swing.JButton();
        program = new javax.swing.JButton();
        clear = new javax.swing.JButton();
        picture = new Picture(interfejsSimGui);
        viewPanel = new javax.swing.JPanel();
        menuBar = new MenuBar();
        fileMenu = new Menu();
        exitItem = new MenuItem();
        initMenu = new Menu();
        initMemoryItem = new MenuItem();
        initRegisterItem = new MenuItem();
        signalGenItem = new MenuItem();
        viewMenu = new Menu();
        viewMemoruItem = new MenuItem();
        zoomIn = new MenuItem();
        zoomOut = new MenuItem();
        refresh = new MenuItem();
        helpMenu = new Menu();
        helpItem = new MenuItem();
        aboutItem = new MenuItem();
        goToClk = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        clkCount = new javax.swing.JLabel();
        memoryScrollPane = new javax.swing.JScrollPane();
        memoryTable = new javax.swing.JTable();
        memoryTableModel = new MemoryTableModel(interfejsSimGui);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setBounds(0,0,880,670);
        setMinimumSize(new Dimension(900, 700));

        jScrollPane1.setBorder(javax.swing.BorderFactory.createTitledBorder("Output"));
        jScrollPane1.setAlignmentX(0.0F);
        jScrollPane1.setAlignmentY(0.0F);

        output.setColumns(20);
        output.setEditable(false);
        output.setRows(5);
        jScrollPane1.setViewportView(output);

        controlPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Control"));
        controlPanel.setAlignmentX(0.0F);
        controlPanel.setAlignmentY(0.0F);

        up.setText("UP");
        up.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                upActionPerformed(evt);
            }
        });

        tact.setText("Takt");
        tact.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tactActionPerformed(evt);
            }
        });

        instruction.setText("Instrukcija");
        instruction.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                instructionActionPerformed(evt);
            }
        });

        program.setText("Program");
        program.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                programActionPerformed(evt);
            }
        });

        clear.setText("Clear");
        clear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearActionPerformed(evt);
            }
        });
        
        goToClk.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        goToClk.setText("0");
        goToClk.addActionListener (new ActionListener (){
	    	public void actionPerformed (ActionEvent d){
	    		goToClkActionPerformed(d);
	    	}
	    });

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setText("(CLK+)*");

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("CLK:");

        clkCount.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        clkCount.setText("0");

        javax.swing.GroupLayout controlPanelLayout = new javax.swing.GroupLayout(controlPanel);
        controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(
            controlPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(controlPanelLayout.createSequentialGroup()
                .addGap(2, 2, 2)
                .addGroup(controlPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jLabel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(controlPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(clkCount, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(goToClk)
                    .addComponent(up, javax.swing.GroupLayout.DEFAULT_SIZE, 85, Short.MAX_VALUE)
                    .addComponent(tact, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(instruction, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(program, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(clear, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(74, Short.MAX_VALUE))
        );
        controlPanelLayout.setVerticalGroup(
            controlPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(controlPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(up)
                .addGap(18, 18, 18)
                .addComponent(tact)
                .addGap(18, 18, 18)
                .addComponent(instruction)
                .addGap(18, 18, 18)
                .addComponent(program)
                .addGap(18, 18, 18)
                .addComponent(clear)
                .addGap(18, 18, 18)
                .addGroup(controlPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(goToClk, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addGap(28, 28, 28)
                .addGroup(controlPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(clkCount))
                .addContainerGap(29, Short.MAX_VALUE))
        );

        picture.setBackground(new java.awt.Color(255, 255, 255));
        picture.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0), 3));
        jScrollPane2.setViewportView(picture);
        
        memoryScrollPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Memory"));
        memoryTable.setFont(new java.awt.Font("Tahoma", 1, 12));
        
        memoryTable.setModel(memoryTableModel);
        memoryScrollPane.setViewportView(memoryTable);        

        fileMenu.setLabel("File");

        exitItem.setLabel("Exit");
        exitItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitItem);

        menuBar.add(fileMenu);

        initMenu.setLabel("Initialization");

        initMemoryItem.setLabel("Memory");
        initMemoryItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                initMemoryItemActionPerformed(evt);
            }
        });
        initMenu.add(initMemoryItem);

        initRegisterItem.setLabel("Register");
        initRegisterItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                initRegisterItemActionPerformed(evt);
            }
        });
        initMenu.add(initRegisterItem);
        signalGenItem.setLabel("Signal generator");
        signalGenItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                signalGenItemActionPerformed(evt);
            }
        });
        initMenu.add(signalGenItem);

        menuBar.add(initMenu);

        viewMenu.setLabel("View");

        viewMemoruItem.setShortcut(new MenuShortcut(KeyEvent.VK_M));
        viewMemoruItem.setLabel("Memory");
        viewMemoruItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewMemoryItemActionPerformed(evt);
            }
        });
        viewMenu.add(viewMemoruItem);

        zoomIn.setShortcut(new MenuShortcut(KeyEvent.VK_ADD));
        zoomIn.setLabel("Zoom +");
        zoomIn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zoomInActionPerformed(evt);
            }
        });
        viewMenu.add(zoomIn);

        zoomOut.setShortcut(new MenuShortcut(KeyEvent.VK_SUBTRACT));
        zoomOut.setLabel("Zoom -");
        zoomOut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zoomOutActionPerformed(evt);
            }
        });
        viewMenu.add(zoomOut);

        refresh.setShortcut(new MenuShortcut(KeyEvent.VK_F5));
        refresh.setLabel("Refresh");
        refresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshActionPerformed(evt);
            }
        });
        viewMenu.add(refresh);

        menuBar.add(viewMenu);

        helpMenu.setLabel("Help");

        helpItem.setLabel("Help");
        helpItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpItemActionPerformed(evt);
            }
        });
        helpMenu.add(helpItem);

        aboutItem.setLabel("About");
        aboutItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aboutItemActionPerformed(evt);
            }
        });
        helpMenu.add(aboutItem);

        menuBar.add(helpMenu);

        setMenuBar(menuBar);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                	.addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 720, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
               		.addComponent(memoryScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 223, Short.MAX_VALUE)
                    .addComponent(controlPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
           		.addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE, 160))
            .addGroup(layout.createSequentialGroup()
            	.addComponent(controlPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(memoryScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 367, Short.MAX_VALUE))
        );

        pack();
    }

    private void upActionPerformed(java.awt.event.ActionEvent evt) {
    	interfejsSimGui.up();
		picture.repaint();
    }

    private void tactActionPerformed(java.awt.event.ActionEvent evt) {
    	interfejsSimGui.nextTact();
		picture.repaint();
		//tekst.setText("");
		int n = interfejsSimGui.getCurrentTact();
//		tekst.append("Korak T"+Integer.toString(n, 16) +" - "+ signali[n]+"\n");
		clkCount.setText(Integer.toString(interfejsSimGui.currentTact));
    }

    private void instructionActionPerformed(java.awt.event.ActionEvent evt) {
    	picture.repaint();
		clkCount.setText(Integer.toString(interfejsSimGui.currentTact));
    }

    private void programActionPerformed(java.awt.event.ActionEvent evt) {
    	interfejsSimGui.program();
		picture.repaint();
		clkCount.setText(Integer.toString(interfejsSimGui.currentTact));
    }

    private void clearActionPerformed(java.awt.event.ActionEvent evt) {
    	interfejsSimGui.reset();
    	clkCount.setText("0");
		picture.repaint();
    }
    
    private void exitItemActionPerformed(java.awt.event.ActionEvent evt) {
        dispose();
    }

    private void initMemoryItemActionPerformed(java.awt.event.ActionEvent evt) {
        initMem.showDialog();
        memoryTable.revalidate();
        memoryScrollPane.repaint();
    }

    private void initRegisterItemActionPerformed(java.awt.event.ActionEvent evt) {
        initReg.setVisible(true);
    }
    
    private void signalGenItemActionPerformed(java.awt.event.ActionEvent evt) {
        signalGen.setVisible(true);
    }

    private void viewMemoryItemActionPerformed(java.awt.event.ActionEvent evt) {
        memory.setVisible(true);
    }

    private void zoomInActionPerformed(java.awt.event.ActionEvent evt) {
        picture.setZoomLevel(1);
        picture.repaint();
    }

    private void zoomOutActionPerformed(java.awt.event.ActionEvent evt) {
    	picture.setZoomLevel(-1);
    	picture.repaint();
    }

    private void refreshActionPerformed(java.awt.event.ActionEvent evt) {
        picture.repaint();
    }

    private void helpItemActionPerformed(java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:
    }

    private void aboutItemActionPerformed(java.awt.event.ActionEvent evt) {
        fAbout.setVisible(true);
    }

    private void clearOutButtonActionPerformed(java.awt.event.ActionEvent evt) {                                               
        // TODO add your handling code here:
    }
    
    private void goToClkActionPerformed(ActionEvent evt){
    	interfejsSimGui.goToTact(Integer.parseInt(goToClk.getText()));
		picture.repaint();
		clkCount.setText(Integer.toString(interfejsSimGui.currentTact));
    }
    
    public void repaintPicture(){
        picture.repaint();
    }
    
    @SuppressWarnings("unchecked")
    private void initLookAndFeel(){
		try{
			Class classOptions = Class.forName("com.jgoodies.looks.Options");
			Method method = classOptions.getMethod("setUseNarrowButtons", new Class[] { boolean.class });
			method.invoke(null, new Object[] { Boolean.TRUE });
			method = classOptions.getMethod("setUseSystemFonts", new Class[] { boolean.class });
			method.invoke(null, new Object[] { Boolean.TRUE });
			method = classOptions.getMethod(!LookUtils.IS_OS_MAC?"getCrossPlatformLookAndFeelClassName":"getSystemLookAndFeelClassName" , new Class[] {});
			String looksClass = (String) method.invoke(null, new Object[] {});
			UIManager.setLookAndFeel(looksClass);
			if (LookUtils.IS_OS_MAC){ 
				System.setProperty("apple.laf.useScreenMenuBar", "true");
				Options.setPopupDropShadowEnabled(true);
			}
		} catch (Exception e1) {
			// Do nothing - go ahead with the current Look and Feel
		}
	}

    /**
    * @param args the command line arguments
    */
    

    // Variables declaration - do not modify
    private MenuItem aboutItem;
    private javax.swing.JButton clear;
    private javax.swing.JPanel controlPanel;
    private javax.swing.JPanel viewPanel;
    private MenuItem exitItem;
    private Menu fileMenu;
    private MenuItem helpItem;
    private Menu helpMenu;
    private MenuItem initMemoryItem;
    private Menu initMenu;
    private MenuItem initRegisterItem;
    private MenuItem signalGenItem;
    private javax.swing.JButton instruction;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private MenuBar menuBar;
    private javax.swing.JTextArea output;
    private model.gui.Picture picture;
    private javax.swing.JButton program;
    private javax.swing.JButton tact;
    private javax.swing.JButton up;
    private MenuItem viewMemoruItem;
    private Menu viewMenu;
    private MenuItem zoomIn;
    private MenuItem zoomOut;
    private MenuItem refresh;
    private javax.swing.JTextField goToClk;
    private javax.swing.JLabel clkCount;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane memoryScrollPane;
    private javax.swing.JTable memoryTable;
    
    private InitMemory initMem;
	private InitRegister initReg;
	private MemoryView memory;
	private FrameAbout fAbout;
	private SignalGenerator signalGen;
	private MemoryTableModel memoryTableModel;
    // End of variables declaration                

    public static void main(String arg[]){
		GuiParser guiParser = new GuiParser();
//		Container pocetni = guiParser.parse(AppConstants.PROJECTS_DIR + arg[0] + "/gui.xml");
		Container pocetni = guiParser.parse(AppConstants.XML_DIR + "gui.xml");
		InterfaceSimGui iSG = new InterfaceSimGui();
//		iSG.addSimFile(AppConstants.PROJECTS_DIR + arg[0] + "/sim.xml");
		iSG.addSimFile(AppConstants.XML_DIR + "sim.xml");
//		iSG.initSimulation(arg[0]);
		iSG.initSimulation("Test");
		iSG.setCurrentContainer(pocetni);
		SimGui simGui = new SimGui(iSG);
		simGui.setExtendedState(simGui.getExtendedState()|JFrame.MAXIMIZED_BOTH);
		simGui.setVisible(true);
	}
}
