package gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

import model.sim.ElementSim;

class SignalGenerator extends JFrame {
	private static final long serialVersionUID = 1L;

	private InterfaceSimGui interfejsSimGui;
	private SimGui simGui;
	private JTable table;
	private JScrollPane scrollPane;
	private SignalGeneratorTableModel sgTableModel;
	
	private JButton ok = new JButton("Ok");
	private JButton cancel = new JButton("Cancel");
	
	public SignalGenerator(InterfaceSimGui iinterfejsSimGui, SimGui ssimGui){
		super("Generator signala");
		interfejsSimGui = iinterfejsSimGui;
		simGui = ssimGui;
		sgTableModel = new SignalGeneratorTableModel(simGui);
		table = new JTable(sgTableModel);
		table.setRowHeight(20);
		
		scrollPane = new JScrollPane();
		scrollPane.setViewportView(table);
		add(scrollPane, "Center");
		JPanel panel2 = new JPanel(); 
//		panel2.add(ok);
		panel2.add(cancel);
		ok.setText("Ok");
		ok.setPreferredSize(new java.awt.Dimension(75, 30));
		cancel.setText("Close");
        cancel.setPreferredSize(new java.awt.Dimension(75, 30));
		add(panel2, "South");
		
		setLocation(300,100);
		setSize(250, 500);
		
		ok.addActionListener (new ActionListener (){
	    	public void actionPerformed (ActionEvent d){
	    		try{
	    			Map<Integer, Integer> tempMap = new HashMap<Integer, Integer>();
//	    			for(Integer id : signalMap.keySet()){
//	    				tempMap.put(id, Integer.parseInt(signalMap.get(id).getText()));
//	    			}
	    			interfejsSimGui.setSignalGen(tempMap);
	    		}catch(NumberFormatException nFE){
	    			nFE.printStackTrace();
	    		}
	    		simGui.repaintPicture();
	    	}
	    });
		
		cancel.addActionListener (new ActionListener (){
	    	public void actionPerformed (ActionEvent d){
	    		dispose();
	    	}
	    });
	}
}
