package gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import model.gui.Container;
import model.sim.ElementSim;
import elements.Takt;

public class InterfaceSimGui {
	
	private boolean change = true;
	private String simFile;
	private Container currentContainer;
	public int currentTact;
	private HashMap<Integer, Integer> memory;
	private int addrCount = 16;
	
	public InterfaceSimGui(){
		
	}
	
	public void addSimFile(String simFile){
		this.simFile = simFile;
	}
	
	public void initSimulation(String projectName){
		memory = new HashMap<Integer, Integer>();
		memory.put(0, 53);
		memory.put(1, 0);
		memory.put(2, 5);
		ElementSim.xMLParserSim(simFile, memory, projectName);
		          
		//Rade ((Registar)ElementSim.uzmiIzBazena(ElementSim.uzmiIdOznake("TIMEmainMem"))).postaviVrednost(2);
		reset();
	}
	
	public void nextTact(){
		((Takt)ElementSim.getElement(0)).sledeciTakt();
		currentTact++;
		change = false;
	}
	
	public void goToTact(int tact) {
		for (int i = 0; i < tact; i++) {
			nextTact();
		}
	}
	
	public void up(){
		Container newContainer = currentContainer.getParent();
		if(newContainer != null)
			currentContainer = newContainer;
	}
	
	public void instruction(){
		if(ElementSim.getElement(ElementSim.getMarkId("T0")).getValue(0) == 1){
			((Takt)ElementSim.getElement(1)).sledeciTakt();
			if(ElementSim.getElement(ElementSim.getMarkId("T0")).getValue(0) == 1)
				return;
			else
				while(ElementSim.getElement(ElementSim.getMarkId("T0")).getValue(0) == 0)
					((Takt)ElementSim.getElement(1)).sledeciTakt();
		}else
			while(ElementSim.getElement(ElementSim.getMarkId("T0")).getValue(0) == 0)
				((Takt)ElementSim.getElement(1)).sledeciTakt();
	}
	
	public void program(){
		while(ElementSim.getElement(ElementSim.getMarkId("T0")).getValue(0) == 1)
			((Takt)ElementSim.getElement(1)).sledeciTakt();
	}
	
	public void reset(){
		currentTact = 0;
		ElementSim.reset();
	}

	public void setCurrentContainer(Container container){
		currentContainer = container;
	}
	
	public Container getCurrentContainer(){
		return currentContainer;
	}
	
	public boolean getChange(){
		boolean ret = change;
		change = true;
		return ret;
	}
	
	public HashMap<Integer, Integer> getMemory(){
		int memId = ElementSim.getMarkId("mainMem");
		if(memId != -1){			
			return ((elements.Memory)ElementSim.getElement(memId)).getMemory();
		}else{
			return memory;
		}
	}
	
	// ne koristi se
	public void refreshMemory(){
		Object monitor = ElementSim.getElement(1000);
		synchronized(monitor){
			try{
				monitor.wait();
			}catch(InterruptedException iE){
			}
		}
	}
	
	public void setMemory(String fileName){
//		HashMap<Integer, Integer> newMemory = new HashMap<Integer, Integer>();
		try{
			String[] str;
			int address, value;
			FileReader fr = new FileReader(fileName);
			BufferedReader br = new BufferedReader(fr);
			String line;
			while((line = br.readLine()) != null){
				str = line.split(" ");
				if(str.length < 2){
					continue;
				}
				address = Integer.parseInt(str[0], 16);
				value = Integer.parseInt(str[1], 16);
				memory.put(address, value);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		int memId = ElementSim.getMarkId("mainMem");
		if(memId != -1){
			((elements.Memory)ElementSim.getElement(memId)).setMemory(memory);
			reset();
		}
//		System.out.println("Memorija: " + memory.toString());
	}
	
//	public void setRegisters(int  pc, int sp, int ivtp, int imr){
//		((elements.Register)ElementSim.getElement(15)).postaviVrednost(pc);
//		((elements.Register)ElementSim.getElement(413)).postaviVrednost(sp);
//		((elements.Register)ElementSim.getElement(580)).postaviVrednost(ivtp);
//		((elements.Register)ElementSim.getElement(537)).postaviVrednost(imr);
//		reset();
//	}
	
	public void setRegisters(Map<Integer, Integer> registers){
		for(Integer id : registers.keySet()){
			((elements.Register)ElementSim.getElement(id)).postaviVrednost(registers.get(id));
		}
		reset();
	}
	
	public void setSignalGen(Map<Integer, Integer> signals){
		for(Integer id : signals.keySet()){
			((elements.Dynamicconnector)ElementSim.getElement(id)).setValue(signals.get(id));
		}
	}
	
	public int getCurrentTact(){
		for(int i=0; i <= 0xdf; i++)
			if(ElementSim.getElement(ElementSim.getMarkId("T"+Integer.toString(i, 16))).getValue(0) == 1)
				return i;
		return 0;
	}
	
	public int getAddrCount(){
		return addrCount;
	}

	public void setAddrCount(int addrCount){
		this.addrCount = addrCount;
	}
}