package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import model.sim.ElementSim;

class InitRegister extends JFrame {
	private static final long serialVersionUID = 1L;

	private InterfaceSimGui interfejsSimGui;
	private JPanel panel;
	private Map<Integer, JTextField> regMap = new HashMap<Integer, JTextField>(); 
	
	private JButton ok = new JButton("Ok");
	private JButton cancel = new JButton("Cancel");
	
	public InitRegister(InterfaceSimGui iinterfejsSimGui){
		super("Inicijalizacij registara");
		interfejsSimGui = iinterfejsSimGui;
		
		panel = new JPanel();
		JPanel panel2 = new JPanel();
		add(panel, "Center");
		panel.setLayout(null);
		int y = -20;
		for(String reg : ElementSim.getRegisters().keySet()){
			y += 40;
			JLabel label = new JLabel(reg + ":");
			panel.add(label);
			label.setBounds(30, y, 50, 30);
			JTextField textField = new JTextField(ElementSim.getRegister(reg)+"");
			panel.add(textField);
			textField.setHorizontalAlignment(0);
			textField.setBounds(80, y, 100, 30);
			regMap.put(ElementSim.getRegister(reg), textField);
		}
		
		panel2.add(ok);
		panel2.add(cancel);
		ok.setText("Ok");
		ok.setPreferredSize(new java.awt.Dimension(75, 30));
		cancel.setText("Cancel");
        cancel.setPreferredSize(new java.awt.Dimension(75, 30));
		add(panel2, "South");
		
		setLocation(300,100);
		setSize(300,400);
		
		ok.addActionListener (new ActionListener (){
	    	public void actionPerformed (ActionEvent d){
	    		try{
	    			Map<Integer, Integer> tempMap = new HashMap<Integer, Integer>();
	    			for(Integer id : regMap.keySet()){
	    				tempMap.put(id, Integer.parseInt(regMap.get(id).getText(), 16));
	    			}
	    			interfejsSimGui.setRegisters(tempMap);
	    		}catch(NumberFormatException nFE){
	    		}
	    	}
	    });
		
		cancel.addActionListener (new ActionListener (){
	    	public void actionPerformed (ActionEvent d){
	    		dispose();
	    	}
	    });
	}
}
