package elements;

import model.sim.*;

import java.util.*;

public class Memory extends SekElemSim {
	private HashMap<Integer, Integer> pocetnaVrednost;
	
	private HashMap<Integer, Integer> vrednost;
	
	private int vrednostR = 0;
	private int vrednostW = 0;
	private int vrednostABUS = 0;
	private int vrednostDBUS = 0;
	/*
	ulazi: 	0 - RDBUS; 1 - WRBUS; 2 - ABUS; 3 - DBUS
	izlazi:	 0 - DBUS;
	*/
	
	public Memory(int id, int[] ulazi, int[] izlazi, HashMap<Integer, Integer> vrednost){
		super(id, ulazi, izlazi, 0, 0, "");
		pocetnaVrednost = (HashMap<Integer, Integer>)vrednost.clone();
		this.vrednost = (HashMap<Integer, Integer>)vrednost.clone();//!!!
	}
	
	//privremeno
	public Memory(int id, int[] ulazi, int[] izlazi, int vrednost, int brLinija, String oznaka){
		super(id, ulazi, izlazi, vrednost, brLinija, oznaka);
		this.vrednost = new HashMap<Integer, Integer>();
		this.vrednost.put(0, 0);
		this.vrednost.put(1, 1);
		this.vrednost.put(2, 2);
	}
	
	public void execute(){			
		if (getElement(ins[0]).getValue(id) == 1 && vrednostR == 0){
			changingList.addElement(getElement(outs[0]));					
		}
		if (getElement(ins[1]).getValue(id) == 1 && vrednostW == 0){
			vrednost.put(new Integer (getElement(ins[2]).getValue(id)),new Integer(getElement(ins[3]).getValue(id)) );					
		}			
	
		if (getElement(ins[2]).getValue(id) != vrednostABUS){
			vrednostABUS = getElement(ins[2]).getValue(id);
			vrednostDBUS = getElement(ins[3]).getValue(id);
			vrednostR = 0;
			vrednostW = 0;
			execute();
		}
		
		if (getElement(ins[3]).getValue(id) != vrednostDBUS){			
			vrednostDBUS = getElement(ins[3]).getValue(id);			
			vrednostW = 0;
			execute();
		}
		
		vrednostR = getElement(ins[0]).getValue(id);
		vrednostW = getElement(ins[1]).getValue(id);
		
					
	}
	
	public int getValue(int iid){
		if(getElement(ins[0]).getValue(id) == 1){
			Integer vvrednost = (Integer)vrednost.get(new Integer(getElement(ins[2]).getValue(id)));
			if (vvrednost == null)
				return 0;
			else
				return vvrednost.intValue();
		}else 
			return 0;
		
	}
	
	public HashMap<Integer, Integer> getMemory(){
		return vrednost;
	}
	
	public void setMemory(HashMap<Integer, Integer> memory){
		pocetnaVrednost = (HashMap<Integer, Integer>)memory.clone();
		vrednost = (HashMap<Integer, Integer>)memory.clone();
	}
	
	public void init(){
//		vrednost = (Hashtable<Integer, Integer>) pocetnaVrednost.clone();//!!!
		
	}

}
