using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Model;

namespace WebAPIDemo
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            /*
            Ovo je metoda koja se koristi za konfiguraciju opcija koje WebAPI podrzava.
            Stoga, baza podataka se konfigurise ovde. U JSON fajlu appsettings.json dodat je novi atribut
            koji se zove ConnectionString koji i sam predstavlja JSON objekat. Ovom fajlu moze se pristupiti
            preko Configuration polja ove klase, a objektu ConnectionStrings pomocu metode GetConnectionString
            ovog polja. Polja ConnectionString objekta su stringovi koji se koriste prilikom povezivanja sa bazom
            podataka i konkretno polje se dohvata tako sto se njegov naziv prosledi kao parametar metode.
            */
            services.AddDbContext<Context> (
                options => options.UseMySQL ( Configuration.GetConnectionString ( "UserDatabase" ) )
            );
            services.AddControllers()
            // Ukoliko postoji problem sa serijalizacijom odgovora dodati ovaj poziv.
            .AddNewtonsoftJson (
                options => options.SerializerSettings.ReferenceLoopHandling = Newtonsoft.Json.ReferenceLoopHandling.Ignore
            );
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            app.UseHttpsRedirection();

            app.UseRouting();

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }
    }
}
