﻿using System;
using System.Linq;
using ConventionalModel;
using Microsoft.EntityFrameworkCore;
using UnconventionalModelWithAttributes;
using UnconventionalModelWithFluentAPI;

namespace EntityFrameworkDemo
{
    class Program
    {
        // Primer upotrebe kada se prate podrazumevana pravila.
        static void ConventionalModelExample ( ) {
            using ( ConventionalContext context = new ConventionalContext ( ) ) {
                /*
                Za izvrsavanje upita se koristi Fluent API pomocu kojeg se formiraju SQL upiti.
                Na primer context.users.ToList ( ) ce izgenerisati upit "SELECT * FROM users". 
                */
                foreach ( User user in context.users.ToList ( ) ) { Console.WriteLine ( user ); }
                foreach ( Role role in context.roles.ToList ( ) ) { Console.WriteLine ( role ); }
                foreach ( HasRole hasRole in context.hasRole.ToList ( ) ) { Console.WriteLine ( hasRole ); }
                foreach (ConventionalModel.Action action in context.actions.ToList ( ) ) { Console.WriteLine ( action ); }

                /*
                Where - dodaje where klauzulu SQL upitu
                First - vraca prvi red iz rezultujuce tabele ili baca izuzetak ukoliko nema rezultata
                FirstOrDefaul - vraca prvi red iz rezultujuce tabele ili null ukoliko nema rezultata
                Find - nalazi red u tabeli na osnovu kljuca koji se prosledjuje kao parametar ili vraca null ukoliko takav red ne postoji
                */
                User userFirst              = context.users.Where ( user => user.id == 5 ).First ( );
                User userFirstOrDefault     = context.users.Where ( user => user.id == 5 ).FirstOrDefault ( );
                User userFirstWithPredicate = context.users.First ( user => user.id == 5 );
                User userFind               = context.users.Find ( 5 );

                Console.WriteLine ( userFirst );
                Console.WriteLine ( userFirstOrDefault );
                Console.WriteLine ( userFirstWithPredicate );
                Console.WriteLine ( userFind );
            }
        }

        // Primer upotrebe kada se ne prate podrazumevana pravila, vec se mapiranje realizuje pomocu atributa
        static void UnconventionalContextWithAttributesExample ( ) {
            using ( UnconventionalContextWithAttributes context = new UnconventionalContextWithAttributes ( ) ) {
                // EF Core ne ucitava veze prilikom dohvatanja podataka iz baze.
                UnconventionalModelWithAttributes.Korisnik korisnik5 = context.korisnici.Find ( 5 );

                // Ova naredba ispisuje "True True".
                Console.WriteLine ( ( korisnik5.imaUloguList == null ) + " " + ( korisnik5.akcijaList == null ) );

                // Jedan od nacina da se i veze ucitaju jeste koriscenjem Include i ThenInclude.
                // Include metoda ukljucuje entitete iz narednog nivoa u hijerarhiji, dok ThenInclude moze da se koristi za
                // sve ostale nivoe. Metode kao parametre primaju polja klase koje neophodno ucitati.
                UnconventionalModelWithAttributes.Korisnik korisnik6 = context.korisnici.Include ( k => k.akcijaList )
                                                    .Include ( k => k.imaUloguList )
                                                        .ThenInclude ( i => i.uloga ) 
                                                    .First ( k => k.kljuc == 6 );
                Console.WriteLine ( korisnik6 );
                Console.WriteLine ( "Uloge korisnika: ");
                foreach (UnconventionalModelWithAttributes.ImaUlogu i in korisnik6.imaUloguList ) {
                    Console.WriteLine ( "\t" + i.uloga );
                }
                Console.WriteLine ( "Akcije korisnika: ");
                foreach (UnconventionalModelWithAttributes.Akcija a in korisnik6.akcijaList ) {
                    Console.WriteLine ( "\t" + a );
                }
            }

        }

        static void UnconventionalContextWithFluentAPIExample ( ) {
            using ( UnconventionalContextWithFluentAPI context = new UnconventionalContextWithFluentAPI ( ) ) {
                UnconventionalModelWithFluentAPI.Korisnik korisnik5 = context.korisnici.Include ( k => k.imaUloguList )
                                                                                            .ThenInclude ( i => i.uloga )
                                                                                        .Include ( k => k.akcijaList )
                                                                                        .First ( k => k.kljuc == 5 );
                Console.WriteLine ( korisnik5 );
                Console.WriteLine ( "Uloge korisnika: ");
                foreach (UnconventionalModelWithFluentAPI.ImaUlogu i in korisnik5.imaUloguList ) {
                    Console.WriteLine ( "\t" + i.uloga );
                }
                Console.WriteLine ( "Akcije korisnika: ");
                foreach (UnconventionalModelWithFluentAPI.Akcija a in korisnik5.akcijaList ) {
                    Console.WriteLine ( "\t" + a );
                }
            }
        }
        static void Main(string[] args)
        {
            Console.WriteLine("Hello World!");

            // ConventionalModelExample ( );
            // UnconventionalContextWithAttributesExample ( );
            UnconventionalContextWithFluentAPIExample ( );
        }
    }
}
