# -*- coding: utf-8 -*-

# ...
# Prethodi implementacioni kod (radi se o programu za obradu datoteka)

# Ispravna realizacija interaktivnog konzolnog menija, upotrebom rečnika
# U rečniku se kao vrednosti čuvaju funkcije koje treba pozvati
# Kada korisnik izabere opciju, ona se tretira kao ključ i za nju se traži
# vrednost u rečniku (tj. funkcija), a onda se ona poziva
# Npr. options[4]() -> poziva funkciju save()
options = {1: insert,
           2: show,
           3: remove,
           4: save,
           5: points,
           6: distribution,
           7: exit}

# Ako bi    (v) ovde stajao znak \, zanemario bi se newline na početku stringa
message = """
Izabrati operaciju od 1 do 7:
1. Dodavanje podataka
2. Prikazivanje podataka
3. Brisanje podataka
4. Cuvanje podataka u datoteku
5. Racunanje broja poena svih studenata
6. Racunanje raspodele broja poena
7. Izlazak iz programa
"""

def menu():
    """Funkcija menija koja ispisuje ponuđene opcije korisniku, učitava izbor,
    a potom i poziva odabranu funkciju iz rečnika. Ispisuje grešku ako je izbor
    van opsega ili nije unet broj.
    """
    choice = raw_input(message)  # Pošto hoćemo da indeksiramo nečim što niti
    try:                         # znamo da li je u opsegu, niti znamo da li
        options[int(choice)]()   # je uopšte broj, moramo da obradimo izuzetne
    except KeyError:             # slučajeve - exceptions
        print("Pogresan odabir")  # Ako se javi KeyError, znači da je unet broj
    except ValueError:           # ali da u rečniku nije postojao taj ključ
        print("Neispravan unos")  # Ako se javi ValueError, znači da je došlo
                                 # greške u konverziji - tj. nije unet broj


# Glavni program
if __name__ == '__main__':
    from time import sleep  # Koristi se za pravljenje pauze izmedju ispisa
    load()  # Ucitava potrebne podatke iz datoteka i sprema ih za obradu

    while True:
        menu()      # Poziva se meni
        sleep(1.5)  # Pravi se pauza
        #print("")
