# -*- coding: utf-8 -*-

from pprint import pprint  # Koristićemo pretty printer za štampanje rečnika

jmbg_len = 13  # Svi JMBG su u formatu DDMMGGGRRBBBK - 13 cifara


def jmbg_add(JMBGdict):
    """Dodaje novu osobu u JMBG rečnik.
    Ispisuje grešku ako osoba već postoji ili JMBG nije ispravan.
    """
    jmbg = input("Uneti JMBG: ")

    if jmbg in JMBGdict:
        print ("Ta osoba već postoji!")
        return
    elif len(jmbg) != jmbg_len or not jmbg.isdigit():
        # JMBG pogrešne dužine ili sadrži znak koji nije cifra
        print ("JMBG nije ispravno unet")
        return

    # Rečnik sa podacima se direktno navodi, za podatke se traži unos korisnika
    data = {
        'name':    input("Uneti ime: "),
        'surname': input("Uneti prezime: "),
        'dob':     "{}.{}.{}.".format(jmbg[:2], jmbg[2:4],
                                      ('2' if jmbg[4]=='0' else '1')+jmbg[4:7])
    }
    # Podaci o datumu rođenja se dobijaju iz JMBG-a
    # Za godinu se mora proveriti da li je u IXX ili XX veku
    # Rezultat izraza u zagradi zavisi od jmbg[4]=='0' - conditional statement
    # Ako je uslov tačan, na početak godine se nadovezuje '2', u suprotnom '1'

    JMBGdict[jmbg] = data  # Kao vrednost u rečnik JMBG upisujemo rečnik sa
                           # podacima - ugnežđeni rečnici
    print ("Osoba dodata")


def jmbg_remove(JMBGdict):
    """Briše osobu iz JMBG rečnika. Ispisuje grešku ako osoba sa traženim
    JMBG-om ne postoji.
    """
    jmbg = input("Uneti JMBG: ")

    if jmbg not in JMBGdict:
        print ("Ta osoba ne postoji!")
        return

    del JMBGdict[jmbg]  # Brisanje sa del kao kod liste
    print ("Osoba obrisana")


def jmbg_get(JMBGdict):
    """Nalazi i ispisuje podatke osobe sa datim JMBG-om. Ispisuje grešku ako
    osoba nije nađena.
    """
    jmbg = input("Uneti JMBG: ")

    if jmbg not in JMBGdict:
        print ("Osoba nije nađena")
        return

    pprint(JMBGdict[jmbg])  # Poziva pprint, štampa se rečnik sa podacima


def jmbg_print(JMBGdict):
    """Štampa čitav sadržaj JMBG rečnika."""
    print ("=== JMBG REČNIK ===")
    pprint(JMBGdict)  # Štampa ceo JMBG rečnik, uključujući sve rečnike u njemu
    print ("=== KRAJ REČNIKA ===")


def jmbg_clear(JMBGdict):
    """Briše čitav sadržaj JMBG rečnika."""
    JMBGdict.clear()
    print ("Rečnik ispražnjen")


# Ovo je višelinijski string (kao docstring, samo dodeljen promenljivoj)
# Svaki prelaz u novi red koji se navede između navodnika biće i u stringu
message = """
Odaberi opciju:
1. Dodaj osobu
2. Obriši osobu
3. Nađi podatke
4. Odštampaj sve
5. Obriši sve
6. Kraj
"""

# Glavni program
if __name__ == '__main__':
    JMBGdict = {}  # Na početku se pravi prazan rečnik

    while True:
        choice = int(input(message))  # Ovo je loše realizovano
                                          # Previše if/elif-ova, ružno
        if choice == 1:                   # Pošto u Python-u nema case naredba
            jmbg_add(JMBGdict)            # kao u nekim drugim jezicima, moramo
        elif choice == 2:                 # koristiti nešto drugo
            jmbg_remove(JMBGdict)
        elif choice == 3:                 # Rečnik je za tako nešto idealan!
            jmbg_get(JMBGdict)            # Videti 5.4-menu-dict.py
        elif choice == 4:
            jmbg_print(JMBGdict)
        elif choice == 5:
            jmbg_clear(JMBGdict)
        elif choice == 6:
            break
        else:
            print ("Pogresan unos")
