import  time # kada je potrebno koriscenje vremenskih funkcija, ovo je neophodno


def fib(n):
    """
    Rekurzivna implementacija racunanja Fibonacci-jevih brojeva
    """

    if n <= 1:
         ret = 1
    else:
        #print(n * ". " + "fib({})".format(n))  # vis
        ret = fib(n - 2) + fib(n - 1)
        #print(n * ". " + "fib({})".format(n))  # vis
    return ret

# tabela koja za redni broj fibonacci-jevog broja cuva njegovu vrednsot
# ovo nije lista, vec svaki element moze imati proizvoljan "kljuc"
fibtab={0:1, 1:1}

def fib_optimized(n):
    """
    Rekurzivna implementacija racunanja Fibonacci-jeivh brojeva, uz poboljsanje, putem
    pamcenja vrednosti F(n)
    """
    global fibtab # eksplicitno navodimo da koristimo globalnu promenljivu
    if n not in fibtab:

        # da vizuelizujemo kako idu pozivi. n tacaka, a potom fib(n)
        #print(n * ". " + "fib({})".format(n)) # vis

        # sracunati fib(n) ako ga nema u tabeli
        # Neko od prethodnih pokretanja je "ostavilo" vrednosti za f(n-1) i f(n-2).
        # ako nije, sracunace se rekurzivno

        f = fib_optimized(n - 1) + fib_optimized(n - 2)

        fibtab[n] = f # dodati ga u tabelu
        #print(n * ". " + "fib({})".format(n)) # vis
    return fibtab[n]
print("Obican rekurzivan poziv:\n")
fib(5)
print("\n")
print("Optimizovan rekurzivan poziv:\n")
fib_optimized(5)
print("\n")
print("==============================")
print("Obican rekurzivan poziv:\n")
fib(6)
print("\n")
print("Optimizovan rekurzivan poziv:\n")
fib_optimized(6)

print("\n")

totaltime1 = 0
totaltime2 = 0
for num in range(20, 40):
    t1 = time.time() # dohvata trenutnu vremensku oznaku
    fib(num) # poziva funkciju
    t2 = time.time() # dohvata trenutnu vremensku oznaku
    totaltime1 += t2 - t1 # dodaje proteklo vreme

    t1 = time.time()
    fib_optimized(num)
    t2 = time.time()
    totaltime2 += t2 - t1

#     #stampa vreme potrebno za standardnu
#     #rekurzivnu implementaciju i za poboljsanu implementaciju
    print("n=" + str(num), totaltime1, totaltime2)
