# -*- coding: utf-8 -*-

english_to_french = {'red':     ['rouge'],
                     'blue':    ['bleu'],
                     'day':     ['jour'],
                     'good':    ['bon'],
                     'open':    ['ouvrir'],
                     'close':   ['fermer', 'clore']}
# Pošto su mogući sinonimi, u vrednostima čuvamo liste mogućih prevoda

print (english_to_french['red'])  # Dohvatanje vrednost iz rečnika
print ("Tip ovog objekta (english_to_french): ", type(english_to_french))


import random

# Funkcija za nalaženje prevoda u rečniku
def get_translation(word):
    global english_to_french  # global jer koristimo globalnu promenljivu

    if word in english_to_french:  # Da li je vrednost u rečniku?
        lst = english_to_french[word]  # Bila bi greška (KeyError) kad bi se
                                       # bez testiranja dohvatalo
        return random.choice(lst)  # Nasumično bira jedan od ponuđenih prevoda
    else:
        print ("Désolé, le dictionnaire manque un mot pour {}.".format(word))
        return word  # Vraća prvobitnu reč jer prevod nije nađen


# Petlja za unos novih prevoda u rečnik
while True:
    word = input("Uneti novu reč na engleskom (\"dosta\" za kraj):\nen: ")
    if word == "dosta":
        break

    # Za reč na engleskom (word) učitamo reč na francuskom i dodamo kao prevod
    translation = input("fr: ")
    if word in english_to_french:  # Da li prevod za reč već postoji?
        english_to_french[word].append(translation)  # DA: Dodaj u listu
    else:
        english_to_french[word] = [translation]      # NE: Formiraj novu listu

print ("Rečnik posle izmena:\n", english_to_french)


# Petlja za prevod rečenica
while True:
    sentence = input("Uneti rečenicu za prevod (\"dosta\" za kraj):\n")
    if sentence == "dosta":
        break

    translation = []  # Prevedene reči ćemo čuvati u listi, pa ih onda spojiti
    
    for word in sentence.split(" "):  # Podelimo rečenicu na reči (razmaci!)
        translation.append(get_translation(word))  # Na trenutni prevod dodamo
                                                   # prevod tekuće reči
    print (" ".join(translation))  # Spajanje liste oko stringa (separatora)
