"""
Provera izuzetaka.
Racunanje kolicnika dva broja.
"""
print("=============================")
print("Racunanje kolicnika dva broja")
print("=============================")

"""
U ovoj petlji "forsiramo" korisnika da unese validan broj.
Cim korisnik unese broj, tj. linija koda "a = input("Unesite validan broj: ")"
ne baci izuzetak,prekinucemo izvrsavanje te petlje koristeci naredbu break
(do koje se dolazi nakon regularnog zavrsetka prethodne naredbe)
"""
while True:
    try:
        a = int(input("Unesite prvi broj: "))
        print("Prvi broj: {}".format(a))
        break
    except:
        print("*** Unesite validan broj!")

while True:
    try:
        b = int(input("Unesite drugi broj: "))
        print("Drugi broj: {}".format(b))
        break
    # moze se hvatati specifican izuzetak, npr.
    except ValueError:
        print("*** Unesite validan broj!")

try:
    """
    U Python 2.x, morali bismo da uradimo sledece:
    u slucaju da je korisnik uneo oba cela broja,
    koristimo konverziju u float da bismo prikazali
    kolicnik u decimalnom zapisu, a ne samo ceo deo.

    Python 3 podrazumevano daje realan broj za rezultat.
    """
    c = a / b
    # raise() # <-- namerno javljanje greske
except ZeroDivisionError:
    """
    Do greske u ispisu moze doci ukoliko je korisnik za delilac
    uneo broj 0. Kako deljenje nulom nije dozvoljeno, desio bi se
    izuzetak i prekid programa. To cemo preduhitriti u except bloku.
    """
    print("*** Nije dozvoljeno deljenje nulom!")
except:
    """
    Moze biti vise except blokova, pri cemu se izvrsava prvi
    koji odgovara izuzetku, te je dobra praksa prvo staviti
    "specificnije" greske.
    Pritom, "opsta" greska, tj. except bez eksplicitnog navodjenja
    MORA biti poslednji blok (pre eventualnog else-a).
    """
    print("*** Ne znamo sta se desilo ¯\_(ツ)_/¯ ***")
else:
    """
    else se pise nakon svih except blokova i izvrsava se samo ako
    nije bilo gresaka, tj. ako se nije uslo ni u jedan except blok.
    """
    # Prikazujemo formatiran ispis kolicnika.
    print("Kolicnik brojeva {} i {} je {:.5f}".format(a, b, c))