package mreza;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class PrikazMreze extends JFrame {
    
    private static int upleft_x = 100, upleft_y = 150;
    private static int broj= 0, kap = 10;
    private static PrikazMreze[] niz = new PrikazMreze [kap];
        
    private Mreza mreza;
    
    
    
    public PrikazMreze(Mreza m) {
        super ("Mreza [" + m.uzmiID() + "]");
        this.mreza = m;
        dodaj(this);
    }
    
    public void podesiVelicinu (int brojElemenata) {
        int sirina = PrikazElementa.PREFERRED_WIDTH * 8;
        int visina = (brojElemenata/8 + 1) * PrikazElementa.PREFERRED_HEIGHT + 100;
        setBounds (upleft_x, upleft_y, sirina, visina);
        if (upleft_x < 400){
            upleft_x += 40; upleft_y += 50;
        }
        else {
            upleft_x = 100; upleft_y = 150;
        }
    }
    
        
    private static void promeniKapacitet (int promena) {
        PrikazMreze[] pom = new PrikazMreze [kap + promena];
        for (int i = 0; i < broj; i++)
            pom[i] = niz[i];
        kap += promena;
        niz = pom;
    }
        
    private static void dodaj (PrikazMreze okvir) {
            if (broj == kap) promeniKapacitet(5);
            niz[broj++] = okvir;
        }
        
    private static void izbaci (PrikazMreze okvir) {
        for (int i = 0; i < kap; i++)
            if (niz[i] == okvir) {
                for (int j = i + 1 ; j < broj; j++)
                    niz[j-1] = niz[j];
                niz[--broj] = null;
                if (broj <= kap - 5) promeniKapacitet(-5);
                okvir.dispose();
                break;
            }
    }
        
    public static void izbaciSve () {
        for (int i = 0; i < broj; i++)
            niz[i].dispose();
        niz = null;
        broj = 0;
        }
    
    private class ProzorDogadjaj extends WindowAdapter {
        public void windowClosing (WindowEvent d) {
            izbaci ((PrikazMreze)(d.getSource()));
            dispose();
        }
    }
    
    public static void main (String[] varg) {
        PrikazMreze p = new PrikazMreze(null);
        p.show();
        p.setBounds (10, 10, 200, 300);
    }
}
