// MrezaTest.java - Rad kombinacione mreze

import mreza.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class MrezaTest extends JFrame {
    
    private Parser parser;
    private JTextField nazivMreze, interval;
    private PametnaOznaka trenutnoVreme;

    public MrezaTest () {
        super ("Simulator kombinacione mreze");
        setBounds (200, 200, 500, 130);
        getContentPane().setLayout (new BorderLayout());
        setResizable(false);
        DugmeAkcija osmatrac = new DugmeAkcija();
        { // panel za ucitavanje fajla sa opisom mreze
            JPanel panel = new JPanel (new FlowLayout ((int)LEFT_ALIGNMENT, 5, 5));
            nazivMreze = new JTextField ("d:/projekat/mreza/mreza.txt");
            nazivMreze.setPreferredSize(new Dimension (400, 26));
            nazivMreze.selectAll();
            panel.add (nazivMreze);
            JButton dugmeUcitaj = new JButton ("Ucitaj");
            dugmeUcitaj.addActionListener(osmatrac);
            panel.add (dugmeUcitaj);
            getContentPane().add (panel, BorderLayout.NORTH);
        }
        {
            JPanel panel = new JPanel (new FlowLayout ((int)LEFT_ALIGNMENT, 5, 5));
            JLabel ic = new JLabel ("Interval casovnika:");
            interval = new JTextField ("500");
            interval.setPreferredSize (new Dimension (60, 26));
            JLabel ms = new JLabel ("ms  ");
            JButton dugmePostavi = new JButton ("Postavi");
            dugmePostavi.addActionListener(osmatrac);
            panel.add (ic);
            panel.add (interval);
            panel.add (ms);
            panel.add (dugmePostavi);
            JButton dugmePrikazi = new JButton ("Prikazi");
            dugmePrikazi.addActionListener(osmatrac);
            panel.add (dugmePrikazi);
            JButton dugmeZamrzni = new JButton ("Zamrzni");
            dugmeZamrzni.addActionListener(osmatrac);
            panel.add (dugmeZamrzni);
            getContentPane().add (panel, BorderLayout.WEST);
        }
        {
            JPanel panel = new JPanel(new FlowLayout ((int)LEFT_ALIGNMENT, 5, 5));
            trenutnoVreme = new PametnaOznaka ("Trenutno vreme: ");
            Casovnik.instanca().dodaj(trenutnoVreme);
            panel.add(trenutnoVreme);
            getContentPane().add(panel, BorderLayout.SOUTH);
        }
        this.addWindowListener(new ProzorDogadjaj());
        Casovnik.instanca().start();
    }
    
    private class DugmeAkcija implements ActionListener {
        
        public void actionPerformed(ActionEvent e) {
            String akcija = ((JButton)(e.getSource())).getText();
            switch (akcija.charAt(1)){
                case 'c' : /* ucitaj */ 
                    parser = new Parser (Mreza.glavnaMreza, nazivMreze.getText());
                    parser.parsirajKasnjenje ();
                    parser.parsirajMrezu (Mreza.glavnaMreza);
                    Mreza.glavnaMreza.start();
                    nazivMreze.setText ("");
                    break;
                case 'o' : /* postavi */
                    try {
                        Casovnik.instanca().postaviInterval(Integer.parseInt(interval.getText()));
                    }
                    catch (NumberFormatException nfe) {
                        Casovnik.instanca().postaviInterval(100);
                    }
                    break;
                case 'r' : /* prikazi */ 
                    Mreza.glavnaMreza.prikaziMrezu().show();
                    break;
                case 'a':
                    Casovnik.instanca().stani();
                    ((JButton)(e.getSource())).setText ("Odmrzni");
                    trenutnoVreme.setText ("Trenutno vreme: <ZAMRZNUTO>");
                    break;
                case 'd':
                    Casovnik.instanca().kreni();
                    ((JButton)(e.getSource())).setText ("Zamrzni");
                    trenutnoVreme.setText ("Trenutno vreme:");
                    break;
                default:
            }
        }
        
    }
    
    private class PametnaOznaka extends JLabel implements IPosmatrac {
        
        private String fiksniDeo;
        private int vreme = 0;
        
        public PametnaOznaka (String s) {
            fiksniDeo = s;
            setText (fiksniDeo);
        }
        
        public void azuriraj(Subjekat subj) {
            vreme += ((Casovnik)subj).instanca().uzmiInterval();
            setText (fiksniDeo + vreme + " ms");
        }
        
    }
    
    private class ProzorDogadjaj extends WindowAdapter {
        public void windowClosing (WindowEvent d) {
            PrikazMreze.izbaciSve();
            dispose();
            System.exit(1);
        }
    }
    
    public static void main (String[] varg) {
        new MrezaTest().show();
    }

} // class MrezaTest