/*
 * Decompiled with CFR 0.152.
 */
package rs.ac.bg.etf.kdp;

import rs.ac.bg.etf.kdp.Linda;
import rs.ac.bg.etf.kdp.ToupleSpace;

public class Worker
implements Runnable {
    private static final double PRECISION = 1.0E-6;
    Linda linda = ToupleSpace.getLinda();
    int id;

    public Worker() {
        String[] stringArray = new String[2];
        stringArray[0] = "workerParameters";
        String[] workerParameters = stringArray;
        this.linda.in(workerParameters);
        this.id = Integer.parseInt(workerParameters[1]);
        String[] workerOutParameters = new String[]{"workerParameters", "" + (this.id + 1)};
        this.linda.out(workerOutParameters);
    }

    public void run() {
        boolean end = false;
        while (!end) {
            String[] getTask = new String[]{"getTask", "" + this.id};
            this.linda.out(getTask);
            String[] stringArray = new String[4];
            stringArray[0] = "request";
            stringArray[1] = "" + this.id;
            String[] request = stringArray;
            this.linda.in(request);
            double left = Double.parseDouble(request[2]);
            double right = Double.parseDouble(request[3]);
            if (left > right) {
                end = true;
                break;
            }
            double data = this.calcIntegral(left, right);
            String[] responce = new String[]{"responce", "" + data};
            this.linda.out(responce);
        }
    }

    private double calcIntegral(double left, double right) {
        double data = 0.0;
        if (left < right) {
            if (right - left < 1.0E-6) {
                data = (this.function(left) + this.function(right)) / 2.0;
                data *= right - left;
            } else {
                double midle = (left + right) / 2.0;
                data = this.calcIntegral(left, midle) + this.calcIntegral(midle, right);
            }
        }
        return data;
    }

    private double function(double x) {
        if (x > 1.0E-6) {
            return Math.exp(x) / x;
        }
        return 1.0;
    }
}

