/*
 * Decompiled with CFR 0.152.
 */
package rs.ac.bg.etf.kdp;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import rs.ac.bg.etf.kdp.Linda;

public class LocalLinda
implements Linda {
    ArrayList<String[]> tupleSpace;

    public LocalLinda() {
        if (this.tupleSpace == null) {
            this.tupleSpace = new ArrayList();
        }
    }

    public void eval(String name, Runnable thread) {
        Thread t = new Thread(thread, name);
        t.start();
    }

    public void eval(final String className, final Object[] initargs, final String methodName, final Object[] arguments) {
        Thread t = new Thread(){

            public void run() {
                try {
                    Class<?> threadClass = Class.forName(className);
                    Class[] parameterTypes = new Class[initargs.length];
                    int i = 0;
                    while (i < initargs.length) {
                        parameterTypes[i] = initargs[i].getClass();
                        ++i;
                    }
                    Constructor<?>[] constructors = threadClass.getConstructors();
                    Constructor<?> constructor = threadClass.getConstructor(parameterTypes);
                    Object runningThread = constructor.newInstance(initargs);
                    parameterTypes = new Class[arguments.length];
                    int i2 = 0;
                    while (i2 < arguments.length) {
                        parameterTypes[i2] = arguments[i2].getClass();
                        ++i2;
                    }
                    Method method = threadClass.getMethod(methodName, parameterTypes);
                    method.invoke(runningThread, arguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    public synchronized void in(String[] tuple) {
        boolean found = false;
        while (!found) {
            for (String[] data : this.tupleSpace) {
                if (!this.equals(tuple, data)) continue;
                this.fill(tuple, data);
                this.tupleSpace.remove(data);
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean inp(String[] tuple) {
        for (String[] data : this.tupleSpace) {
            if (!this.equals(tuple, data)) continue;
            this.fill(tuple, data);
            return true;
        }
        return false;
    }

    public synchronized void out(String[] tuple) {
        this.tupleSpace.add(tuple);
        this.notifyAll();
    }

    public synchronized void rd(String[] tuple) {
        boolean found = false;
        while (!found) {
            for (String[] data : this.tupleSpace) {
                if (!this.equals(tuple, data)) continue;
                this.fill(tuple, data);
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean rdp(String[] tuple) {
        for (String[] data : this.tupleSpace) {
            if (!this.equals(tuple, data)) continue;
            this.fill(tuple, data);
            return true;
        }
        return false;
    }

    private boolean equals(String[] a, String[] b) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < a.length) {
            if (a[i] != null) {
                match = match && a[i].equals(b[i]);
            }
            ++i;
        }
        return match;
    }

    private void fill(String[] a, String[] b) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == null) {
                a[i] = new String(b[i]);
            }
            ++i;
        }
    }
}

