/*
 * Decompiled with CFR 0.152.
 */
package komponente;

import komponente.GInitPin;
import komponente.GVisestukaAkcija;
import komponente.LogickaKomponenta;
import komponente.Pin;

public class ALU
extends LogickaKomponenta {
    private static long ID = 0L;
    private String myID = "ALU " + ID++;
    private Pin asr;
    private Pin add;
    private Pin and;
    private Pin inc;
    private Pin dec;
    private Pin sub;
    private Pin xor;
    private Pin not;
    private Pin or;
    private Pin transferX;
    private Pin C0;
    private Pin C16;

    public ALU() {
        super(2, 1);
    }

    @Override
    public boolean povezan() throws Exception {
        if (this.in[0] == null || this.in[1] == null || this.out[0] == null || this.asr == null || this.add == null || this.and == null || this.inc == null || this.dec == null || this.transferX == null || this.C0 == null || this.C16 == null) {
            throw new GInitPin();
        }
        return true;
    }

    public void setConnection(Pin[] ulaz1, Pin[] ulaz2, Pin izlaz, Pin asr, Pin add, Pin and, Pin inc, Pin dec, Pin transferX, Pin C0, Pin C16) throws Exception {
    }

    @Override
    public int fun() throws Exception {
        int iz;
        int akc = 0;
        if (this.asr.isBval()) {
            ++akc;
        }
        if (this.add.isBval()) {
            ++akc;
        }
        if (this.and.isBval()) {
            ++akc;
        }
        if (this.inc.isBval()) {
            ++akc;
        }
        if (this.dec.isBval()) {
            ++akc;
        }
        if (this.transferX.isBval()) {
            ++akc;
        }
        if (this.sub.isBval()) {
            ++akc;
        }
        if (this.xor.isBval()) {
            ++akc;
        }
        if (this.not.isBval()) {
            ++akc;
        }
        if (this.or.isBval()) {
            ++akc;
        }
        if (akc > 1) {
            throw new GVisestukaAkcija(akc);
        }
        if (akc == 0) {
            return 1;
        }
        int A = this.in[0].getIval();
        int B = this.in[1].getIval();
        if (this.xor.isBval()) {
            int ioutput = A ^ B;
            this.out[0].setIval(ioutput);
            return 1;
        }
        if (this.sub.isBval()) {
            int ioutput = A - B;
            this.out[0].setIval(ioutput);
            if (A > B) {
                this.C16.setBval(false);
            } else {
                this.C16.setBval(true);
            }
            return 1;
        }
        if (this.not.isBval()) {
            int ioutput = ~A;
            this.out[0].setIval(ioutput);
            return 1;
        }
        if (this.or.isBval()) {
            int ioutput = A | B;
            this.out[0].setIval(ioutput);
            return 1;
        }
        if (this.transferX.isBval()) {
            this.out[0].setIval(this.in[0].getIval());
            return 1;
        }
        if (this.add.isBval()) {
            int iz2 = A + B;
            int max = (int)(Math.pow(2.0, this.out[0].getBrlin()) - 1.0);
            boolean c16 = false;
            if (iz2 > max) {
                iz2 -= max + 1;
                c16 = true;
            }
            this.out[0].setIval(iz2);
            this.C16.setBval(c16);
            return 1;
        }
        if (this.dec.isBval()) {
            int iz3 = A - 1;
            int max = (int)(Math.pow(2.0, this.out[0].getBrlin()) - 1.0);
            boolean c16 = false;
            if (iz3 > max) {
                iz3 -= max + 1;
                c16 = true;
            }
            this.out[0].setIval(iz3);
            this.C16.setBval(c16);
            return 1;
        }
        if (this.inc.isBval()) {
            iz = A + 1;
            int max = (int)(Math.pow(2.0, this.out[0].getBrlin()) - 1.0);
            boolean c16 = false;
            if (iz == -1) {
                iz = max;
                c16 = true;
            }
            this.out[0].setIval(iz);
            this.C16.setBval(c16);
        }
        if (this.and.isBval()) {
            iz = A & B;
            this.out[0].setIval(iz);
        }
        if (this.asr.isBval()) {
            int pom = A;
            this.out[0].setIval(A >>= 1);
            this.C0.setBval(pom % 2 == 1);
            return 1;
        }
        return 1;
    }

    public void setPinX(Pin pin) throws Exception {
        this.setInputPins(0, pin);
    }

    public void setPinY(Pin pin) throws Exception {
        this.setInputPins(1, pin);
    }

    @Override
    public String getMyID() {
        return this.myID;
    }

    public String toString() {
        return this.myID;
    }

    public void setPinAdd(Pin add) {
        this.add = add;
    }

    public void setPinAnd(Pin and) {
        this.and = and;
    }

    public void setPinAsr(Pin asr) {
        this.asr = asr;
    }

    public void setPinC0(Pin c0) {
        this.C0 = c0;
    }

    public void setPinC16(Pin c16) {
        this.C16 = c16;
    }

    public void setPinDec(Pin dec) {
        this.dec = dec;
    }

    public void setPinInc(Pin inc) {
        this.inc = inc;
    }

    public void setPinTransferX(Pin transferX) {
        this.transferX = transferX;
    }

    public void setPinSub(Pin sub) {
        this.sub = sub;
    }

    public void setPinXor(Pin xor) {
        this.xor = xor;
    }

    public void setPinNot(Pin not) {
        this.not = not;
    }

    public void setPinOr(Pin or) {
        this.or = or;
    }
}

