/*
 * Decompiled with CFR 0.152.
 */
package komponente;

import komponente.GInitPin;
import komponente.GVisestukaAkcija;
import komponente.LogickaKomponenta;
import komponente.Pin;

public class Registar
extends LogickaKomponenta {
    private Pin CL;
    private Pin LD;
    private Pin inc;
    private Pin dec;
    private Pin shr;
    private Pin shl;
    private Pin prenost;
    private Pin IR;
    private Pin IL;
    private int vrednost = 0;
    private static long ID = 0L;
    private String myID = "REG " + ID++;
    private String ime;

    public Pin getLD() {
        return this.LD;
    }

    public Registar(int in, String ime) {
        super(in, in);
        this.ime = ime;
    }

    @Override
    public boolean povezan() throws Exception {
        if (this.CL == null || this.LD == null || this.inc == null || this.dec == null) {
            throw new GInitPin();
        }
        int i = 0;
        while (i < this.in.length) {
            if (this.in[i] == null) {
                throw new GInitPin();
            }
            ++i;
        }
        i = 0;
        while (i < this.out.length) {
            if (this.out[i] == null) {
                throw new GInitPin();
            }
            ++i;
        }
        return true;
    }

    public void setConnection(Pin[] pin, Pin[] pout, Pin clk, Pin dec, Pin inc, Pin ld) throws Exception {
        int i = 0;
        while (i < pin.length) {
            this.setInputPins(i, pin[i]);
            ++i;
        }
        i = 0;
        while (i < pout.length) {
            this.setOutputPins(i, pout[i]);
            ++i;
        }
        this.CL = clk;
        this.dec = dec;
        this.inc = inc;
        this.LD = ld;
    }

    @Override
    public int fun() throws Exception {
        if (this.corection() == 0) {
            this.postaviOut();
        }
        if (this.CL != null && this.CL.isBval()) {
            int i = 0;
            while (i < this.out.length) {
                if (this.out[i] != null) {
                    this.out[i].clir();
                }
                this.vrednost = 0;
                ++i;
            }
            return 1;
        }
        if (this.LD != null && this.LD.isBval()) {
            this.vrednost = this.procitajIn();
            this.postaviOut();
            return 1;
        }
        if (this.shl != null && this.shl.isBval()) {
            this.vrednost <<= 1;
            if (this.IL != null && this.IL.isBval()) {
                this.vrednost |= 1;
            }
            this.postaviOut();
            return 1;
        }
        if (this.shr != null && this.shr.isBval()) {
            this.vrednost >>= 1;
            if (this.IR != null && this.IR.isBval()) {
                this.vrednost |= (int)Math.pow(2.0, this.in[0].getBrlin() - 1);
            }
            this.postaviOut();
            return 1;
        }
        if (this.inc != null && this.inc.isBval()) {
            if (this.in[0].isSingl()) {
                ++this.vrednost;
                if (this.vrednost % (int)Math.pow(2.0, this.in.length) == 0) {
                    this.vrednost = 0;
                    this.prenost.setBval(true);
                } else {
                    this.prenost.setBval(false);
                }
            } else {
                ++this.vrednost;
                if (this.vrednost % (int)Math.pow(2.0, this.in[0].getBrlin()) == 0) {
                    this.vrednost = 0;
                    this.prenost.setBval(true);
                } else {
                    this.prenost.setBval(false);
                }
            }
            this.postaviOut();
            return 1;
        }
        if (this.dec != null && this.dec.isBval()) {
            if (this.vrednost > 0) {
                --this.vrednost;
                this.prenost.setBval(false);
            } else {
                this.vrednost = (int)Math.pow(2.0, this.in.length);
                this.prenost.setBval(true);
            }
            this.postaviOut();
            return 1;
        }
        this.postaviOut();
        return 1;
    }

    private int corection() throws Exception {
        int val = 0;
        if (this.CL != null && this.CL.isBval()) {
            ++val;
        }
        if (this.dec != null && this.dec.isBval()) {
            ++val;
        }
        if (this.inc != null && this.inc.isBval()) {
            ++val;
        }
        if (this.LD != null && this.LD.isBval()) {
            ++val;
        }
        if (val > 1) {
            throw new GVisestukaAkcija(val);
        }
        return val;
    }

    private void postaviOut() throws Exception {
        if (this.in[0] != null && this.in[0].isSingl()) {
            int priv = this.vrednost;
            int j = 0;
            while (j < this.out.length) {
                int mod = priv % 2;
                priv /= 2;
                if (this.out[j] != null && mod == 1) {
                    this.out[j].setBval(true);
                } else {
                    this.out[j].setBval(false);
                }
                ++j;
            }
        } else if (this.out[0] != null) {
            this.out[0].setIval(this.vrednost);
        }
    }

    private int procitajIn() throws Exception {
        if (this.in[0] != null && this.in[0].isSingl()) {
            int suma = 0;
            int j = 0;
            while (j < this.in.length) {
                if (this.in[j] != null && this.in[j].isBval()) {
                    suma = (int)((double)suma + Math.pow(2.0, j));
                }
                ++j;
            }
            return suma;
        }
        return this.in[0].getIval();
    }

    public void setPinInc(Pin inc) {
        this.inc = inc;
    }

    public void setPinDec(Pin dec) {
        this.dec = dec;
    }

    public void setPinCL(Pin CL) {
        this.CL = CL;
    }

    public void setPinLd(Pin LD) {
        this.LD = LD;
    }

    public String getIme() {
        return this.ime;
    }

    @Override
    public String getMyID() {
        return this.myID;
    }

    public String toString() {
        return "Registar: " + this.ime + " ID: " + this.myID;
    }

    public int getVal() {
        return this.vrednost;
    }

    public void setVal(int vr) throws Exception {
        this.vrednost = this.in[0].isSingl() ? vr % (int)Math.pow(2.0, this.in.length) : vr % (int)Math.pow(2.0, this.in[0].getBrlin());
        this.postaviOut();
    }

    public void setIme(String ime) {
        this.ime = ime;
    }

    public Pin getShr() {
        return this.shr;
    }

    public void setShr(Pin shr) {
        this.shr = shr;
    }

    public Pin getShl() {
        return this.shl;
    }

    public void setShl(Pin shl) {
        this.shl = shl;
    }

    public Pin getPrenost() {
        return this.prenost;
    }

    public void setPrenost(Pin prenost) {
        this.prenost = prenost;
    }

    public Pin getIR() {
        return this.IR;
    }

    public void setIR(Pin ir) {
        this.IR = ir;
    }

    public Pin getIL() {
        return this.IL;
    }

    public void setIL(Pin il) {
        this.IL = il;
    }

    public Pin getCL() {
        return this.CL;
    }

    public Pin getInc() {
        return this.inc;
    }

    public Pin getDec() {
        return this.dec;
    }
}

