/*
 * Decompiled with CFR 0.152.
 */
package GUIIzgled.Akcija;

import GUIIzgled.GuiTag_Data;
import GUIIzgled.OsnovaGUI;
import Utility.Usluge;
import java.util.StringTokenizer;
import komponente.DFF;
import komponente.LogickaKomponenta;
import komponente.Memorija;
import komponente.RSFF;
import komponente.Registar;
import komponente.SegmentnaTAB;
import komponente.StranicnaTAB;
import komponente.TAG;
import komponente.TFF;
import komponente.TagData;
import komponente.TagDataSegmentna;
import myIO.myFile;

public class Loader {
    private myFile izvoristeSimulacije;
    private OsnovaGUI komponente;
    private RSFF[] rsffV;
    private RSFF[] rsffD;

    public Loader(myFile izvoristeSimulacije, OsnovaGUI komponente) {
        this.izvoristeSimulacije = izvoristeSimulacije;
        this.komponente = komponente;
    }

    public void setRSFF(RSFF[] rsffV, RSFF[] rsffD) {
        this.rsffV = rsffV;
        this.rsffD = rsffD;
    }

    public boolean load() {
        try {
            this.izvoristeSimulacije.open('r');
            String simulacija = "";
            while (!this.izvoristeSimulacije.EOF()) {
                simulacija = String.valueOf(simulacija) + this.izvoristeSimulacije.readLine() + "\n";
            }
            this.izvoristeSimulacije.close();
            String prev = "";
            prev = simulacija;
            this.izvoristeSimulacije = new myFile("TMPFILE");
            this.izvoristeSimulacije.open('w');
            this.izvoristeSimulacije.writeString(prev);
            this.izvoristeSimulacije.close();
            this.izvoristeSimulacije.open('r');
        }
        catch (Exception e1) {
            e1.printStackTrace();
            Usluge.showMsgErr("Gre\u0161ka prilikom otvaranja fajla!");
            return false;
        }
        this.resetujKola();
        boolean povretakDN = false;
        block2 : switch (this.komponente.getTipVirtMem()) {
            case 0: {
                switch (this.komponente.getTipPres()) {
                    case 0: {
                        povretakDN = this.SegmentnaAsocijativna();
                        break;
                    }
                    case 1: {
                        povretakDN = this.SegmentnaDirektna();
                        break;
                    }
                    case 2: {
                        povretakDN = this.SegmentnaSetAsocijativna();
                    }
                }
                break;
            }
            case 1: {
                switch (this.komponente.getTipPres()) {
                    case 0: {
                        povretakDN = this.StranicnaAsocijativna();
                        break;
                    }
                    case 1: {
                        povretakDN = this.StranicnaDirektna();
                        break;
                    }
                    case 2: {
                        povretakDN = this.StranicnaSetAsocijativna();
                    }
                }
                break;
            }
            case 2: {
                switch (this.komponente.getTipPres()) {
                    case 0: {
                        povretakDN = this.SegmentnoStranicnaAsocijativna();
                        break block2;
                    }
                    case 1: {
                        povretakDN = this.SegmentnoStranicnaDirektna();
                        break block2;
                    }
                    case 2: {
                        povretakDN = this.SegmentnoStranicnaSetAsocijativna();
                    }
                }
            }
        }
        try {
            this.izvoristeSimulacije.close();
            this.izvoristeSimulacije.delete();
            this.izvoristeSimulacije = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Gre\u0161ka prilikom zatvaranja fajla!");
            povretakDN = false;
        }
        return povretakDN;
    }

    private void resetujKola() {
        try {
            for (Registar reg : this.komponente.getSviRegistri()) {
                reg.setVal(0);
            }
            for (LogickaKomponenta logk : this.komponente.getSviFlipflopovi()) {
                if (logk instanceof RSFF) {
                    ((RSFF)logk).clear();
                }
                if (logk instanceof DFF) {
                    ((DFF)logk).clear();
                }
                if (!(logk instanceof TFF)) continue;
                ((TFF)logk).clear();
            }
        }
        catch (Exception er) {
            er.printStackTrace();
        }
    }

    private boolean SegmentnaAsocijativna() {
        block9: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("0 0")) break block9;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.setSegmentnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA")) {
                Memorija data1 = null;
                Memorija data2 = null;
                Memorija data3 = null;
                for (Memorija lk : this.komponente.getSveMemorijaKom()) {
                    if (lk.getIme().equals("DATA1")) {
                        data1 = lk;
                        data1.clear();
                    }
                    if (lk.getIme().equals("DATA2")) {
                        data2 = lk;
                        data2.clear();
                    }
                    if (!lk.getIme().equals("DATA3")) continue;
                    data3 = lk;
                    data3.clear();
                }
                TAG tag = null;
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TAG)) continue;
                    tag = (TAG)lk;
                    tag.clear();
                    break;
                }
                int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                brlinija = brlinija > tag.getVelicina() ? tag.getVelicina() : brlinija;
                int i = 0;
                while (i < brlinija) {
                    String tabElement = this.izvoristeSimulacije.readLine();
                    StringTokenizer sttagElem = new StringTokenizer(tabElement);
                    int v = Integer.parseInt(sttagElem.nextToken());
                    int d = Integer.parseInt(sttagElem.nextToken());
                    int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                    String[] data = GuiTag_Data.parsirajVred(sttagElem.nextToken());
                    int idata1 = Usluge.toDec("0x" + data[0]);
                    int idata2 = Usluge.toDec("0x" + data[1]);
                    int idata3 = Usluge.toDec("0x" + data[2]);
                    this.rsffV[i].getOut()[0].setBval(v == 1);
                    this.rsffV[i].getOut()[1].setBval(v != 1);
                    this.rsffD[i].getOut()[0].setBval(d == 1);
                    this.rsffD[i].getOut()[1].setBval(d != 1);
                    tag.setVrednost(itag, i);
                    data1.addVal(i, idata3);
                    data2.addVal(i, idata2);
                    data3.addVal(i, idata1);
                    ++i;
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private boolean SegmentnaDirektna() {
        block6: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("0 1")) break block6;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.setSegmentnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA")) {
                TagDataSegmentna tds = null;
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagDataSegmentna)) continue;
                    tds = (TagDataSegmentna)lk;
                    tds.clear();
                }
                int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                brlinija = brlinija > tds.getVelicina() ? tds.getVelicina() : brlinija;
                int i = 0;
                while (i < brlinija) {
                    String tabElement = this.izvoristeSimulacije.readLine();
                    StringTokenizer sttagElem = new StringTokenizer(tabElement);
                    int v = Integer.parseInt(sttagElem.nextToken());
                    int d = Integer.parseInt(sttagElem.nextToken());
                    int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                    String data = sttagElem.nextToken();
                    this.rsffV[i].getOut()[0].setBval(v == 1);
                    this.rsffV[i].getOut()[1].setBval(v != 1);
                    this.rsffD[i].getOut()[0].setBval(d == 1);
                    this.rsffD[i].getOut()[1].setBval(d != 1);
                    tds.setData(data, i);
                    tds.setTag(itag, i);
                    ++i;
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private boolean SegmentnaSetAsocijativna() {
        block11: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("0 2")) break block11;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.setSegmentnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            TagDataSegmentna tagdata0 = null;
            int cnt = 0;
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA0")) {
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagDataSegmentna) || ++cnt != 2) continue;
                    tagdata0 = (TagDataSegmentna)lk;
                    tagdata0.clear();
                    break;
                }
                if (tagdata0 != null) {
                    int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                    brlinija = brlinija > tagdata0.getSize() ? tagdata0.getSize() : brlinija;
                    int i = 0;
                    while (i < brlinija) {
                        String tabElement = this.izvoristeSimulacije.readLine();
                        StringTokenizer sttagElem = new StringTokenizer(tabElement);
                        int v = Integer.parseInt(sttagElem.nextToken());
                        int d = Integer.parseInt(sttagElem.nextToken());
                        int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                        String data = sttagElem.nextToken();
                        this.rsffV[i].getOut()[0].setBval(v == 1);
                        this.rsffV[i].getOut()[1].setBval(v != 1);
                        this.rsffD[i].getOut()[0].setBval(d == 1);
                        this.rsffD[i].getOut()[1].setBval(d != 1);
                        tagdata0.setData(data, i);
                        tagdata0.setTag(itag, i);
                        ++i;
                    }
                }
            }
            TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            TagDataSegmentna tagdata1 = null;
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA1")) {
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagDataSegmentna) || tagdata0 == lk) continue;
                    tagdata1 = (TagDataSegmentna)lk;
                    tagdata1.clear();
                    break;
                }
                if (tagdata1 != null) {
                    int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                    brlinija = brlinija > tagdata1.getSize() ? tagdata1.getSize() : brlinija;
                    int i = 0;
                    while (i < brlinija) {
                        String tabElement = this.izvoristeSimulacije.readLine();
                        StringTokenizer sttagElem = new StringTokenizer(tabElement);
                        int v = Integer.parseInt(sttagElem.nextToken());
                        int d = Integer.parseInt(sttagElem.nextToken());
                        int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                        String data = sttagElem.nextToken();
                        this.rsffV[i + 4].getOut()[0].setBval(v == 1);
                        this.rsffV[i + 4].getOut()[1].setBval(v != 1);
                        this.rsffD[i + 4].getOut()[0].setBval(d == 1);
                        this.rsffD[i + 4].getOut()[1].setBval(d != 1);
                        tagdata1.setData(data, i);
                        tagdata1.setTag(itag, i);
                        ++i;
                    }
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private void setSegmentnaTAB() throws Exception {
        String tabHed = this.izvoristeSimulacije.readLine();
        StringTokenizer sttabHed = new StringTokenizer(tabHed);
        if (sttabHed.nextToken().equals("TAB")) {
            SegmentnaTAB segmentnaTab = null;
            for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                if (!(lk instanceof SegmentnaTAB)) continue;
                segmentnaTab = (SegmentnaTAB)lk;
                segmentnaTab.clear();
                break;
            }
            if (segmentnaTab == null) {
                throw new Exception("Ger\u0161ka prilikom u\u010ditavanja Tabele zahteva!");
            }
            segmentnaTab.clear();
            int brLinijaUTab = Integer.parseInt(sttabHed.nextToken());
            brLinijaUTab = brLinijaUTab > segmentnaTab.getSize() ? segmentnaTab.getSize() : brLinijaUTab;
            int i = 0;
            while (i < brLinijaUTab) {
                String tabElement = this.izvoristeSimulacije.readLine();
                segmentnaTab.setVrednost(tabElement, i);
                ++i;
            }
        }
    }

    private boolean StranicnaAsocijativna() {
        block7: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("1 0")) break block7;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.SetStranicnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA")) {
                Memorija data = null;
                for (Memorija lk : this.komponente.getSveMemorijaKom()) {
                    if (!lk.getIme().equals("DATA")) continue;
                    data = lk;
                    data.clear();
                    break;
                }
                TAG tag = null;
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TAG)) continue;
                    tag = (TAG)lk;
                    tag.clear();
                    break;
                }
                int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                brlinija = brlinija > tag.getVelicina() ? tag.getVelicina() : brlinija;
                int i = 0;
                while (i < brlinija) {
                    String tabElement = this.izvoristeSimulacije.readLine();
                    StringTokenizer sttagElem = new StringTokenizer(tabElement);
                    int v = Integer.parseInt(sttagElem.nextToken());
                    int d = Integer.parseInt(sttagElem.nextToken());
                    int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                    int idata = Usluge.toDec("0x" + sttagElem.nextToken());
                    this.rsffV[i].getOut()[0].setBval(v == 1);
                    this.rsffV[i].getOut()[1].setBval(v != 1);
                    this.rsffD[i].getOut()[0].setBval(d == 1);
                    this.rsffD[i].getOut()[1].setBval(d != 1);
                    tag.setVrednost(itag, i);
                    data.addVal(i, idata);
                    ++i;
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private boolean StranicnaDirektna() {
        block7: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("1 1")) break block7;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.SetStranicnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            TagData tagdata = null;
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA")) {
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagData)) continue;
                    tagdata = (TagData)lk;
                    tagdata.clear();
                    break;
                }
                if (tagdata != null) {
                    int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                    brlinija = brlinija > tagdata.getSize() ? tagdata.getSize() : brlinija;
                    int i = 0;
                    while (i < brlinija) {
                        String tabElement = this.izvoristeSimulacije.readLine();
                        StringTokenizer sttagElem = new StringTokenizer(tabElement);
                        int v = Integer.parseInt(sttagElem.nextToken());
                        int d = Integer.parseInt(sttagElem.nextToken());
                        int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                        int idata = Usluge.toDec("0x" + sttagElem.nextToken());
                        this.rsffV[i].getOut()[0].setBval(v == 1);
                        this.rsffV[i].getOut()[1].setBval(v != 1);
                        this.rsffD[i].getOut()[0].setBval(d == 1);
                        this.rsffD[i].getOut()[1].setBval(d != 1);
                        tagdata.setTagData(i, itag, idata);
                        ++i;
                    }
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private boolean StranicnaSetAsocijativna() {
        block11: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("1 2")) break block11;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.SetStranicnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            TagData tagdata0 = null;
            int cnt = 0;
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA0")) {
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagData) || ++cnt != 2) continue;
                    tagdata0 = (TagData)lk;
                    tagdata0.clear();
                    break;
                }
                if (tagdata0 != null) {
                    int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                    brlinija = brlinija > tagdata0.getSize() ? tagdata0.getSize() : brlinija;
                    int i = 0;
                    while (i < brlinija) {
                        String tabElement = this.izvoristeSimulacije.readLine();
                        StringTokenizer sttagElem = new StringTokenizer(tabElement);
                        int v = Integer.parseInt(sttagElem.nextToken());
                        int d = Integer.parseInt(sttagElem.nextToken());
                        int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                        int idata = Usluge.toDec("0x" + sttagElem.nextToken());
                        this.rsffV[i].getOut()[0].setBval(v == 1);
                        this.rsffV[i].getOut()[1].setBval(v != 1);
                        this.rsffD[i].getOut()[0].setBval(d == 1);
                        this.rsffD[i].getOut()[1].setBval(d != 1);
                        tagdata0.setTagData(i, itag, idata);
                        ++i;
                    }
                }
            }
            TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            TagData tagdata1 = null;
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA1")) {
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagData) || tagdata0 == lk) continue;
                    tagdata1 = (TagData)lk;
                    tagdata1.clear();
                    break;
                }
                if (tagdata1 != null) {
                    int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                    brlinija = brlinija > tagdata1.getSize() ? tagdata1.getSize() : brlinija;
                    int i = 0;
                    while (i < brlinija) {
                        String tabElement = this.izvoristeSimulacije.readLine();
                        StringTokenizer sttagElem = new StringTokenizer(tabElement);
                        int v = Integer.parseInt(sttagElem.nextToken());
                        int d = Integer.parseInt(sttagElem.nextToken());
                        int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                        int idata = Usluge.toDec("0x" + sttagElem.nextToken());
                        this.rsffV[i + 4].getOut()[0].setBval(v == 1);
                        this.rsffV[i + 4].getOut()[1].setBval(v != 1);
                        this.rsffD[i + 4].getOut()[0].setBval(d == 1);
                        this.rsffD[i + 4].getOut()[1].setBval(d != 1);
                        tagdata1.setTagData(i, itag, idata);
                        ++i;
                    }
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private void SetStranicnaTAB() throws Exception {
        String tabHed = this.izvoristeSimulacije.readLine();
        StringTokenizer sttabHed = new StringTokenizer(tabHed);
        if (sttabHed.nextToken().equals("TAB")) {
            StranicnaTAB stranicnaTab = null;
            for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                if (!(lk instanceof StranicnaTAB)) continue;
                stranicnaTab = (StranicnaTAB)lk;
                stranicnaTab.clear();
                break;
            }
            int brLinijaUTab = Integer.parseInt(sttabHed.nextToken());
            brLinijaUTab = brLinijaUTab > stranicnaTab.getSize() ? stranicnaTab.getSize() : brLinijaUTab;
            int i = 0;
            while (i < brLinijaUTab) {
                String tabElement = this.izvoristeSimulacije.readLine();
                stranicnaTab.setVrednost(tabElement, i);
                ++i;
            }
        }
    }

    private boolean SegmentnoStranicnaAsocijativna() {
        block7: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("2 0")) break block7;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.setSegmentnoStranicnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA")) {
                Memorija data1 = null;
                for (Memorija lk : this.komponente.getSveMemorijaKom()) {
                    if (!lk.getIme().equals("DATA")) continue;
                    data1 = lk;
                    data1.clear();
                }
                TAG tag = null;
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TAG)) continue;
                    tag = (TAG)lk;
                    tag.clear();
                    break;
                }
                int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                brlinija = brlinija > tag.getVelicina() ? tag.getVelicina() : brlinija;
                int i = 0;
                while (i < brlinija) {
                    String tabElement = this.izvoristeSimulacije.readLine();
                    StringTokenizer sttagElem = new StringTokenizer(tabElement);
                    int v = Integer.parseInt(sttagElem.nextToken());
                    int d = Integer.parseInt(sttagElem.nextToken());
                    int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                    String data = sttagElem.nextToken();
                    int idata1 = Usluge.toDec("0x" + data);
                    this.rsffV[i].getOut()[0].setBval(v == 1);
                    this.rsffV[i].getOut()[1].setBval(v != 1);
                    this.rsffD[i].getOut()[0].setBval(d == 1);
                    this.rsffD[i].getOut()[1].setBval(d != 1);
                    tag.setVrednost(itag, i);
                    data1.addVal(i, idata1);
                    ++i;
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private boolean SegmentnoStranicnaDirektna() {
        block7: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("2 1")) break block7;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.setSegmentnoStranicnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA")) {
                int brlinija;
                TagData tag = null;
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagData)) continue;
                    tag = (TagData)lk;
                    tag.clear();
                    break;
                }
                int restLine = brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                brlinija = brlinija > tag.getSize() ? tag.getSize() : brlinija;
                restLine -= brlinija;
                int i = 0;
                while (i < brlinija) {
                    String tabElement = this.izvoristeSimulacije.readLine();
                    StringTokenizer sttagElem = new StringTokenizer(tabElement);
                    int v = Integer.parseInt(sttagElem.nextToken());
                    int d = Integer.parseInt(sttagElem.nextToken());
                    int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                    String data = sttagElem.nextToken();
                    int idata1 = Usluge.toDec("0x" + data);
                    this.rsffV[i].getOut()[0].setBval(v == 1);
                    this.rsffV[i].getOut()[1].setBval(v != 1);
                    this.rsffD[i].getOut()[0].setBval(d == 1);
                    this.rsffD[i].getOut()[1].setBval(d != 1);
                    tag.setTagData(i, itag, idata1);
                    ++i;
                }
                i = 0;
                while (i < restLine) {
                    this.izvoristeSimulacije.readLine();
                    ++i;
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private boolean SegmentnoStranicnaSetAsocijativna() {
        block11: {
            this.izvoristeSimulacije.readLine();
            String tip = this.izvoristeSimulacije.readLine().trim();
            if (tip.equals("2 2")) break block11;
            Usluge.showMsgErr("Tip simulacije i tip simulatora se ne sla\u017eu. Poku\u0161ajte drugu simulaciju");
            return false;
        }
        try {
            this.setSegmentnoStranicnaTAB();
            String TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            StringTokenizer stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            TagData tagdata0 = null;
            int cnt = 0;
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA0")) {
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagData) || ++cnt != 2) continue;
                    tagdata0 = (TagData)lk;
                    tagdata0.clear();
                    break;
                }
                if (tagdata0 != null) {
                    int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                    brlinija = brlinija > tagdata0.getSize() ? tagdata0.getSize() : brlinija;
                    int i = 0;
                    while (i < brlinija) {
                        String tabElement = this.izvoristeSimulacije.readLine();
                        StringTokenizer sttagElem = new StringTokenizer(tabElement);
                        int v = Integer.parseInt(sttagElem.nextToken());
                        int d = Integer.parseInt(sttagElem.nextToken());
                        int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                        int idata = Usluge.toDec("0x" + sttagElem.nextToken());
                        this.rsffV[i].getOut()[0].setBval(v == 1);
                        this.rsffV[i].getOut()[1].setBval(v != 1);
                        this.rsffD[i].getOut()[0].setBval(d == 1);
                        this.rsffD[i].getOut()[1].setBval(d != 1);
                        tagdata0.setTagData(i, itag, idata);
                        ++i;
                    }
                }
            }
            TAG_I_DATAHed = this.izvoristeSimulacije.readLine();
            stTAG_I_DATAHed = new StringTokenizer(TAG_I_DATAHed);
            TagData tagdata1 = null;
            if (stTAG_I_DATAHed.nextToken().equals("TAG_I_DATA1")) {
                for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                    if (!(lk instanceof TagData) || tagdata0 == lk) continue;
                    tagdata1 = (TagData)lk;
                    tagdata1.clear();
                    break;
                }
                if (tagdata1 != null) {
                    int brlinija = Integer.parseInt(stTAG_I_DATAHed.nextToken());
                    brlinija = brlinija > tagdata1.getSize() ? tagdata1.getSize() : brlinija;
                    int i = 0;
                    while (i < brlinija) {
                        String tabElement = this.izvoristeSimulacije.readLine();
                        StringTokenizer sttagElem = new StringTokenizer(tabElement);
                        int v = Integer.parseInt(sttagElem.nextToken());
                        int d = Integer.parseInt(sttagElem.nextToken());
                        int itag = Usluge.toDec("0x" + sttagElem.nextToken());
                        int idata = Usluge.toDec("0x" + sttagElem.nextToken());
                        this.rsffV[i + 4].getOut()[0].setBval(v == 1);
                        this.rsffV[i + 4].getOut()[1].setBval(v != 1);
                        this.rsffD[i + 4].getOut()[0].setBval(d == 1);
                        this.rsffD[i + 4].getOut()[1].setBval(d != 1);
                        tagdata1.setTagData(i, itag, idata);
                        ++i;
                    }
                }
            }
            this.SetRAM();
            this.SetReg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Usluge.showMsgErr("Greska prilikom u\u010ditavanja simulacije");
            return false;
        }
        return true;
    }

    private void setSegmentnoStranicnaTAB() throws Exception {
        String tabHed = this.izvoristeSimulacije.readLine();
        StringTokenizer sttabHed = new StringTokenizer(tabHed);
        if (sttabHed.nextToken().equals("TAB")) {
            int brLinijaUTab;
            SegmentnaTAB segmentnaTab = null;
            for (LogickaKomponenta lk : this.komponente.getSveKombinacionaKola()) {
                if (!(lk instanceof SegmentnaTAB)) continue;
                segmentnaTab = (SegmentnaTAB)lk;
                segmentnaTab.clear();
                break;
            }
            if (segmentnaTab == null) {
                Usluge.showMsgErr("Pri ucitavanju nije na]eno kolo TAB (SegmentnoStranicna)");
                return;
            }
            int restLine = brLinijaUTab = Integer.parseInt(sttabHed.nextToken());
            brLinijaUTab = brLinijaUTab > segmentnaTab.getSize() ? segmentnaTab.getSize() : brLinijaUTab;
            restLine -= brLinijaUTab;
            int i = 0;
            while (i < brLinijaUTab) {
                String tabElement = this.izvoristeSimulacije.readLine();
                segmentnaTab.setVrednost(tabElement, i);
                ++i;
            }
            i = 0;
            while (i < restLine) {
                this.izvoristeSimulacije.readLine();
                ++i;
            }
        }
    }

    private void SetRAM() throws Exception {
        String ram = this.izvoristeSimulacije.readLine();
        StringTokenizer ramHed = new StringTokenizer(ram);
        if (ramHed.nextToken().equals("RAM")) {
            int brLinijaUram;
            Memorija mem = null;
            for (Memorija lk : this.komponente.getSveMemorijaKom()) {
                if (!lk.getIme().equals("MEM")) continue;
                mem = lk;
                mem.clear();
                break;
            }
            int restLine = brLinijaUram = Integer.parseInt(ramHed.nextToken());
            brLinijaUram = brLinijaUram > mem.getVel() ? mem.getVel() : brLinijaUram;
            restLine -= brLinijaUram;
            int i = 0;
            while (i < brLinijaUram) {
                String ramElement = this.izvoristeSimulacije.readLine();
                StringTokenizer ramElementst = new StringTokenizer(ramElement);
                int adr = Usluge.toDec("0x" + ramElementst.nextToken());
                int vre = Usluge.toDec("0x" + ramElementst.nextToken());
                mem.addVal(adr, vre);
                ++i;
            }
            i = 0;
            while (i < restLine) {
                this.izvoristeSimulacije.readLine();
                ++i;
            }
        }
    }

    private void SetReg() throws Exception {
        String reg = this.izvoristeSimulacije.readLine();
        StringTokenizer regHed = new StringTokenizer(reg);
        if (regHed.nextToken().equals("REGISTRI")) {
            int brLinijaUreg;
            int restLine = brLinijaUreg = Integer.parseInt(regHed.nextToken());
            brLinijaUreg = brLinijaUreg > this.komponente.getSviRegistri().size() ? this.komponente.getSviRegistri().size() : brLinijaUreg;
            restLine -= brLinijaUreg;
            int i = 0;
            while (i < brLinijaUreg) {
                String regline = this.izvoristeSimulacije.readLine();
                StringTokenizer stregline = new StringTokenizer(regline);
                String ime_reg = (String)stregline.nextElement();
                String reg_val = (String)stregline.nextElement();
                for (Registar selReg : this.komponente.getSviRegistri()) {
                    if (!selReg.getIme().equals(ime_reg)) continue;
                    int val = Usluge.toDec("0x" + reg_val);
                    selReg.setVal(val);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < restLine) {
                this.izvoristeSimulacije.readLine();
                ++i;
            }
        }
    }
}

