/*
 * Decompiled with CFR 0.152.
 */
package parser;

import guiKomponente.GUIPin;
import guiKomponente.Konekcija;
import guiKomponente.Line;
import guiKomponente.Point;
import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import komponente.ADD;
import komponente.ALU;
import komponente.CD;
import komponente.CMP;
import komponente.DC;
import komponente.DFF;
import komponente.LogickaKomponenta;
import komponente.LogickoI;
import komponente.LogickoILI;
import komponente.LogickoNI;
import komponente.LogickoNILI;
import komponente.MP;
import komponente.NXILI;
import komponente.RSFF;
import komponente.Registar;
import komponente.TFF;
import komponente.XILI;
import myIO.myFile;

public class ParsingLine {
    private static Vector<String> tipoviElemenata = new Vector();
    private myFile file = null;
    private String imeFajla = null;
    private Vector<LogickaKomponenta> logKomponente = new Vector();
    private Vector<GUIPin> pinovi = new Vector();

    static {
        tipoviElemenata.add("ADD");
        tipoviElemenata.add("ALU");
        tipoviElemenata.add("CD");
        tipoviElemenata.add("CMP");
        tipoviElemenata.add("DC");
        tipoviElemenata.add("DFF");
        tipoviElemenata.add("I");
        tipoviElemenata.add("ILI");
        tipoviElemenata.add("NI");
        tipoviElemenata.add("NILI");
        tipoviElemenata.add("MP");
        tipoviElemenata.add("RSFF");
        tipoviElemenata.add("XILI");
        tipoviElemenata.add("Registar");
        tipoviElemenata.add("TriStateBuf");
        tipoviElemenata.add("NXILI");
        tipoviElemenata.add("TFF");
    }

    private void napraviLogickoKolo(String tip, int brojKomponenata, int brojUlaza) {
        switch (tipoviElemenata.indexOf(tip)) {
            case 0: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new ADD(brojUlaza));
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new ALU());
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new CD(brojUlaza));
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new CMP(brojUlaza));
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new DC(brojUlaza));
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new DFF());
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new LogickoI(brojUlaza, 1));
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new LogickoILI(brojUlaza, 1));
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new LogickoNI(brojUlaza, 1));
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new LogickoNILI(brojUlaza, 1));
                    ++i;
                }
                break;
            }
            case 10: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new MP(brojUlaza));
                    ++i;
                }
                break;
            }
            case 11: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new RSFF());
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new XILI(brojUlaza, 1));
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new Registar(brojUlaza, ""));
                    ++i;
                }
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new NXILI(brojUlaza, 1));
                    ++i;
                }
                break;
            }
            case 16: {
                int i = 0;
                while (i < brojKomponenata) {
                    this.logKomponente.add(new TFF());
                    ++i;
                }
                break;
            }
        }
    }

    private void napraviGUIPin(StringTokenizer stline) throws Exception {
        ArrayList<Line> tempLine = new ArrayList<Line>();
        int hm = Integer.parseInt(stline.nextToken());
        while (hm > 0) {
            Line tpLine = new Line(Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()));
            tempLine.add(tpLine);
            --hm;
        }
        hm = Integer.parseInt(stline.nextToken());
        ArrayList<Point> tempTextPoint = new ArrayList<Point>();
        while (hm > 0) {
            Point textPoint = new Point(Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()));
            tempTextPoint.add(textPoint);
            --hm;
        }
        int red = Integer.parseInt(stline.nextToken());
        int green = Integer.parseInt(stline.nextToken());
        int blue = Integer.parseInt(stline.nextToken());
        Color color = new Color(red, green, blue);
        int brashWidth = Integer.parseInt(stline.nextToken());
        int pintip = Integer.parseInt(stline.nextToken());
        int numLin = Integer.parseInt(stline.nextToken());
        GUIPin tmpGPin = new GUIPin(color, pintip, numLin, brashWidth);
        tmpGPin.setGraphicLine(tempLine);
        tmpGPin.setTextPoint(tempTextPoint);
        int brojUlaz = Integer.parseInt(stline.nextToken());
        int i = 0;
        while (i < brojUlaz) {
            String ntoken = stline.nextToken();
            int redniBroj = Integer.parseInt(ntoken.substring(0, 2));
            int brojUlaza = Integer.parseInt(ntoken.substring(2, ntoken.length()));
            Konekcija tmpKon = new Konekcija(redniBroj, brojUlaza);
            tmpGPin.addUlazKon(tmpKon);
            ++i;
        }
        int brojIzlaziIz = Integer.parseInt(stline.nextToken());
        int i2 = 0;
        while (i2 < brojIzlaziIz) {
            String ntoken = stline.nextToken();
            int redniBroj = Integer.parseInt(ntoken.substring(0, 2));
            int brojIzlaza = Integer.parseInt(ntoken.substring(2, ntoken.length()));
            Konekcija tmpKon = new Konekcija(redniBroj, brojIzlaza);
            tmpGPin.addIzlazKon(tmpKon);
            ++i2;
        }
        String imePina = stline.nextToken();
        tmpGPin.setIme(imePina);
        this.pinovi.add(tmpGPin);
    }

    public void povezi() {
        for (GUIPin sgp : this.pinovi) {
            LogickaKomponenta logickaKomponenta;
            for (Konekcija sk : sgp.getLogKolaInput()) {
                try {
                    logickaKomponenta = this.logKomponente.elementAt(sk.getKolo());
                    logickaKomponenta.setInputPins(sk.getUlaz(), sgp.getPin());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.print("\n" + sgp.toString());
                }
            }
            for (Konekcija sk : sgp.getLogKolaOutput()) {
                try {
                    logickaKomponenta = this.logKomponente.elementAt(sk.getKolo());
                    logickaKomponenta.setOutputPins(sk.getUlaz(), sgp.getPin());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ParsingLine(String imeFajla) {
        this.imeFajla = imeFajla;
    }

    public void parsiraj() throws Exception {
        this.file = new myFile(this.imeFajla);
        this.file.open('r');
        int brojZapisa = Integer.parseInt(this.file.readLine());
        int i = 0;
        while (i < brojZapisa) {
            String[] linija = this.file.readLine().split(" ");
            this.napraviLogickoKolo(linija[0], Integer.parseInt(linija[1]), Integer.parseInt(linija[2]));
            ++i;
        }
        int br = 0;
        while (!this.file.EOF()) {
            StringTokenizer stline = new StringTokenizer(this.file.readLine());
            try {
                ++br;
                this.napraviGUIPin(stline);
            }
            catch (Exception e) {
                System.out.println("Greska u liniji broj: " + br);
                e.printStackTrace();
            }
        }
    }

    public Vector<LogickaKomponenta> getLogKomponente() {
        return this.logKomponente;
    }

    public void setLogKomponente(Vector<LogickaKomponenta> logKomponente) {
        this.logKomponente = logKomponente;
    }

    public Vector<GUIPin> getPinovi() {
        return this.pinovi;
    }

    public void setPinovi(Vector<GUIPin> pinovi) {
        this.pinovi = pinovi;
    }
}

