/*
 * Decompiled with CFR 0.152.
 */
package guiKomponente;

import guiKomponente.Konekcija;
import guiKomponente.Line;
import guiKomponente.Point;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;
import komponente.Pin;

public class GUIPin {
    private Pin pin;
    private Color boja;
    private int brLine;
    private ArrayList<Line> graphicLine;
    private int brashWidth;
    private ArrayList<Point> textPoint;
    private String ulaziU;
    private String izlaziIz;
    private Vector<Konekcija> logKolaInput;
    private Vector<Konekcija> logKolaOutput;
    private String ime;
    private boolean povezanUSistem;

    public GUIPin(Color boja, int tipPina, int brLine, int brashWidth) throws Exception {
        this.boja = boja;
        this.brLine = brLine;
        this.brashWidth = brashWidth;
        this.pin = tipPina == 1 ? new Pin(false) : new Pin(0, brLine);
        this.graphicLine = new ArrayList();
        this.textPoint = null;
        this.logKolaInput = new Vector();
        this.logKolaOutput = new Vector();
        this.povezanUSistem = false;
    }

    public GUIPin(int tipPina, int brLine) throws Exception {
        this.brLine = brLine;
        this.pin = tipPina == 1 ? new Pin(false) : new Pin(0, brLine);
        this.logKolaInput = new Vector();
        this.logKolaOutput = new Vector();
    }

    public void setNextLine(Line line) {
        this.graphicLine.add(line);
    }

    public String toString() {
        return String.valueOf(this.ime) + "[" + this.povezanUSistem + "]";
    }

    public Color getTrenColor() throws Exception {
        Color ret = null;
        if (this.pin == null) {
            return ret;
        }
        ret = this.pin.isSingl() ? (this.pin != null && this.pin.isBval() ? this.getActivColor() : this.getPasivColor()) : this.getMultilineColor();
        return ret;
    }

    public Color getActivColor() {
        return new Color(255, 0, 0);
    }

    public Color getPasivColor() {
        return new Color(0, 0, 255);
    }

    public Color getMultilineColor() {
        return new Color(100, 150, 180);
    }

    public Color getHZColor() {
        return new Color(92, 163, 95);
    }

    public Pin getPin() {
        return this.pin;
    }

    public void setPin(Pin pin) {
        this.pin = pin;
    }

    public Color getBoja() {
        return this.boja;
    }

    public ArrayList<Line> getGraphicLine() {
        return this.graphicLine;
    }

    public void setGraphicLine(ArrayList<Line> graphicLine) {
        this.graphicLine = graphicLine;
    }

    public int getBrashWidth() {
        return this.brashWidth;
    }

    public void setTextPoint(ArrayList<Point> textPoint) {
        this.textPoint = textPoint;
    }

    public ArrayList<Point> getTextPoint() {
        return this.textPoint;
    }

    public int getBrLine() {
        return this.brLine;
    }

    public String getUlaziU() {
        return this.ulaziU;
    }

    public void setUlaziU(String ulaziU) {
        this.ulaziU = ulaziU;
    }

    public String getIzlaziIz() {
        return this.izlaziIz;
    }

    public void setIzlaziIz(String izlaziIz) {
        this.izlaziIz = izlaziIz;
    }

    public int getPinVal() throws Exception {
        if (this.pin.isSingl()) {
            return 1;
        }
        return this.pin.getIval();
    }

    public void addUlazKon(Konekcija kon) {
        this.logKolaInput.add(kon);
    }

    public void addIzlazKon(Konekcija kon) {
        this.logKolaOutput.add(kon);
    }

    public Vector<Konekcija> getLogKolaInput() {
        return this.logKolaInput;
    }

    public Vector<Konekcija> getLogKolaOutput() {
        return this.logKolaOutput;
    }

    public boolean isPovezanUSistem() {
        return this.povezanUSistem;
    }

    public void setPovezanUSistem(boolean posvezanUSistem) {
        this.povezanUSistem = posvezanUSistem;
    }

    public String getIme() {
        return this.ime;
    }

    public void setIme(String ime) {
        this.ime = ime;
    }
}

