/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JComponent;

public class Moje_ImageViewer
extends JComponent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_NORMAL = 3;
    protected transient Image image = null;
    protected String fileName = null;
    protected URL url = null;
    protected int imageStyle = 1;
    protected transient ResourceBundle errors;

    public Moje_ImageViewer() {
    }

    public Moje_ImageViewer(String str) throws MalformedURLException {
        this();
        try {
            this.setFileName(str);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public Moje_ImageViewer(URL url) {
        this();
        try {
            this.setImageURL(url);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public Moje_ImageViewer(Image img) {
        this();
        try {
            this.setImage(img);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setFileName(String str) throws PropertyVetoException {
        String oldValue = this.fileName;
        try {
            this.fileName = str;
            if (this.fileName != null && this.fileName != "") {
                this.setImageURL(new URL(this.fileName));
            } else {
                this.setImageURL(null);
            }
        }
        catch (MalformedURLException _ex) {
            this.fileName = oldValue;
        }
        this.repaint();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setImageURL(URL aUrl) throws PropertyVetoException {
        this.url = aUrl;
        this.fileName = null;
        Image loadedImage = null;
        if (this.url != null) {
            loadedImage = this.getToolkit().getImage(this.url);
        }
        this.setImage(loadedImage);
        this.repaint();
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setURL(URL aUrl) throws PropertyVetoException {
        this.setImageURL(aUrl);
    }

    public URL getURL() {
        return this.getImageURL();
    }

    public void setCenterMode(boolean flag) throws PropertyVetoException {
        if (flag && this.getStyle() != 1) {
            this.setStyle(1);
        }
    }

    public boolean getCenterMode() {
        return this.getStyle() == 1;
    }

    public void setStyle(int newStyle) throws PropertyVetoException {
        if (newStyle != this.imageStyle) {
            this.imageStyle = newStyle;
            this.repaint();
        }
    }

    public int getStyle() {
        return this.imageStyle;
    }

    public void setImage(Image img) throws PropertyVetoException {
        this.fileName = null;
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        this.image = img;
        if (img != null) {
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.image, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException _ex) {
                _ex.printStackTrace();
            }
        } else {
            this.repaint();
        }
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    public void paint(Graphics g) {
        block10: {
            Dimension dim;
            block9: {
                super.paint(g);
                dim = this.getSize();
                if (this.image == null) break block9;
                int imageWidth = this.image.getWidth(this);
                int imageHeight = this.image.getHeight(this);
                switch (this.imageStyle) {
                    default: {
                        g.drawImage(this.image, (dim.width - imageWidth) / 2, (dim.height - imageHeight) / 2, imageWidth, imageHeight, this);
                        break;
                    }
                    case 0: {
                        int numHImages = dim.width / imageWidth;
                        if (dim.width % imageWidth != 0) {
                            ++numHImages;
                        }
                        int numVImages = dim.height / imageHeight;
                        if (dim.height % imageHeight != 0) {
                            ++numVImages;
                        }
                        int v = 0;
                        int vCount = 0;
                        while (vCount < numVImages) {
                            int h = 0;
                            int hCount = 0;
                            while (hCount < numHImages) {
                                g.drawImage(this.image, h, v, imageWidth, imageHeight, this);
                                h += imageWidth;
                                ++hCount;
                            }
                            v += imageHeight;
                            ++vCount;
                        }
                        break block10;
                    }
                    case 2: {
                        g.drawImage(this.image, 0, 0, dim.width, dim.height, this);
                        break;
                    }
                    case 3: {
                        g.drawImage(this.image, 0, 0, this);
                        break;
                    }
                }
                break block10;
            }
            g.clearRect(0, 0, dim.width, dim.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return new Dimension(10, 10);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vetoablechangelistener) {
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vetoablechangelistener) {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.url != null) {
            this.image = this.getToolkit().getImage(this.url);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.image, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException _ex) {
                throw new IOException();
            }
        }
    }
}

