/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.SignalCache;
import control.StepDescription;
import element.Navigator;
import element.Utility;
import exception.SignalWidthException;

public class SignalCacheAsoc
extends SignalCache {
    private static final long serialVersionUID = 1L;
    private boolean BUSY = false;
    private boolean[][] DATA = new boolean[(int)Math.pow(2.0, 5.0)][8];
    private boolean[] DATAOUT = new boolean[8];
    private boolean[] DATAWR = new boolean[8];
    private boolean[] DATARD = new boolean[8];
    private boolean[] ADATA = new boolean[5];
    private boolean mxDATA = false;
    private boolean[] LRU = new boolean[3];
    private boolean adjLRUCNT = false;
    private boolean ldLRUCNT = false;
    private boolean clFRQ = false;
    private boolean FRQ = true;
    private boolean[] EQL = new boolean[8];
    private boolean[] LSS = new boolean[8];
    private boolean[] GTR = new boolean[8];
    private boolean[] incLRUCNT = new boolean[8];
    private boolean[] clLRUCNT = new boolean[8];
    private boolean[] LRUCNTones = new boolean[8];
    private boolean[][] LRUCNT = new boolean[8][3];
    private boolean[] CNT = new boolean[3];
    private boolean[] mxLRUCNT = new boolean[3];
    private boolean incABB = false;
    private boolean ldABB = false;
    private boolean CNTBB0 = false;
    private boolean CNTBB1 = false;
    private boolean[] ABB = new boolean[2];
    private boolean[][] TAG = new boolean[8][14];
    private boolean[] M = new boolean[8];
    private boolean[] S = new boolean[8];
    private boolean[] AMADR = new boolean[3];
    private boolean writeTAG = false;
    private boolean val3 = false;
    private boolean val5 = false;

    public SignalCacheAsoc() throws SignalWidthException {
        this.CACHECNT = new boolean[3];
        this.CACHET = new boolean[(int)Math.pow(2.0, 3.0)];
        this.initCacheDescription();
        this.initCPUDescription();
    }

    @Override
    public void clock() {
        super.clock();
        if (this.incCPUCNT) {
            this.CPUCNT = Utility.BoolInc(this.CPUCNT);
        }
        if (this.ldCPUCNT) {
            this.CPUCNT = Utility.DecToBool(0, this.CPUCNT.length);
        }
        if (this.run && this.ldCACHECNT) {
            this.CACHECNT[0] = this.val3 || this.val5;
            this.CACHECNT[1] = this.val3;
            this.CACHECNT[2] = this.val5;
        }
        if (this.run && !this.ldCACHECNT) {
            this.CACHECNT = Utility.BoolInc(this.CACHECNT);
        }
        if (this.ldWCNT) {
            System.arraycopy(this.getTAB().readWAIT(this.currentEntry), 0, this.WCNT, 0, this.WCNT.length);
        }
        if (this.decWCNT) {
            this.WCNT = Utility.BoolDec(this.WCNT);
        }
        if (this.incECNT) {
            this.ECNT = Utility.BoolInc(this.ECNT);
            this.currentEntry = Utility.BoolToDec(this.ECNT);
        }
        if (this.wrTAB) {
            try {
                this.getTAB().writeDATA(this.currentEntry, this.PDRRD);
            }
            catch (SignalWidthException e) {
                e.printStackTrace();
            }
        }
        boolean bl = this.END = this.stEND && this.currentEntry == 31;
        if (this.ldPAR) {
            System.arraycopy(this.getTAB().readADR(this.currentEntry), 0, this.PAR, 0, this.PAR.length);
        }
        if (this.ldPDRWR) {
            System.arraycopy(this.getTAB().readDATA(this.currentEntry), 0, this.PDRWR, 0, this.PDRWR.length);
        }
        if (this.ldMODE) {
            System.arraycopy(this.getTAB().readMODE(this.currentEntry), 0, this.MODE, 0, this.MODE.length);
        }
        if (this.ldPDRRD) {
            System.arraycopy(this.CDRRD, 0, this.PDRRD, 0, this.PDRRD.length);
        }
        if (this.PRQWR) {
            System.arraycopy(this.PDRWR, 0, this.CDRWR, 0, this.CDRWR.length);
        }
        if (this.ldCDRRD) {
            System.arraycopy(this.DATAOUT, 0, this.CDRRD, 0, this.CDRRD.length);
        }
        if (this.PRQRD || this.PRQWR) {
            System.arraycopy(this.PAR, 0, this.CAR, 0, this.CAR.length);
        }
        if (this.PRQRD) {
            this.CRD = true;
        }
        if (this.clCRD) {
            this.CRD = false;
        }
        if (this.PRQWR) {
            this.CWR = true;
        }
        if (this.clCWR) {
            this.CWR = false;
        }
        int i = 0;
        while (i < 8) {
            if (this.stV[i]) {
                this.vectorV[i] = true;
            }
            ++i;
        }
        if (this.incMEMACC) {
            this.MEMACC = Utility.BoolInc(this.MEMACC);
        }
        if (this.incCNTBB) {
            this.CNTBB = Utility.BoolInc(this.CNTBB);
        }
        if (this.incABB) {
            this.ABB = Utility.BoolInc(this.ABB);
        }
        if (this.ldABB) {
            boolean[] CAR1_0 = new boolean[this.ABB.length];
            System.arraycopy(this.CAR, 0, CAR1_0, 0, CAR1_0.length);
            System.arraycopy(CAR1_0, 0, this.ABB, 0, this.ABB.length);
        }
        boolean[] CAR15_2 = new boolean[14];
        System.arraycopy(this.CAR, 2, CAR15_2, 0, CAR15_2.length);
        if (this.writeTAG) {
            System.arraycopy(CAR15_2, 0, this.TAG[Utility.BoolToDec(this.LRU)], 0, 14);
        }
        if (this.writeDATA) {
            System.arraycopy(this.DATAWR, 0, this.DATA[Utility.BoolToDec(this.ADATA)], 0, 8);
        }
        if (this.MEMACC[1] && this.MEMACC[0]) {
            if (this.writeMEM) {
                System.arraycopy(this.MDRWR, 0, this.MEM[Utility.BoolToDec(this.MAR)], 0, 8);
            } else {
                System.arraycopy(this.MEM[Utility.BoolToDec(this.MAR)], 0, this.MEMDRD, 0, this.MEMDRD.length);
            }
        }
        if (this.ldMDRWR) {
            System.arraycopy(this.CDRWR, 0, this.MDRWR, 0, this.MDRWR.length);
        }
        if (this.ldMDRRD) {
            System.arraycopy(this.MEMDRD, 0, this.MDRRD, 0, this.MDRRD.length);
        }
        if (this.ldMAR) {
            System.arraycopy(CAR15_2, 0, this.MAR, 2, 14);
            System.arraycopy(this.ABB, 0, this.MAR, 0, this.ABB.length);
        }
        if (this.clFRQ) {
            this.FRQ = false;
        }
        int i2 = 0;
        while (i2 < 8) {
            if (this.incLRUCNT[i2]) {
                this.LRUCNT[i2] = Utility.BoolInc(this.LRUCNT[i2]);
            }
            if (this.clLRUCNT[i2]) {
                this.LRUCNT[i2] = Utility.DecToBool(0, this.LRUCNT[i2].length);
            }
            if (this.ldLRUCNT) {
                this.LRUCNT[i2] = Utility.DecToBool(7 - i2, this.LRUCNT[i2].length);
            }
            ++i2;
        }
        int cpuStep = 0;
        cpuStep = Utility.BoolToDec(this.CPUCNT);
        int i3 = 0;
        while (i3 < this.CPUT.length) {
            this.CPUT[i3] = i3 == cpuStep;
            ++i3;
        }
        int cacheStep = 0;
        cacheStep = Utility.BoolToDec(this.CACHECNT);
        int i4 = 0;
        while (i4 < this.CACHET.length) {
            this.CACHET[i4] = i4 == cacheStep;
            ++i4;
        }
        this.TV = this.getTAB().readV(this.currentEntry);
        this.OUT = Utility.BoolToDec(this.WCNT) == 0;
        this.CNTBB1 = this.CNTBB[0] && !this.CNTBB[1];
        this.CRP = this.CACHET[1] && this.CWR || this.CACHET[2] || this.CACHET[5] && this.CNTBB1;
        this.BUSY = this.CWR || this.CRD;
        this.ldCPUCNT = this.CPUT[6];
        this.incCPUCNT = this.CPUT[0] && this.TV && !this.END || this.CPUT[1] && this.OUT || this.CPUT[2] || this.CPUT[3] && !this.BUSY || this.CPUT[4] && this.CRP || this.CPUT[5];
        this.ldPDRWR = this.CPUT[2] && this.getTAB().readMODE(this.currentEntry)[0];
        this.ldMODE = this.CPUT[1] && this.OUT;
        this.ldPAR = this.CPUT[2];
        this.PRQ = this.CPUT[3] && !this.BUSY;
        this.ldWCNT = this.CPUT[0] && this.TV && !this.END;
        this.decWCNT = this.CPUT[1] && !this.OUT;
        this.incECNT = this.CPUT[6];
        this.wrTAB = this.CPUT[5] && !this.getTAB().readMODE(this.currentEntry)[0];
        this.stEND = this.CPUT[6];
        int hitEntry = 0;
        int i5 = 0;
        while (i5 < 8) {
            this.M[i5] = Utility.BoolToDec(CAR15_2) == Utility.BoolToDec(this.TAG[i5]);
            boolean bl2 = this.S[i5] = this.M[i5] && this.vectorV[i5];
            if (this.S[i5]) {
                hitEntry = i5;
            }
            ++i5;
        }
        this.HM = Utility.BoolToDec(this.S) != 0;
        this.rd = !this.MODE[1] && !this.MODE[0];
        this.wr = !this.MODE[1] && this.MODE[0];
        this.PRQRD = this.rd && this.PRQ;
        this.PRQWR = this.wr && this.PRQ;
        this.MEMFC = this.MEMACC[0] && this.MEMACC[1];
        this.CNTBB0 = !this.CNTBB[0] && !this.CNTBB[1];
        this.CNTBB3 = this.CNTBB[0] && this.CNTBB[1];
        this.val3 = this.CACHET[1] && this.CWR;
        this.val5 = this.CACHET[1] && !this.CWR && !this.HM || this.CACHET[7] && !this.CNTBB3;
        this.ldCACHECNT = this.CACHET[1] && (this.CWR || !this.HM) || this.CACHET[2] || this.CACHET[4] && this.MEMFC || this.CACHET[7];
        this.run = this.CACHET[0] && (this.PRQRD || this.PRQWR) || this.CACHET[1] || this.CACHET[2] || this.CACHET[3] || this.CACHET[4] && this.MEMFC || this.CACHET[5] || this.CACHET[6] && this.MEMFC || this.CACHET[7];
        this.ldCDRRD = this.CACHET[1] && this.CRD && this.HM || this.CACHET[7] && this.CNTBB0;
        this.clCRD = this.CACHET[2] || this.CACHET[7] && this.CNTBB3;
        this.clCWR = this.CACHET[4] && this.MEMFC;
        this.writeV = this.CACHET[7] && this.CNTBB3;
        this.incABB = this.CACHET[7];
        this.incCNTBB = this.CACHET[7];
        this.incMEMACC = this.CACHET[4] || this.CACHET[6];
        this.ldABB = this.CACHET[1] && (this.CWR || this.CRD && !this.HM);
        this.adjLRUCNT = this.CACHET[1] && (this.CRD || this.CWR) && this.HM || this.CACHET[7] && this.CNTBB3;
        this.ldLRUCNT = this.CACHET[0] && this.FRQ && (this.PRQRD || this.PRQWR);
        this.clFRQ = this.CACHET[0] && this.FRQ && (this.PRQRD || this.PRQWR);
        this.writeTAG = this.CACHET[7] && this.CNTBB3;
        this.mxDIDATA = this.CACHET[7];
        this.mxADATA = this.CACHET[7];
        this.writeDATA = this.CACHET[3] && this.HM || this.CACHET[7];
        this.mxDATA = this.CACHET[7] && this.CNTBB0;
        this.ldMAR = this.CACHET[3] || this.CACHET[5];
        this.ldMDRWR = this.CACHET[3];
        this.ldMDRRD = this.CACHET[6] && this.MEMFC;
        this.writeMEM = this.CACHET[4];
        boolean bl3 = this.ldPDRRD = this.rd && this.CRP;
        if (this.writeV) {
            i5 = 0;
            while (i5 < this.stV.length) {
                this.stV[i5] = i5 == Utility.BoolToDec(this.LRU);
                ++i5;
            }
        }
        this.AMADR = Utility.DecToBool(hitEntry, this.AMADR.length);
        if (this.mxDIDATA) {
            System.arraycopy(this.MDRRD, 0, this.DATAWR, 0, this.DATAWR.length);
        } else {
            System.arraycopy(this.CDRWR, 0, this.DATAWR, 0, this.DATAWR.length);
        }
        int ones = 0;
        int i6 = 0;
        while (i6 < 8) {
            boolean bl4 = this.LRUCNTones[i6] = Utility.BoolToDec(this.LRUCNT[i6]) == 7;
            if (this.LRUCNTones[i6]) {
                ones = i6;
            }
            ++i6;
        }
        this.LRU = Utility.DecToBool(ones, this.LRU.length);
        if (this.mxADATA) {
            i6 = 0;
            while (i6 < 2) {
                this.ADATA[i6] = this.ABB[i6];
                ++i6;
            }
        } else {
            i6 = 0;
            while (i6 < 2) {
                this.ADATA[i6] = this.CAR[i6];
                ++i6;
            }
        }
        i6 = 2;
        while (i6 < this.ADATA.length) {
            this.ADATA[i6] = this.mxADATA ? this.LRU[i6 - 2] : this.AMADR[i6 - 2];
            ++i6;
        }
        System.arraycopy(this.DATA[Utility.BoolToDec(this.ADATA)], 0, this.DATARD, 0, this.DATARD.length);
        if (this.mxDATA) {
            System.arraycopy(this.MDRRD, 0, this.DATAOUT, 0, this.DATAOUT.length);
        } else {
            System.arraycopy(this.DATARD, 0, this.DATAOUT, 0, this.DATAOUT.length);
        }
        if (this.HM) {
            System.arraycopy(this.AMADR, 0, this.mxLRUCNT, 0, this.mxLRUCNT.length);
        } else {
            System.arraycopy(this.LRU, 0, this.mxLRUCNT, 0, this.mxLRUCNT.length);
        }
        System.arraycopy(this.LRUCNT[Utility.BoolToDec(this.mxLRUCNT)], 0, this.CNT, 0, this.CNT.length);
        i6 = 0;
        while (i6 < 8) {
            this.LSS[i6] = Utility.BoolToDec(this.LRUCNT[i6]) < Utility.BoolToDec(this.CNT);
            this.EQL[i6] = Utility.compareSignals(this.LRUCNT[i6], 0, this.LRUCNT[i6].length - 1, this.CNT, 0, this.CNT.length - 1);
            this.GTR[i6] = !this.LSS[i6] && !this.EQL[i6];
            this.incLRUCNT[i6] = this.adjLRUCNT && this.LSS[i6];
            this.clLRUCNT[i6] = this.adjLRUCNT && this.EQL[i6];
            ++i6;
        }
        Navigator.instance().getCurrentWindow().refresh();
    }

    public boolean isBUSY() {
        return this.BUSY;
    }

    public boolean[][] getDATA() {
        return this.DATA;
    }

    public boolean[][] getTAG() {
        return this.TAG;
    }

    public boolean[] getDATAOUT() {
        return this.DATAOUT;
    }

    public boolean[] getLRU() {
        return this.LRU;
    }

    public boolean isIncABB() {
        return this.incABB;
    }

    public boolean isLdABB() {
        return this.ldABB;
    }

    public boolean isCNTBB0() {
        return this.CNTBB0;
    }

    public boolean isCNTBB1() {
        return this.CNTBB1;
    }

    public boolean[] getS() {
        return this.S;
    }

    public boolean[] getAMADR() {
        return this.AMADR;
    }

    public boolean isWriteTAG() {
        return this.writeTAG;
    }

    public boolean[] getM() {
        return this.M;
    }

    public boolean[] getDATAWR() {
        return this.DATAWR;
    }

    public boolean[] getDATARD() {
        return this.DATARD;
    }

    public boolean[] getADATA() {
        return this.ADATA;
    }

    public boolean isMxDATA() {
        return this.mxDATA;
    }

    public boolean[] getABB() {
        return this.ABB;
    }

    public boolean isVal3() {
        return this.val3;
    }

    public boolean isVal5() {
        return this.val5;
    }

    public boolean isAdjLRUCNT() {
        return this.adjLRUCNT;
    }

    public boolean isLdLRUCNT() {
        return this.ldLRUCNT;
    }

    public boolean isClFRQ() {
        return this.clFRQ;
    }

    public boolean isFRQ() {
        return this.FRQ;
    }

    public boolean[] getEQL() {
        return this.EQL;
    }

    public boolean[] getLSS() {
        return this.LSS;
    }

    public boolean[] getGTR() {
        return this.GTR;
    }

    public boolean[] getIncLRUCNT() {
        return this.incLRUCNT;
    }

    public boolean[] getClLRUCNT() {
        return this.clLRUCNT;
    }

    public boolean[] getLRUCNTones() {
        return this.LRUCNTones;
    }

    public boolean[] getCNT() {
        return this.CNT;
    }

    public boolean[] getMxLRUCNT() {
        return this.mxLRUCNT;
    }

    public boolean[][] getLRUCNT() {
        return this.LRUCNT;
    }

    private void initCacheDescription() {
        if (this.cacheDesc == null) {
            this.cacheDesc = new StepDescription();
            this.cacheDesc.addStep("<html><body>step<sub>0</sub>: <i>if</i> (<b>FRQ</b> &middot (<b>PRQRD</b> + <b>PRQWR</b>)) <b>then</b> (<b>clFRQ</b>, <b>ldLRUCNT</b>),<br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br</i>( <i>if </i> ( <b>PRQRD</b> + <b>PRQWR</b>) <i>then</i> step<sub>1</sub> <i>else</i> step<sub>0</sub>)<br /></body></html>");
            this.cacheDesc.addStep("<html><body>step<sub>1</sub>: <i>if</i> ( <b>CRD</b> &middot <b>H/M</b>) <i>then </i> <b>ldCDRRD</b>, <br /> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i> ( <b>CRD</b> &middot <b><font style=\"text-decoration:overline;\">HM</font></b> + <b>CWR</b>)<i>then </i><b>ldABB</b>, <br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \t<i>if</i> (<b>CRD</b> + <b>CWR</b>) &middot <b>HM</b> <i>then</i> <b>adjLRUCNT</b>,<br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i> <b>CWR</b> <i>then</i> <b>CRP</b>, <br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br</i> ( <i>if</i> <b>CWR</b> <i>then</i> step<sub>3</sub> <i>else</i>(<i>if</i> <b>H/M</b> <i>then</i> step<sub>2</sub> <i>else</i> step<sub>5</sub>)<br /></body></html>");
            this.cacheDesc.addStep("<html><body>step<sub>2</sub>: <b>CRP</b>,<b>clCRD</b><br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br </i> step<sub>0</sub><br /></body></html>");
            this.cacheDesc.addStep("<html><body>step<sub>3</sub>: <b>ldMDRWR</b>, <b>ldMAR</b><br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i> <b>H/M</b> <i>then</i> <b>writeDATA</b>,<br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br </i> step<sub>4</sub><br /></body></html>");
            this.cacheDesc.addStep("<html><body>step<sub>4</sub>: <b>writeMEM</b>, <b>incMEMACC,</b><br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if </i><b>MEMFC</b> <i>then</i> <b>clCWR</b>, <br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br </i>(<i>if </i><b>MEMFC</b> <i>then</i> step<sub>0</sub> <i>else</i> step<sub>4</sub>)<br /></body></html>");
            this.cacheDesc.addStep("<html><body>step<sub>5</sub>: <b>ldMAR</b>, <i>if</i> <b>CNTBB1</b> <i>then</i> <b>CRP</b>,<br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br </i> step<sub>6</sub><br /></body></html>");
            this.cacheDesc.addStep("<html><body>step<sub>6</sub>: <b>incMEMACC</b>, <br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i> <b>MEMFC</b> <i>then</i> <b>ldMDRRD</b>, <br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br</i> (<i>if</i> <b>MEMFC</b> <i>then</i> </i> step<sub>7</sub> <i>else</i> step<sub>6</sub>)<br /></body></html>");
            this.cacheDesc.addStep("<html><body>step<sub>7</sub>: <b>mxADATA</b>, <b>mxDIDATA</b>, <b>writeDATA</b>, <b>incABB</b>, <b>incCNTBB</b>, <br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i> <b>CNTBB0</b> <i>then</i> (<b>mxDATA</b>, <b>ldCDRRD</b>)<br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i> <b>CNTBB3</b> <i>then</i> (<b>writeTAG</b>, <b>writeV</b>, <b>adjLRUCNT</b>, <b>clCRD</b>)<br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br</i> (<i>if</i> <b>CNTBB3</b> <i>then </i>step<sub>0</sub> <i>else</i> step<sub>5</sub>)<br /></body></html>");
        }
    }

    private void initCPUDescription() {
        if (this.cpuDesc == null) {
            this.cpuDesc = new StepDescription();
            this.cpuDesc.addStep("<html><body>step<sub>0</sub>:&nbsp; <i>if</i> ( <b>TV</b>&middot <b><font style=\"text-decoration: overline;\">END</font></b>)<i>then</i> <b>ldWCNT</b>,<br/>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br</i>( <i>if </i> ( <b>TV</b>&middot <b><font style=\"text-decoration: overline;\">END</font></b>)<i>then</i> step<sub>1</sub> <i>else</i> step<sub>0</sub>)<br /></body></html>");
            this.cpuDesc.addStep("<html><body>step<sub>1</sub>:&nbsp; <i>if</i>  <b><font style=\"text-decoration: overline;\">OUT</font></b> <i>then</i> <b>decWCNT</b>,<br/>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i>  <b>OUT</b> <i>then</i> <b>ldMD</b>,<br/>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>br</i> (<i>if </i>  <b>OUT</b><i>then</i> step<sub>2</sub> <i>else</i> step<sub>1</sub>)<br /></body></html>");
            this.cpuDesc.addStep("<html><body>step<sub>2</sub>:&nbsp;<b>ldPAR</b>,<br/>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <i>if</i> <b>TMD<sub>0</sub></b> <i>then</i> <b>ldPDRWR</b>,<br/>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \t<i>br</i> step<sub>3</sub><br /></body></html>");
            this.cpuDesc.addStep("<html><body>step<sub>3</sub>:&nbsp; <i>if</i> <b><font style=\"text-decoration: overline;\">BUSY</font></b> <i>then</i> <b>PRQ</b>,<br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \t<i>br</i> (<i>if</i> <b><font style=\"text-decoration: overline;\">BUSY</font></b> <i>then</i> step<sub>4</sub> <i>else</i> step<sub>3</sub>)<br /></body></html>");
            this.cpuDesc.addStep("<html><body>step<sub>4</sub>:&nbsp; \t<i>br</i> (<i>if</i> <b>CRP</b> <i>then </i>step<sub>5</sub> <i>else </i>step<sub>4</sub>)<br /></body></html>");
            this.cpuDesc.addStep("<html><body>step<sub>5</sub>:&nbsp; <i>if</i><b><font style=\"text-decoration: overline;\">TMD</font><sub>0</sub></b><i>then</i> <b>wrTAB</b>,<br/>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \t<i>br</i> step<sub>6</sub><br /></body></html>");
            this.cpuDesc.addStep("<html><body>step<sub>6</sub>:&nbsp; <b>incECNT</b>,<b>stEND</b><br />&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \t<i>br</i> step<sub>0</sub><br /></body></html>");
        }
    }
}

