/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.SimObject;
import element.SimFrame;
import element.Utility;
import ini.MainJApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.text.MaskFormatter;

public class MEM
extends SimFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel1;
    private JButton btnJump;
    private JFormattedTextField txtJump;
    private JButton btnForward;
    private JButton btnBack;
    private JPanel jPanel3;
    private JPanel mainPanel;
    private JPanel jPanel2;
    private JLabel lblADR3;
    private JButton btnWrite;
    private JLabel lblADR2;
    private JLabel lblADR1;
    private JLabel lblADR0;
    private JFormattedTextField[] niz;
    private static MEM mem = null;
    private boolean readOnly;

    private MEM() {
        this.setDefaultCloseOperation(1);
        this.initGUI();
    }

    public static MEM instance() {
        if (mem == null) {
            mem = new MEM();
        }
        return mem;
    }

    private void initGUI() {
        try {
            MainJApplet.setIcon(this);
            this.getContentPane().setLayout(null);
            this.setLocationRelativeTo(null);
            this.mainPanel = new JPanel();
            this.getContentPane().add(this.mainPanel);
            this.mainPanel.setBounds(0, 0, 471, 261);
            this.mainPanel.setLayout(null);
            this.mainPanel.setBackground(new Color(236, 233, 216));
            this.jPanel1 = new JPanel();
            this.mainPanel.add(this.jPanel1);
            this.jPanel1.setBounds(0, 0, 63, 224);
            this.jPanel1.setLayout(null);
            this.jPanel1.setBackground(new Color(236, 233, 216));
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 0, 0), 1, false), "Adresa", 2, 2));
            this.lblADR0 = new JLabel();
            this.jPanel1.add(this.lblADR0);
            this.lblADR0.setText("00000");
            this.lblADR0.setBounds(14, 21, 42, 28);
            this.lblADR0.setFont(new Font("Tahoma", 1, 11));
            this.lblADR1 = new JLabel();
            this.jPanel1.add(this.lblADR1);
            this.lblADR1.setText("00008");
            this.lblADR1.setBounds(14, 71, 42, 28);
            this.lblADR1.setFont(new Font("Tahoma", 1, 11));
            this.lblADR2 = new JLabel();
            this.jPanel1.add(this.lblADR2);
            this.lblADR2.setText("00010");
            this.lblADR2.setBounds(14, 121, 42, 28);
            this.lblADR2.setFont(new Font("Tahoma", 1, 11));
            this.lblADR3 = new JLabel();
            this.jPanel1.add(this.lblADR3);
            this.lblADR3.setText("00018");
            this.lblADR3.setBounds(14, 170, 42, 28);
            this.lblADR3.setFont(new Font("Tahoma", 1, 11));
            this.jPanel2 = new JPanel();
            this.mainPanel.add(this.jPanel2);
            this.jPanel2.setBounds(63, 0, 406, 224);
            this.jPanel2.setLayout(null);
            this.jPanel2.setBackground(new Color(236, 233, 216));
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 0, 0), 1, false), "Sadr\u017eaj", 2, 2));
            this.niz = new JFormattedTextField[32];
            int xStart = 10;
            int yStart = 25;
            int vertikalniPomeraj = 50;
            int horizontalniPomeraj = 50;
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 8) {
                    MaskFormatter dataMask = new MaskFormatter("HH");
                    this.niz[i * 8 + j] = new JFormattedTextField(dataMask);
                    this.niz[i * 8 + j].setEditable(false);
                    this.niz[i * 8 + j].setBackground(Color.white);
                    this.jPanel2.add(this.niz[i * 8 + j]);
                    this.niz[i * 8 + j].setBounds(xStart, yStart, 35, 21);
                    this.niz[i * 8 + j].setText(Utility.SignalToString(SimObject.instance().getSignals().getMEM()[i * 8 + j], 16, 2));
                    xStart += horizontalniPomeraj;
                    ++j;
                }
                yStart += vertikalniPomeraj;
                xStart -= horizontalniPomeraj * 8;
                ++i;
            }
            this.jPanel3 = new JPanel();
            this.mainPanel.add(this.jPanel3);
            this.jPanel3.setBounds(0, 224, 469, 42);
            this.jPanel3.setLayout(null);
            this.jPanel3.setBackground(new Color(236, 233, 216));
            this.jPanel3.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.btnBack = new JButton();
            this.jPanel3.add(this.btnBack);
            this.btnBack.setText("<<");
            this.btnBack.setBounds(14, 7, 52, 21);
            this.btnBack.setBorder(BorderFactory.createCompoundBorder(new LineBorder(new Color(64, 128, 128), 1, false), BorderFactory.createBevelBorder(0)));
            this.btnBack.setBackground(new Color(255, 255, 251));
            this.btnBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MEM.this.btnBackActionPerformed(evt);
                }
            });
            this.btnForward = new JButton();
            this.jPanel3.add(this.btnForward);
            this.btnForward.setText(">>");
            this.btnForward.setBounds(78, 7, 47, 21);
            this.btnForward.setBorder(BorderFactory.createCompoundBorder(new LineBorder(new Color(64, 128, 128), 1, false), BorderFactory.createBevelBorder(0)));
            this.btnForward.setBackground(new Color(255, 255, 251));
            this.btnForward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MEM.this.btnForwardActionPerformed(evt);
                }
            });
            MaskFormatter dataMask = new MaskFormatter("HHHH");
            this.txtJump = new JFormattedTextField(dataMask);
            this.jPanel3.add(this.txtJump);
            this.txtJump.setBounds(287, 7, 63, 21);
            this.btnJump = new JButton();
            this.jPanel3.add(this.btnJump);
            this.jPanel3.add(this.getBtnWrite());
            this.btnJump.setText("Tra\u017ei");
            this.btnJump.setBounds(357, 7, 105, 21);
            this.btnJump.setBorder(BorderFactory.createCompoundBorder(new LineBorder(new Color(64, 128, 128), 1, false), BorderFactory.createBevelBorder(0)));
            this.btnJump.setBackground(new Color(255, 255, 251));
            this.btnJump.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MEM.this.btnJumpActionPerformed(evt);
                }
            });
            this.setBounds(300, 200, 477, 293);
            this.setTitle("Sadr\u017eaj operativne memorije");
            this.osveziVrednosti();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        int adr = Integer.parseInt(this.lblADR0.getText(), 16);
        int lblwidth = 4;
        if (adr != 0) {
            this.lblADR0.setText(Utility.SignalToString(Utility.DecToBool(adr -= 32, 16), 16, lblwidth));
            this.lblADR1.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
            this.lblADR2.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
            this.lblADR3.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
            adr -= 24;
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 8) {
                    this.niz[i * 8 + j].setText(Utility.SignalToString(SimObject.instance().getSignals().getMEM()[i * 8 + adr + j], 16, 2));
                    ++j;
                }
                ++i;
            }
        }
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        int adr = Integer.parseInt(this.lblADR0.getText(), 16);
        int lblwidth = 4;
        if ((double)adr != Math.pow(2.0, 16.0) - 32.0) {
            this.lblADR0.setText(Utility.SignalToString(Utility.DecToBool(adr += 32, 16), 16, lblwidth));
            this.lblADR1.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
            this.lblADR2.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
            this.lblADR3.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
            adr -= 24;
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 8) {
                    this.niz[i * 8 + j].setText(Utility.SignalToString(SimObject.instance().getSignals().getMEM()[i * 8 + adr + j], 16, 2));
                    ++j;
                }
                ++i;
            }
        }
    }

    private void btnJumpActionPerformed(ActionEvent evt) {
        try {
            int pom = Integer.parseInt(this.txtJump.getText(), 16);
            int adr = pom - pom % 32;
            int lblwidth = 4;
            if ((double)adr <= Math.pow(2.0, 16.0) - 1.0 && adr >= 0) {
                this.lblADR0.setText(Utility.SignalToString(Utility.DecToBool(adr, 16), 16, lblwidth));
                this.lblADR1.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
                this.lblADR2.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
                this.lblADR3.setText(Utility.SignalToString(Utility.DecToBool(adr += 8, 16), 16, lblwidth));
                adr -= 24;
                int i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < 8) {
                        this.niz[i * 8 + j].setText(Utility.SignalToString(SimObject.instance().getSignals().getMEM()[i * 8 + adr + j], 16, 2));
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.txtJump.setText("");
            }
        }
        catch (NumberFormatException e) {
            this.txtJump.setText("");
        }
    }

    public void osveziVrednosti() {
        int pom = Integer.parseInt(Utility.SignalToString(SimObject.instance().getSignals().getMAR(), 16, 4), 16);
        int adr = pom - pom % 32;
        if (adr == Integer.parseInt(this.lblADR0.getText(), 16)) {
            this.niz[pom % 32].setText(Utility.SignalToString(SimObject.instance().getSignals().getMEM()[pom], 16, 2));
        }
    }

    public void setReadOnly(boolean read) {
        this.readOnly = read;
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 8) {
                this.niz[i * 8 + j].setEditable(!read);
                ++j;
            }
            ++i;
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    private JButton getBtnWrite() {
        if (this.btnWrite == null) {
            this.btnWrite = new JButton();
            this.btnWrite.setText("Upi\u0161i");
            this.btnWrite.setBounds(137, 7, 94, 21);
            this.btnWrite.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    MEM.this.btnWriteMouseClicked(evt);
                }
            });
        }
        return this.btnWrite;
    }

    private void btnWriteMouseClicked(MouseEvent evt) {
        int start;
        int i = start = Integer.parseInt(this.lblADR0.getText(), 16);
        while (i < start + 32) {
            SimObject.instance().getSignals().setMEM(i, Utility.HexToBool(this.niz[i - start].getText(), 8));
            ++i;
        }
    }

    @Override
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getBlockTitle() {
        return null;
    }
}

