/*
 * Decompiled with CFR 0.152.
 */
package setasoc.cpu;

import common.CacheGlobal;
import control.SignalCacheSetAsoc;
import control.SimObject;
import element.LineSegment;
import element.Navigator;
import exception.SignalWidthException;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import setasoc.cache.CacheCacheCPUInterfaceUnit;
import setasoc.cache.CacheCacheControlUnit;
import setasoc.cache.CacheCacheIndicatorsUnit;
import setasoc.cache.CacheCacheMEMInterfaceUnit;
import setasoc.cache.CacheCacheTAGMemoryUnit;
import setasoc.cache.CacheCacheUnit;
import setasoc.cache.CacheCounters;
import setasoc.cache.CacheDATAMemory;
import setasoc.cache.CacheFIFOUnit;
import setasoc.cpu.CacheCPUCacheInterface;
import setasoc.cpu.CacheCPUControlUnit;
import setasoc.cpu.CacheCPUOperGenUnit;
import setasoc.cpu.CacheCPUUnit;
import view.CacheMemFrameSet;
import view.RegisterWindow;
import view.RegisterWindowSetAsoc;

public class CacheGlobalSetAsoc
extends CacheGlobal {
    private static final long serialVersionUID = 1L;
    private LineSegment linijaBUSY;
    private LineSegment linijaPRQCC;
    private LineSegment linijaPRQSC;
    private JLabel lblFIFOUnit;
    private static CacheGlobalSetAsoc frame = null;
    private RegisterWindowSetAsoc rw = null;
    private CacheMemFrameSet dataMem = null;
    private CacheMemFrameSet tagMem = null;

    public CacheGlobalSetAsoc() {
        this.initGUI();
        this.btnCLKMouseClicked(null);
        this.refreshStepDescription();
    }

    private void initGUI() {
        try {
            this.lblGlobal.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("slike/setasoc/CacheGlobal.jpg")));
            this.lblGlobal.add(this.getLinijaBUSY());
            this.linijaPRQCC = new LineSegment();
            this.lblGlobal.add(this.linijaPRQCC);
            this.linijaPRQCC.setBounds(107, 219, 135, 1);
            this.linijaPRQSC = new LineSegment();
            this.lblGlobal.add(this.linijaPRQSC);
            this.linijaPRQSC.setBounds(107, 254, 134, 1);
            Navigator.instance().setCurrentWindow(this);
            CacheCacheUnit.instance().setHomeFrame(this);
            CacheCPUUnit.instance().setHomeFrame(this);
            this.mainPanel.add((Component)this.pnlGlobal, "global");
            this.pnlGlobal.setSize(600, 800);
            this.mainPanel.add((Component)CacheCacheUnit.instance().getMainPanel(), "CacheUnit");
            this.mainPanel.add((Component)CacheCPUUnit.instance().getMainPanel(), "CPUUnit");
            this.getContentPane().add((Component)this.pnlMenu, "South");
            this.pnlMenu.setPreferredSize(new Dimension(792, 164));
            this.setTitle("Ke\u0161 memorija sa set-asocijativnim preslikavanjem");
            this.pnlCacheStructure.add(this.getLblFIFOUnit());
            this.pack();
            this.setSize(900, 850);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void JumpToCPU() {
        CardLayout cl = (CardLayout)this.mainPanel.getLayout();
        cl.show(this.mainPanel, "CPUUnit");
        Navigator.instance().setCurrentWindow(CacheCPUUnit.instance());
    }

    @Override
    public void JumpToCache() {
        CardLayout cl = (CardLayout)this.mainPanel.getLayout();
        cl.show(this.mainPanel, "CacheUnit");
        Navigator.instance().setCurrentWindow(CacheCacheUnit.instance());
    }

    @Override
    public void JumpToCPUControlUnit() {
        super.JumpToCPUControlUnit();
        JPanel mPanel = CacheCPUUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CPUControlUnit");
        Navigator.instance().setCurrentWindow(CacheCPUControlUnit.instance());
    }

    @Override
    public void JumpToIndicators() {
        super.JumpToIndicators();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CacheIndicators");
        Navigator.instance().setCurrentWindow(CacheCacheIndicatorsUnit.instance());
    }

    @Override
    public void JumpToCountersUnit() {
        super.JumpToCountersUnit();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CacheCounters");
        Navigator.instance().setCurrentWindow(CacheCounters.instance());
    }

    @Override
    public void JumpToCacheControlUnit() {
        super.JumpToCacheControlUnit();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CacheControl");
        Navigator.instance().setCurrentWindow(CacheCacheControlUnit.instance());
    }

    @Override
    public void JumpToGenOperUnit() {
        super.JumpToGenOperUnit();
        JPanel mPanel = CacheCPUUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CPUOperGenUnit");
        Navigator.instance().setCurrentWindow(CacheCPUOperGenUnit.instance());
    }

    @Override
    public void JumpToCacheIntUnit() {
        super.JumpToCacheIntUnit();
        JPanel mPanel = CacheCPUUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CPUCacheInterface");
        Navigator.instance().setCurrentWindow(CacheCPUCacheInterface.instance());
    }

    @Override
    public void JumpToCPUIntUnit() {
        super.JumpToCPUIntUnit();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CPUInterface");
        Navigator.instance().setCurrentWindow(CacheCacheCPUInterfaceUnit.instance());
    }

    @Override
    public void JumpToTagMemUnit() {
        super.JumpToTagMemUnit();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CacheTAGMemory");
        Navigator.instance().setCurrentWindow(CacheCacheTAGMemoryUnit.instance());
    }

    @Override
    public void JumpToDataMemUnit() {
        super.JumpToDataMemUnit();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CacheDATAMemory");
        Navigator.instance().setCurrentWindow(CacheDATAMemory.instance());
    }

    @Override
    public void JumpToMemIntUnit() {
        super.JumpToMemIntUnit();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "CacheMEMInterface");
        Navigator.instance().setCurrentWindow(CacheCacheMEMInterfaceUnit.instance());
    }

    public void JumpToFIFOUnit() {
        this.JumpToCache();
        JPanel mPanel = CacheCacheUnit.instance().getMainPanel();
        CardLayout cl = (CardLayout)mPanel.getLayout();
        cl.show(mPanel, "FIFOUnit");
        Navigator.instance().setCurrentWindow(CacheFIFOUnit.instance());
    }

    @Override
    protected void btnRegistersMouseClicked(MouseEvent evt) {
        RegisterWindowSetAsoc rw = new RegisterWindowSetAsoc();
        rw.setVisible(true);
        rw.refresh();
    }

    public static CacheGlobalSetAsoc instance() {
        if (frame == null) {
            frame = new CacheGlobalSetAsoc();
        }
        return frame;
    }

    public static Object getGUIBuilderInstance() {
        return new CacheGlobalSetAsoc(Boolean.FALSE);
    }

    public CacheGlobalSetAsoc(Boolean initGUI) {
    }

    private LineSegment getLinijaBUSY() {
        if (this.linijaBUSY == null) {
            this.linijaBUSY = new LineSegment();
            this.linijaBUSY.setBounds(107, 428, 133, 1);
        }
        return this.linijaBUSY;
    }

    @Override
    public void refresh() {
        super.refresh();
        SignalCacheSetAsoc s = (SignalCacheSetAsoc)SimObject.instance().getSignals();
        this.linijaBUSY.setCondition(s.isBUSY());
        this.linijaPRQCC.setCondition(s.isPRQCC());
        this.linijaPRQSC.setCondition(s.isPRQSC());
    }

    private JLabel getLblFIFOUnit() {
        if (this.lblFIFOUnit == null) {
            this.lblFIFOUnit = new JLabel();
            this.lblFIFOUnit.setText("fifokola");
            this.lblFIFOUnit.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblFIFOUnit.setHorizontalAlignment(0);
            this.lblFIFOUnit.setOpaque(true);
            this.lblFIFOUnit.setBackground(new Color(235, 245, 245));
            this.lblFIFOUnit.setBounds(71, 67, 53, 18);
            this.lblFIFOUnit.setFont(new Font("Tahoma", 1, 10));
            this.lblFIFOUnit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobalSetAsoc.instance().JumpToFIFOUnit();
                }
            });
        }
        return this.lblFIFOUnit;
    }

    @Override
    public void showDATA() {
        CacheMemFrameSet df = this.getDataMem();
        df.setTitle("Sadr\u017eaj DATA memorije");
        df.setPanelTitle("DATA");
        df.setColorRows(true);
        df.setBlockSize((int)Math.pow(2.0, 5.0) / 8);
        df.addBlockColumn();
        SignalCacheSetAsoc s = (SignalCacheSetAsoc)SimObject.instance().getSignals();
        df.refresh(s.getDATA0(), s.getDATA1());
        df.setVisible(true);
    }

    @Override
    public void showTAG() {
        CacheMemFrameSet tf = this.getTagMem();
        tf.setTitle("Sadr\u017eaj TAG memorije");
        tf.setPanelTitle("TAG");
        SignalCacheSetAsoc s = (SignalCacheSetAsoc)SimObject.instance().getSignals();
        tf.refresh(s.getTAG0(), s.getTAG1());
        tf.setVisible(true);
    }

    @Override
    protected void btnCLKMouseClicked(MouseEvent evt) {
        super.btnCLKMouseClicked(evt);
        SignalCacheSetAsoc s = (SignalCacheSetAsoc)SimObject.instance().getSignals();
        if (this.getRegisterWindow().isVisible()) {
            this.getRegisterWindow().refresh();
        }
        if (this.getTagMem().isVisible()) {
            this.getTagMem().refresh(s.getTAG0(), s.getTAG1());
        }
        if (this.getDataMem().isVisible()) {
            this.getDataMem().refresh(s.getDATA0(), s.getDATA1());
        }
    }

    protected CacheMemFrameSet getDataMem() {
        if (this.dataMem == null) {
            this.dataMem = new CacheMemFrameSet((int)Math.pow(2.0, 5.0) / 2);
        }
        return this.dataMem;
    }

    protected RegisterWindow getRegisterWindow() {
        if (this.rw == null) {
            this.rw = new RegisterWindowSetAsoc();
        }
        return this.rw;
    }

    protected CacheMemFrameSet getTagMem() {
        if (this.tagMem == null) {
            this.tagMem = new CacheMemFrameSet(4);
        }
        return this.tagMem;
    }

    @Override
    protected void reset() {
        try {
            SignalCacheSetAsoc oldSignals = (SignalCacheSetAsoc)SimObject.instance().getSignals();
            SignalCacheSetAsoc newSignals = new SignalCacheSetAsoc();
            newSignals.setMEM(oldSignals.getCopyOfMEM());
            newSignals.setTab(oldSignals.getCopyOfTAB());
            SimObject.instance().setSignals(newSignals);
            this.setTclk();
        }
        catch (SignalWidthException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getBlockTitle() {
        return "Kes memorija sa set-asocijativnim preslikavanjem";
    }
}

