/*
 * Decompiled with CFR 0.152.
 */
package ini;

import control.Constants;
import control.SimObject;
import element.TAB;
import element.Utility;
import exception.SignalWidthException;
import ini.MainJApplet;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.text.MaskFormatter;

public class CacheReq
extends JFrame {
    private static final long serialVersionUID = 1L;
    public JPanel jPanel1;
    private JPanel pnlOperation;
    private JButton btnBack;
    private JButton btnOK;
    private JFormattedTextField ftxtWait;
    private JLabel lblWait;
    private JFormattedTextField ftxtData;
    private JFormattedTextField ftxtAdresa;
    private JRadioButton rbCompleteClear;
    private JRadioButton rbSelectiveClear;
    private JRadioButton rbWrite;
    private JRadioButton rbRead;
    private ButtonGroup bgOperation;
    private JLabel lblData;
    private JLabel lblAdr;
    private boolean editableMode;
    private int reqNumber;
    private MainJApplet iniFrame;

    public CacheReq(int simtype, int reqNumber) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initGUI();
        this.reqNumber = reqNumber;
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
    }

    private void initGUI() {
        try {
            MainJApplet.setIcon(this);
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            this.setAlwaysOnTop(true);
            this.jPanel1 = new JPanel();
            this.getContentPane().add(this.jPanel1);
            this.jPanel1.setLayout(null);
            this.jPanel1.setBounds(0, 0, 540, 348);
            this.jPanel1.setDebugGraphicsOptions(4);
            this.lblAdr = new JLabel();
            this.jPanel1.add(this.lblAdr);
            this.lblAdr.setText("Adresa");
            this.lblAdr.setBounds(18, 209, 245, 21);
            this.lblData = new JLabel();
            this.jPanel1.add(this.lblData);
            this.lblData.setText("Podatak");
            this.lblData.setBounds(18, 245, 245, 18);
            this.lblData.setVisible(false);
            this.pnlOperation = new JPanel();
            this.jPanel1.add(this.pnlOperation);
            this.pnlOperation.setLayout(null);
            this.pnlOperation.setBounds(20, 20, 312, 138);
            this.pnlOperation.setBorder(BorderFactory.createTitledBorder("Operacija"));
            this.pnlOperation.setName("Operacija");
            this.rbRead = new JRadioButton();
            this.pnlOperation.add(this.rbRead);
            this.rbRead.setText("\u010citanje");
            this.rbRead.setBounds(21, 15, 204, 18);
            this.rbRead.setSelected(true);
            this.rbRead.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheReq.this.rbWriteMouseClicked(evt);
                }
            });
            this.getBgOperation().add(this.rbRead);
            this.rbWrite = new JRadioButton();
            this.pnlOperation.add(this.rbWrite);
            this.rbWrite.setText("Upis");
            this.rbWrite.setBounds(21, 44, 204, 18);
            this.rbWrite.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheReq.this.rbWriteMouseClicked(evt);
                }
            });
            this.getBgOperation().add(this.rbWrite);
            this.rbSelectiveClear = new JRadioButton();
            this.pnlOperation.add(this.rbSelectiveClear);
            this.rbSelectiveClear.setText("Selektivno vra\u0107anje");
            this.rbSelectiveClear.setVisible(Constants.simType != 1);
            this.rbSelectiveClear.setBounds(21, 75, 204, 18);
            this.rbSelectiveClear.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheReq.this.rbWriteMouseClicked(evt);
                }
            });
            this.getBgOperation().add(this.rbSelectiveClear);
            this.rbCompleteClear = new JRadioButton();
            this.pnlOperation.add(this.rbCompleteClear);
            this.rbCompleteClear.setText("Kompletno vra\u0107anje");
            this.rbCompleteClear.setBounds(21, 106, 204, 18);
            this.rbCompleteClear.setVisible(Constants.simType != 1);
            this.rbCompleteClear.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheReq.this.rbWriteMouseClicked(evt);
                }
            });
            this.getBgOperation().add(this.rbCompleteClear);
            MaskFormatter adrMask = new MaskFormatter("HHHH");
            this.ftxtAdresa = new JFormattedTextField(adrMask);
            this.jPanel1.add(this.ftxtAdresa);
            this.ftxtAdresa.setBounds(86, 209, 245, 21);
            this.ftxtAdresa.setToolTipText("Adresa u operativnoj memoriji koja ce biti koriscena za izvrsavanje operacije.\nUnosi se u heksadecimalnom formatu, u opsegu od 0000h do FFFFh.");
            MaskFormatter dataMask = new MaskFormatter("HH");
            this.ftxtData = new JFormattedTextField(dataMask);
            this.jPanel1.add(this.ftxtData);
            this.jPanel1.add(this.getLblWait());
            this.jPanel1.add(this.getFtxtWait());
            this.jPanel1.add(this.getBtnOK());
            this.jPanel1.add(this.getBtnBack());
            this.ftxtData.setBounds(86, 244, 245, 20);
            this.ftxtData.setVisible(false);
            this.ftxtData.setToolTipText("Unosi se u heksadecimalnom formatu, u opsegu od 00h do FFh.");
            this.pack();
            this.setSize(540, 380);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ButtonGroup getBgOperation() {
        if (this.bgOperation == null) {
            this.bgOperation = new ButtonGroup();
        }
        return this.bgOperation;
    }

    public void saveData() {
        SimObject.instance().getSignals().getTAB().writeV(this.reqNumber, true);
        boolean[] mode = new boolean[2];
        boolean[] adr = new boolean[16];
        boolean[] data = new boolean[8];
        boolean[] wait = new boolean[8];
        mode[1] = this.rbSelectiveClear.isSelected() || this.rbCompleteClear.isSelected();
        mode[0] = this.rbCompleteClear.isSelected() || this.rbWrite.isSelected();
        adr = Utility.HexToBool(this.ftxtAdresa.getText(), 16);
        String txtData = this.ftxtData.getText().trim();
        data = txtData.isEmpty() ? Utility.HexToBool("00", 8) : Utility.HexToBool(txtData, 8);
        wait = Utility.DecToBool(Integer.parseInt(this.ftxtWait.getText()), 8);
        try {
            SimObject.instance().getSignals().getTAB().writeMODE(this.reqNumber, mode);
            SimObject.instance().getSignals().getTAB().writeADR(this.reqNumber, adr);
            SimObject.instance().getSignals().getTAB().writeDATA(this.reqNumber, data);
            SimObject.instance().getSignals().getTAB().writeWAIT(this.reqNumber, wait);
        }
        catch (SignalWidthException e) {
            e.printStackTrace();
        }
    }

    public void loadData() {
        TAB tab = SimObject.instance().getSignals().getTAB();
        this.ftxtAdresa.setText(Utility.SignalToString(tab.readADR(this.reqNumber), 16, 4));
        this.ftxtData.setText(Utility.SignalToString(tab.readDATA(this.reqNumber), 16, 2));
        boolean[] mode = new boolean[2];
        mode = tab.readMODE(this.reqNumber);
        this.rbRead.setSelected(!mode[1] && !mode[0]);
        this.rbWrite.setSelected(!mode[1] && mode[0]);
        this.rbSelectiveClear.setSelected(mode[1] && !mode[0]);
        this.rbCompleteClear.setSelected(mode[1] && mode[0]);
        this.lblData.setVisible(this.rbWrite.isSelected());
        this.ftxtData.setVisible(this.rbWrite.isSelected());
        this.ftxtWait.setText(Integer.toString(Utility.BoolToDec(tab.readWAIT(this.reqNumber))));
    }

    private JLabel getLblWait() {
        if (this.lblWait == null) {
            this.lblWait = new JLabel();
            this.lblWait.setText("\u010cekanje");
            this.lblWait.setBounds(18, 179, 246, 18);
        }
        return this.lblWait;
    }

    private JFormattedTextField getFtxtWait() {
        if (this.ftxtWait == null) {
            MaskFormatter mf = null;
            try {
                mf = new MaskFormatter("00##");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.ftxtWait = new JFormattedTextField(mf);
            this.ftxtWait = new JFormattedTextField();
            this.ftxtWait.setBounds(86, 178, 245, 20);
        }
        return this.ftxtWait;
    }

    private void rbWriteMouseClicked(MouseEvent evt) {
        this.lblData.setVisible(this.rbWrite.isSelected());
        this.ftxtData.setVisible(this.rbWrite.isSelected());
    }

    public boolean isEditableMode() {
        return this.editableMode;
    }

    public void setEditableMode(boolean editableMode) {
        this.editableMode = editableMode;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setText("U redu");
            this.btnOK.setBounds(346, 317, 74, 21);
            this.btnOK.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheReq.this.btnOKMouseClicked(evt);
                }
            });
        }
        return this.btnOK;
    }

    private void btnOKMouseClicked(MouseEvent evt) {
        this.iniFrame.setReqNo(this.reqNumber + 1);
        this.saveData();
        this.iniFrame.refresh();
        this.dispose();
    }

    public void setIniFrame(MainJApplet iniFrame) {
        this.iniFrame = iniFrame;
    }

    private JButton getBtnBack() {
        if (this.btnBack == null) {
            this.btnBack = new JButton();
            this.btnBack.setText("Nazad");
            this.btnBack.setBounds(445, 316, 74, 22);
            this.btnBack.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheReq.this.btnBackMouseClicked(evt);
                }
            });
        }
        return this.btnBack;
    }

    private void btnBackMouseClicked(MouseEvent evt) {
        this.dispose();
    }
}

