/*
 * Decompiled with CFR 0.152.
 */
package element;

import exception.SignalWidthException;
import java.io.Serializable;

public class TAB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Entry[] memory;
    private int wWAIT;
    private int wADR;
    private int wDATA;
    private int wMODE;

    public TAB() {
        this.memory = new Entry[32];
    }

    public TAB(int wWAIT, int wADR, int wDATA, int wMODE) throws SignalWidthException {
        this.wWAIT = wWAIT;
        this.wADR = wADR;
        this.wDATA = wDATA;
        this.wMODE = wMODE;
        if (wWAIT + wADR + wDATA + wMODE + 1 != 35) {
            throw new SignalWidthException();
        }
        this.memory = new Entry[32];
        int i = 0;
        while (i < this.memory.length) {
            this.memory[i] = new Entry();
            ++i;
        }
    }

    public boolean readV(int entry) {
        if (this.checkEntry(entry)) {
            return this.memory[entry].V;
        }
        return false;
    }

    public void writeV(int entry, boolean value) {
        if (this.checkEntry(entry)) {
            this.memory[entry].V = value;
        }
    }

    public boolean[] readWAIT(int entry) {
        if (this.checkEntry(entry)) {
            return this.memory[entry].WAIT;
        }
        return null;
    }

    public void writeWAIT(int entry, boolean[] value) throws SignalWidthException {
        if (value.length != this.wWAIT) {
            throw new SignalWidthException();
        }
        if (this.checkEntry(entry)) {
            System.arraycopy(value, 0, this.memory[entry].WAIT, 0, this.wWAIT);
        }
    }

    public boolean[] readADR(int entry) {
        if (this.checkEntry(entry)) {
            return this.memory[entry].ADR;
        }
        return null;
    }

    public void writeADR(int entry, boolean[] value) throws SignalWidthException {
        if (value.length != this.wADR) {
            throw new SignalWidthException();
        }
        if (this.checkEntry(entry)) {
            System.arraycopy(value, 0, this.memory[entry].ADR, 0, this.wADR);
        }
    }

    public boolean[] readDATA(int entry) {
        if (this.checkEntry(entry)) {
            return this.memory[entry].DATA;
        }
        return null;
    }

    public void writeDATA(int entry, boolean[] value) throws SignalWidthException {
        if (value.length != this.wDATA) {
            throw new SignalWidthException();
        }
        if (this.checkEntry(entry)) {
            System.arraycopy(value, 0, this.memory[entry].DATA, 0, this.wDATA);
        }
    }

    public boolean[] readMODE(int entry) {
        if (this.checkEntry(entry)) {
            return this.memory[entry].MODE;
        }
        return null;
    }

    public void writeMODE(int entry, boolean[] value) throws SignalWidthException {
        if (value.length != this.wMODE) {
            throw new SignalWidthException();
        }
        if (this.checkEntry(entry)) {
            System.arraycopy(value, 0, this.memory[entry].MODE, 0, this.wMODE);
        }
    }

    public void deleteEntry(int entry) {
        if (this.checkEntry(entry)) {
            if (entry == 31) {
                this.memory[entry].reset();
            } else {
                int i = entry;
                while (i < this.countValidRequests() - 1) {
                    this.memory[i].V = this.memory[i + 1].V;
                    System.arraycopy(this.memory[i + 1].MODE, 0, this.memory[i].MODE, 0, this.wMODE);
                    System.arraycopy(this.memory[i + 1].WAIT, 0, this.memory[i].WAIT, 0, this.wWAIT);
                    System.arraycopy(this.memory[i + 1].ADR, 0, this.memory[i].ADR, 0, this.wADR);
                    System.arraycopy(this.memory[i + 1].DATA, 0, this.memory[i].DATA, 0, this.wDATA);
                    ++i;
                }
                this.memory[this.countValidRequests() - 1].reset();
            }
        }
    }

    private boolean checkEntry(int entry) {
        return entry >= 0 && entry < 32;
    }

    public void setV(boolean value) {
        int i = 0;
        while (i < 32) {
            this.memory[i].V = value;
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < 32) {
            this.memory[i].reset();
            ++i;
        }
    }

    public int countValidRequests() {
        int count = 0;
        int i = 0;
        while (i < 32) {
            if (this.memory[i].V) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean V;
        public boolean[] WAIT;
        public boolean[] ADR;
        public boolean[] DATA;
        public boolean[] MODE;

        public Entry() {
            this.WAIT = new boolean[TAB.this.wWAIT];
            this.ADR = new boolean[TAB.this.wADR];
            this.DATA = new boolean[TAB.this.wDATA];
            this.MODE = new boolean[TAB.this.wMODE];
        }

        public void reset() {
            this.V = false;
            int i = 0;
            while (i < this.WAIT.length) {
                this.WAIT[i] = false;
                ++i;
            }
            i = 0;
            while (i < this.ADR.length) {
                this.ADR[i] = false;
                ++i;
            }
            i = 0;
            while (i < this.DATA.length) {
                this.DATA[i] = false;
                ++i;
            }
            i = 0;
            while (i < this.MODE.length) {
                this.MODE[i] = false;
                ++i;
            }
        }
    }
}

