/*
 * Decompiled with CFR 0.152.
 */
package view;

import element.Utility;
import ini.MainJApplet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class CacheMemFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel pnlCentral;
    private JTable tblMem;
    private JScrollPane jScrollPane1;
    private int size = 8;
    private boolean colorRows;
    private int blockSize;

    public void setColorRows(boolean colorRows) {
        this.colorRows = colorRows;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public CacheMemFrame() {
        this.initGUI();
        this.setResizable(false);
    }

    public CacheMemFrame(int size) {
        this.size = size;
        this.initGUI();
    }

    public void refresh(boolean[][] mem) {
        int length = 0;
        length = (int)Math.ceil((double)mem[0].length / 4.0);
        int i = 0;
        while (i < this.size) {
            this.tblMem.getModel().setValueAt(String.valueOf(Utility.SignalToString(mem[i], 16, length)) + "h", i, 1);
            ++i;
        }
    }

    private void initGUI() {
        try {
            MainJApplet.setIcon(this);
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(null);
            this.pnlCentral = new JPanel();
            this.getContentPane().add((Component)this.pnlCentral, "Center");
            this.pnlCentral.setLayout(null);
            this.pnlCentral.setPreferredSize(new Dimension(350, 198));
            DefaultTableModel tblTABModel = new DefaultTableModel(new String[this.size][2], new String[]{"ADR", "DATA"});
            this.tblMem = new JTable(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                    Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                    if (CacheMemFrame.this.colorRows) {
                        if (rowIndex / CacheMemFrame.this.blockSize % 2 == 1 && !this.isCellSelected(rowIndex, vColIndex)) {
                            c.setBackground(new Color(232, 243, 255));
                        } else {
                            c.setBackground(this.getBackground());
                        }
                    }
                    return c;
                }
            };
            this.pnlCentral.add(this.tblMem);
            this.tblMem.setModel(tblTABModel);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(0);
            int i = 0;
            while (i < this.tblMem.getColumnCount()) {
                this.tblMem.setDefaultRenderer(this.tblMem.getColumnClass(i), renderer);
                ++i;
            }
            this.tblMem.updateUI();
            this.tblMem.setBounds(229, 142, 205, 81);
            this.tblMem.setEnabled(false);
            this.jScrollPane1 = new JScrollPane(this.tblMem);
            this.pnlCentral.add(this.jScrollPane1);
            this.jScrollPane1.setBounds(28, 26, 296, 148);
            int i2 = 0;
            while (i2 < this.size) {
                this.tblMem.getModel().setValueAt(Integer.toHexString(i2).toUpperCase(), i2, 0);
                ++i2;
            }
            this.pack();
            this.setSize(357, 232);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addBlockColumn() {
        if (this.tblMem.getColumnCount() == 2) {
            ((DefaultTableModel)this.tblMem.getModel()).addColumn("BLOCK");
            this.tblMem.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.tblMem.getColumnModel().getColumn(1).setPreferredWidth(70);
            this.tblMem.getColumnModel().getColumn(2).setPreferredWidth(30);
            this.tblMem.getTableHeader().setReorderingAllowed(false);
            this.tblMem.moveColumn(this.tblMem.getColumnCount() - 1, 0);
            int i = 0;
            while (i < this.size) {
                this.tblMem.getModel().setValueAt(i / this.blockSize, i, 2);
                ++i;
            }
        }
    }
}

