/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.BADevice;
import control.Device;
import control.MemoryModul;
import control.SADevice;

public class SignalInterleaving {
    private Device[] devices;
    private MemoryModul[] moduls;
    private boolean[] ABUS = new boolean[24];
    private boolean[] DBUS = new boolean[8];
    private boolean WRBUS = false;
    private boolean RDBUS = false;
    private boolean ACKBUS = false;
    private boolean DABUS = false;
    private boolean[] BRQ = new boolean[32];
    private boolean[] BG = new boolean[32];
    private boolean enablePCODE = false;
    private boolean[] PCODEout = new boolean[5];
    private boolean[] BGRin = new boolean[32];

    public SignalInterleaving() {
        this.devices = new Device[16];
        this.moduls = new MemoryModul[16];
        int i = 0;
        while (i < this.moduls.length) {
            this.moduls[i] = new MemoryModul();
            ++i;
        }
    }

    public void clock() {
    }

    public Device[] getDevices() {
        return this.devices;
    }

    public void setDevices(Device[] devices) {
        this.devices = devices;
    }

    public MemoryModul[] getModuls() {
        return this.moduls;
    }

    public void setModuls(MemoryModul[] moduls) {
        this.moduls = moduls;
    }

    public Device getDevice(int i) {
        if (i >= 0 && i < 16) {
            return this.devices[i];
        }
        return null;
    }

    public MemoryModul getModul(int i) {
        if (i >= 0 && i < 16) {
            return this.moduls[i];
        }
        return null;
    }

    public void createDevice(int type, int index) {
        if (index >= 0 && index < 16) {
            switch (type) {
                case 1: {
                    this.devices[index] = new BADevice();
                    break;
                }
                case 2: {
                    this.devices[index] = new SADevice();
                }
            }
        }
    }

    public boolean[] getABUS() {
        return this.ABUS;
    }

    public void setABUS(boolean[] abus) {
        this.ABUS = abus;
    }

    public boolean[] getDBUS() {
        return this.DBUS;
    }

    public void setDBUS(boolean[] dbus) {
        this.DBUS = dbus;
    }

    public boolean isWRBUS() {
        return this.WRBUS;
    }

    public void setWRBUS(boolean wrbus) {
        this.WRBUS = wrbus;
    }

    public boolean isRDBUS() {
        return this.RDBUS;
    }

    public void setRDBUS(boolean rdbus) {
        this.RDBUS = rdbus;
    }

    public boolean isACKBUS() {
        return this.ACKBUS;
    }

    public void setACKBUS(boolean ackbus) {
        this.ACKBUS = ackbus;
    }

    public boolean isDABUS() {
        return this.DABUS;
    }

    public void setDABUS(boolean dabus) {
        this.DABUS = dabus;
    }

    public boolean[] getBRQ() {
        return this.BRQ;
    }

    public void setBRQ(boolean[] brq) {
        this.BRQ = brq;
    }

    public boolean[] getBG() {
        return this.BG;
    }

    public void setBG(boolean[] bg) {
        this.BG = bg;
    }

    public boolean isEnablePCODE() {
        return this.enablePCODE;
    }

    public void setEnablePCODE(boolean enablePCODE) {
        this.enablePCODE = enablePCODE;
    }

    public boolean[] getPCODEout() {
        return this.PCODEout;
    }

    public void setPCODEout(boolean[] eout) {
        this.PCODEout = eout;
    }

    public boolean[] getBGRin() {
        return this.BGRin;
    }

    public void setBGRin(boolean[] rin) {
        this.BGRin = rin;
    }
}

