/*
 * Decompiled with CFR 0.152.
 */
package common;

import control.SignalCache;
import control.SimObject;
import element.DisplaySignal;
import element.LineSegment;
import element.LinkLabel;
import element.Navigator;
import element.SimFrame;
import element.Utility;
import ini.MainJApplet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import view.MEM;

public abstract class CacheGlobal
extends SimFrame {
    private static final long serialVersionUID = 1L;
    protected JPanel pnlGlobal;
    protected JLabel lblGlobal;
    private LineSegment linijaPRQRD;
    protected JPanel pnlMenu;
    private LinkLabel lblMEM;
    private LinkLabel lblCache;
    private LinkLabel lblCPU;
    private JButton btnBack;
    private JButton btnCLK;
    private JTextField txtTclk;
    private JLabel lblTclk;
    private JButton btnProg;
    private JButton btnLoad;
    private JButton btnSave;
    private JButton btnReset;
    private JButton btnInit;
    private JButton btnDATA;
    private JButton btnTAG;
    private JButton btnTAB;
    private JButton btnRegisters;
    private JEditorPane txtCacheInfo;
    private JEditorPane txtCPUInfo;
    private JPanel pnlCacheInfo;
    private JPanel pnlCPUInfo;
    private JTabbedPane tabDEcription;
    private JButton btnOper;
    private JPanel pnlSimulation;
    private JLabel lblMEMTitle;
    private JLabel lblCacheStructure;
    private JLabel lblCPUStructure;
    protected JPanel pnlStructureSchema;
    private JPanel pnlStructureLabels;
    private JLabel lblMEMStructure;
    private JLabel lblMemInt;
    protected JLabel lblDATAMem;
    protected JPanel pnlCacheStructure;
    private JPanel pnlCPUStructure;
    protected JLabel lblTAGMem;
    protected JLabel lblCounters;
    protected JLabel lblIndicators;
    private JLabel lblCPUInt;
    private JLabel lblCPUControlUnit;
    private JLabel lblCacheInt;
    private JLabel lblCACHEControlUnit;
    private JLabel btnGenOper;
    private JPanel pnlStructure;
    private DisplaySignal sglMEMDRD;
    private DisplaySignal sglMAR;
    private DisplaySignal sglMDRWR;
    private DisplaySignal sglPDRWR;
    private DisplaySignal sglCDRRD;
    private DisplaySignal sglPAR;
    private LineSegment linijaWriteMEM;
    private LineSegment linijaCRP;
    private LineSegment linijaPRQWR;

    public CacheGlobal() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.pnlGlobal = new JPanel();
            this.pnlGlobal.setLayout(null);
            this.pnlGlobal.setPreferredSize(new Dimension(600, 800));
            this.pnlGlobal.setBackground(new Color(255, 255, 255));
            this.lblGlobal = new JLabel();
            this.pnlGlobal.add(this.lblGlobal);
            this.lblGlobal.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("slike/direct/CacheGlobal.jpg")));
            this.lblGlobal.setBounds(151, 50, 589, 464);
            this.linijaPRQWR = new LineSegment();
            this.lblGlobal.add(this.linijaPRQWR);
            this.linijaPRQWR.setBounds(107, 290, 135, 1);
            this.linijaPRQRD = new LineSegment();
            this.lblGlobal.add(this.linijaPRQRD);
            this.linijaPRQRD.setBounds(107, 325, 135, 1);
            this.linijaCRP = new LineSegment();
            this.lblGlobal.add(this.linijaCRP);
            this.lblGlobal.add(this.getSglPAR());
            this.lblGlobal.add(this.getSglCDRRD());
            this.lblGlobal.add(this.getSglPDRWR());
            this.lblGlobal.add(this.getSglMDRWR());
            this.lblGlobal.add(this.getSglMAR());
            this.lblGlobal.add(this.getSglMEMDRD());
            this.linijaCRP.setBounds(107, 408, 135, 1);
            this.lblCPU = new LinkLabel();
            this.pnlGlobal.add(this.lblCPU);
            this.lblCPU.setBounds(153, 75, 105, 417);
            this.lblCPU.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    CacheGlobal.this.lblCPUMouseEntered(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCPUMouseClicked(evt);
                }
            });
            this.lblCache = new LinkLabel();
            this.pnlGlobal.add(this.lblCache);
            this.lblCache.setBounds(391, 78, 107, 414);
            this.lblCache.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    CacheGlobal.this.lblCacheMouseExited(evt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    CacheGlobal.this.lblCacheMouseEntered(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCacheMouseClicked(evt);
                }
            });
            this.lblMEM = new LinkLabel();
            this.pnlGlobal.add(this.lblMEM);
            this.lblMEM.setBounds(633, 75, 105, 414);
            this.lblMEM.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblMEMMouseClicked(evt);
                }
            });
            this.linijaWriteMEM = new LineSegment();
            this.lblGlobal.add(this.linijaWriteMEM);
            this.linijaWriteMEM.setBounds(348, 186, 134, 1);
            this.pnlMenu = new JPanel();
            this.pnlMenu.setLayout(null);
            this.pnlMenu.setBounds(0, 0, 792, 155);
            this.pnlMenu.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.pnlMenu.add(this.getPnlStructure());
            this.pnlMenu.add(this.getPnlSimulation());
            this.pnlMenu.add(this.getTabDEcription());
            this.pnlMenu.setPreferredSize(new Dimension(913, 164));
            this.pack();
            this.setSize(900, 850);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lblCPUMouseClicked(MouseEvent evt) {
        this.JumpToCPU();
    }

    private void lblCacheMouseClicked(MouseEvent evt) {
        this.JumpToCache();
    }

    private void lblMEMMouseClicked(MouseEvent evt) {
        this.showMEM();
    }

    public void showMEM() {
        MEM.instance().setReadOnly(true);
        MEM.instance().setVisible(true);
    }

    private void lblCPUMouseEntered(MouseEvent evt) {
    }

    private void lblCacheMouseEntered(MouseEvent evt) {
    }

    private JButton getBtnBack() {
        if (this.btnBack == null) {
            this.btnBack = new JButton();
            this.btnBack.setBounds(183, 45, 75, 26);
            this.btnBack.setText("UP");
            this.btnBack.setMargin(new Insets(1, 1, 1, 4));
            this.btnBack.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnBackMouseClicked(evt);
                }
            });
        }
        return this.btnBack;
    }

    private void btnBackMouseClicked(MouseEvent evt) {
        Navigator.instance().up();
    }

    private void lblCacheMouseExited(MouseEvent evt) {
    }

    private JButton getBtnCLK() {
        if (this.btnCLK == null) {
            this.btnCLK = new JButton();
            this.btnCLK.setText("CLK+");
            this.btnCLK.setBounds(12, 45, 75, 26);
            this.btnCLK.setMargin(new Insets(1, 1, 1, 1));
            this.btnCLK.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnCLKMouseClicked(evt);
                    CacheGlobal.this.refreshStepDescription();
                }
            });
        }
        return this.btnCLK;
    }

    protected void btnCLKMouseClicked(MouseEvent evt) {
        SimObject.instance().getSignals().clock();
        Navigator.instance().getCurrentWindow().refresh();
        this.setTclk();
    }

    private DisplaySignal getSglPAR() {
        if (this.sglPAR == null) {
            this.sglPAR = new DisplaySignal();
            this.sglPAR.setBounds(203, 60, 33, 14);
        }
        return this.sglPAR;
    }

    private DisplaySignal getSglCDRRD() {
        if (this.sglCDRRD == null) {
            this.sglCDRRD = new DisplaySignal();
            this.sglCDRRD.setBounds(203, 106, 25, 12);
        }
        return this.sglCDRRD;
    }

    private DisplaySignal getSglPDRWR() {
        if (this.sglPDRWR == null) {
            this.sglPDRWR = new DisplaySignal();
            this.sglPDRWR.setBounds(204, 148, 25, 16);
        }
        return this.sglPDRWR;
    }

    private DisplaySignal getSglMDRWR() {
        if (this.sglMDRWR == null) {
            this.sglMDRWR = new DisplaySignal();
            this.sglMDRWR.setBounds(443, 105, 24, 17);
        }
        return this.sglMDRWR;
    }

    private DisplaySignal getSglMAR() {
        if (this.sglMAR == null) {
            this.sglMAR = new DisplaySignal();
            this.sglMAR.setBounds(443, 278, 34, 14);
        }
        return this.sglMAR;
    }

    private DisplaySignal getSglMEMDRD() {
        if (this.sglMEMDRD == null) {
            this.sglMEMDRD = new DisplaySignal();
            this.sglMEMDRD.setBounds(443, 361, 26, 14);
        }
        return this.sglMEMDRD;
    }

    @Override
    public void refresh() {
        SignalCache s = SimObject.instance().getSignals();
        this.linijaCRP.setCondition(s.isCRP());
        this.linijaPRQRD.setCondition(s.isPRQRD());
        this.linijaPRQWR.setCondition(s.isPRQWR());
        this.linijaWriteMEM.setCondition(s.isWriteMEM());
        this.sglPAR.setSignal(s.getPAR());
        this.sglCDRRD.setSignal(s.getCDRRD());
        this.sglPDRWR.setSignal(s.getPDRWR());
        this.sglMDRWR.setSignal(s.getMDRWR());
        this.sglMAR.setSignal(s.getMAR());
        this.sglMEMDRD.setSignal(s.getMDRRD());
    }

    private JPanel getPnlStructure() {
        if (this.pnlStructure == null) {
            this.pnlStructure = new JPanel();
            this.pnlStructure.setLayout(null);
            this.pnlStructure.setBounds(546, 1, 350, 162);
            this.pnlStructure.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Struktura", 2, 0, new Font("Tahoma", 1, 11), new Color(0, 0, 0)));
            this.pnlStructure.add(this.getPnlStructureLabels());
            this.pnlStructure.add(this.getPnlStructureSchema());
        }
        return this.pnlStructure;
    }

    private JLabel getLblGenOper() {
        if (this.btnGenOper == null) {
            this.btnGenOper = new JLabel();
            this.btnGenOper.setText("operacije");
            this.btnGenOper.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.btnGenOper.setHorizontalAlignment(0);
            this.btnGenOper.setBackground(new Color(255, 255, 234));
            this.btnGenOper.setOpaque(true);
            this.btnGenOper.setBounds(0, 0, 50, 86);
            this.btnGenOper.setFont(new Font("Tahoma", 1, 10));
            this.btnGenOper.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblGenOperMouseClicked(evt);
                }
            });
        }
        return this.btnGenOper;
    }

    public abstract void JumpToCPU();

    public abstract void JumpToCache();

    public void JumpToCPUControlUnit() {
        this.JumpToCPU();
    }

    public void JumpToCacheControlUnit() {
        this.JumpToCache();
    }

    public void JumpToGenOperUnit() {
        this.JumpToCPU();
    }

    public void JumpToCacheIntUnit() {
        this.JumpToCPU();
    }

    public void JumpToCPUIntUnit() {
        this.JumpToCache();
    }

    public void JumpToCountersUnit() {
        this.JumpToCache();
    }

    public void JumpToIndicators() {
        this.JumpToCache();
    }

    public void JumpToTagMemUnit() {
        this.JumpToCache();
    }

    public void JumpToDataMemUnit() {
        this.JumpToCache();
    }

    public void JumpToMemIntUnit() {
        this.JumpToCache();
    }

    private void lblGenOperMouseClicked(MouseEvent evt) {
        this.JumpToGenOperUnit();
    }

    private JLabel getLblCACHEControlUnit() {
        if (this.lblCACHEControlUnit == null) {
            this.lblCACHEControlUnit = new JLabel();
            this.lblCACHEControlUnit.setText("uprav");
            this.lblCACHEControlUnit.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblCACHEControlUnit.setHorizontalAlignment(0);
            this.lblCACHEControlUnit.setOpaque(true);
            this.lblCACHEControlUnit.setBackground(new Color(196, 225, 225));
            this.lblCACHEControlUnit.setBounds(6, 91, 221, 19);
            this.lblCACHEControlUnit.setFont(new Font("Tahoma", 1, 10));
            this.lblCACHEControlUnit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCACHEControlUnitMouseClicked(evt);
                }
            });
        }
        return this.lblCACHEControlUnit;
    }

    private void lblCACHEControlUnitMouseClicked(MouseEvent evt) {
        this.JumpToCacheControlUnit();
    }

    private JLabel getLblCacheInt() {
        if (this.lblCacheInt == null) {
            this.lblCacheInt = new JLabel();
            this.lblCacheInt.setText("ke\u0161interfejs");
            this.lblCacheInt.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblCacheInt.setHorizontalAlignment(0);
            this.lblCacheInt.setBackground(new Color(255, 255, 234));
            this.lblCacheInt.setOpaque(true);
            this.lblCacheInt.setBounds(51, 0, 63, 86);
            this.lblCacheInt.setFont(new Font("Tahoma", 1, 10));
            this.lblCacheInt.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCacheIntMouseClicked(evt);
                }
            });
        }
        return this.lblCacheInt;
    }

    private JLabel getLblCPUControlUnit() {
        if (this.lblCPUControlUnit == null) {
            this.lblCPUControlUnit = new JLabel();
            this.lblCPUControlUnit.setText("uprav");
            this.lblCPUControlUnit.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblCPUControlUnit.setHorizontalAlignment(0);
            this.lblCPUControlUnit.setOpaque(true);
            this.lblCPUControlUnit.setBackground(new Color(255, 255, 179));
            this.lblCPUControlUnit.setBounds(0, 91, 114, 19);
            this.lblCPUControlUnit.setFont(new Font("Tahoma", 1, 10));
            this.lblCPUControlUnit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCPUControlUnitMouseClicked(evt);
                }
            });
        }
        return this.lblCPUControlUnit;
    }

    private JLabel getLblCPUInt() {
        if (this.lblCPUInt == null) {
            this.lblCPUInt = new JLabel();
            this.lblCPUInt.setText("cpuinterfejs");
            this.lblCPUInt.setHorizontalAlignment(0);
            this.lblCPUInt.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblCPUInt.setBackground(new Color(235, 245, 245));
            this.lblCPUInt.setFont(new Font("Tahoma", 1, 10));
            this.lblCPUInt.setOpaque(true);
            this.lblCPUInt.setBounds(6, 0, 62, 86);
            this.lblCPUInt.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCPUIntMouseClicked(evt);
                }
            });
        }
        return this.lblCPUInt;
    }

    private JLabel getLblIndicators() {
        if (this.lblIndicators == null) {
            this.lblIndicators = new JLabel();
            this.lblIndicators.setText("indikatori");
            this.lblIndicators.setHorizontalAlignment(0);
            this.lblIndicators.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblIndicators.setBackground(new Color(235, 245, 245));
            this.lblIndicators.setOpaque(true);
            this.lblIndicators.setBounds(71, 0, 53, 18);
            this.lblIndicators.setFont(new Font("Tahoma", 1, 10));
            this.lblIndicators.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblIndicatorsMouseClicked(evt);
                }
            });
        }
        return this.lblIndicators;
    }

    private JLabel getLblCounters() {
        if (this.lblCounters == null) {
            this.lblCounters = new JLabel();
            this.lblCounters.setText("broja\u010di");
            this.lblCounters.setHorizontalAlignment(0);
            this.lblCounters.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblCounters.setOpaque(true);
            this.lblCounters.setBackground(new Color(235, 245, 245));
            this.lblCounters.setBounds(71, 17, 53, 18);
            this.lblCounters.setFont(new Font("Tahoma", 1, 10));
            this.lblCounters.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCountersMouseClicked(evt);
                }
            });
        }
        return this.lblCounters;
    }

    private JLabel getLblTAGMem() {
        if (this.lblTAGMem == null) {
            this.lblTAGMem = new JLabel();
            this.lblTAGMem.setText("tagmem");
            this.lblTAGMem.setHorizontalAlignment(0);
            this.lblTAGMem.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblTAGMem.setBackground(new Color(235, 245, 245));
            this.lblTAGMem.setOpaque(true);
            this.lblTAGMem.setBounds(71, 34, 53, 18);
            this.lblTAGMem.setFont(new Font("Tahoma", 1, 10));
            this.lblTAGMem.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblTAGMemMouseClicked(evt);
                }
            });
        }
        return this.lblTAGMem;
    }

    private JPanel getPnlCPUStructure() {
        if (this.pnlCPUStructure == null) {
            this.pnlCPUStructure = new JPanel();
            this.pnlCPUStructure.setLayout(null);
            this.pnlCPUStructure.setBounds(0, 0, 114, 113);
            this.pnlCPUStructure.add(this.getLblGenOper());
            this.pnlCPUStructure.add(this.getLblCacheInt());
            this.pnlCPUStructure.add(this.getLblCPUControlUnit());
        }
        return this.pnlCPUStructure;
    }

    private JPanel getPnlCacheStructure() {
        if (this.pnlCacheStructure == null) {
            this.pnlCacheStructure = new JPanel();
            this.pnlCacheStructure.setLayout(null);
            this.pnlCacheStructure.setBounds(113, 0, 227, 115);
            this.pnlCacheStructure.add(this.getLblMEMStructure());
            this.pnlCacheStructure.add(this.getLblCPUInt());
            this.pnlCacheStructure.add(this.getLblIndicators());
            this.pnlCacheStructure.add(this.getLblCounters());
            this.pnlCacheStructure.add(this.getLblTAGMem());
            this.pnlCacheStructure.add(this.getLblDATAMem());
            this.pnlCacheStructure.add(this.getLblMemInt());
            this.pnlCacheStructure.add(this.getLblCACHEControlUnit());
        }
        return this.pnlCacheStructure;
    }

    private JLabel getLblDATAMem() {
        if (this.lblDATAMem == null) {
            this.lblDATAMem = new JLabel();
            this.lblDATAMem.setText("datamem");
            this.lblDATAMem.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblDATAMem.setHorizontalAlignment(0);
            this.lblDATAMem.setOpaque(true);
            this.lblDATAMem.setBackground(new Color(235, 245, 245));
            this.lblDATAMem.setBounds(71, 51, 53, 18);
            this.lblDATAMem.setFont(new Font("Tahoma", 1, 10));
            this.lblDATAMem.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblDATAMemMouseClicked(evt);
                }
            });
        }
        return this.lblDATAMem;
    }

    private JLabel getLblMemInt() {
        if (this.lblMemInt == null) {
            this.lblMemInt = new JLabel();
            this.lblMemInt.setText("meminterfejs");
            this.lblMemInt.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblMemInt.setHorizontalAlignment(0);
            this.lblMemInt.setOpaque(true);
            this.lblMemInt.setBackground(new Color(235, 245, 245));
            this.lblMemInt.setBounds(127, 0, 69, 86);
            this.lblMemInt.setFont(new Font("Tahoma", 1, 10));
            this.lblMemInt.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblMemIntMouseClicked(evt);
                }
            });
        }
        return this.lblMemInt;
    }

    private JLabel getLblMEMStructure() {
        if (this.lblMEMStructure == null) {
            this.lblMEMStructure = new JLabel();
            this.lblMEMStructure.setText("MEM");
            this.lblMEMStructure.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.lblMEMStructure.setHorizontalAlignment(0);
            this.lblMEMStructure.setOpaque(true);
            this.lblMEMStructure.setBackground(new Color(255, 232, 243));
            this.lblMEMStructure.setBounds(199, 0, 28, 88);
            this.lblMEMStructure.setFont(new Font("Tahoma", 1, 10));
            this.lblMEMStructure.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblMEMStructureMouseClicked(evt);
                }
            });
        }
        return this.lblMEMStructure;
    }

    private void lblCPUControlUnitMouseClicked(MouseEvent evt) {
        this.JumpToCPUControlUnit();
    }

    private void lblCacheIntMouseClicked(MouseEvent evt) {
        this.JumpToCacheIntUnit();
    }

    private void lblCPUIntMouseClicked(MouseEvent evt) {
        this.JumpToCPUIntUnit();
    }

    private void lblIndicatorsMouseClicked(MouseEvent evt) {
        this.JumpToIndicators();
    }

    private void lblCountersMouseClicked(MouseEvent evt) {
        this.JumpToCountersUnit();
    }

    private void lblTAGMemMouseClicked(MouseEvent evt) {
        this.JumpToTagMemUnit();
    }

    private void lblDATAMemMouseClicked(MouseEvent evt) {
        this.JumpToDataMemUnit();
    }

    private void lblMemIntMouseClicked(MouseEvent evt) {
        this.JumpToMemIntUnit();
    }

    private void lblMEMStructureMouseClicked(MouseEvent evt) {
        this.showMEM();
    }

    private JPanel getPnlStructureLabels() {
        if (this.pnlStructureLabels == null) {
            this.pnlStructureLabels = new JPanel();
            FlowLayout pnlStructureLabelsLayout = new FlowLayout();
            pnlStructureLabelsLayout.setVgap(0);
            pnlStructureLabelsLayout.setAlignment(0);
            pnlStructureLabelsLayout.setHgap(0);
            this.pnlStructureLabels.setLayout(pnlStructureLabelsLayout);
            this.pnlStructureLabels.setBounds(5, 19, 340, 18);
            this.pnlStructureLabels.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
            this.pnlStructureLabels.add(this.getLblCPUStructure());
            this.pnlStructureLabels.add(this.getLblCacheStructure());
            this.pnlStructureLabels.add(this.getLblMEMTitle());
        }
        return this.pnlStructureLabels;
    }

    private JPanel getPnlStructureSchema() {
        if (this.pnlStructureSchema == null) {
            this.pnlStructureSchema = new JPanel();
            this.pnlStructureSchema.setLayout(null);
            this.pnlStructureSchema.setBounds(5, 44, 340, 113);
            this.pnlStructureSchema.add(this.getPnlCPUStructure());
            this.pnlStructureSchema.add(this.getPnlCacheStructure());
        }
        return this.pnlStructureSchema;
    }

    private JLabel getLblCPUStructure() {
        if (this.lblCPUStructure == null) {
            this.lblCPUStructure = new JLabel();
            this.lblCPUStructure.setText("CPU");
            this.lblCPUStructure.setPreferredSize(new Dimension(116, 14));
            this.lblCPUStructure.setHorizontalAlignment(0);
            this.lblCPUStructure.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, new Color(0, 0, 0)));
            this.lblCPUStructure.setOpaque(true);
            this.lblCPUStructure.setBackground(new Color(255, 255, 179));
            this.lblCPUStructure.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCPUMouseClicked(evt);
                }
            });
        }
        return this.lblCPUStructure;
    }

    private JLabel getLblCacheStructure() {
        if (this.lblCacheStructure == null) {
            this.lblCacheStructure = new JLabel();
            this.lblCacheStructure.setText("KE\u0160");
            this.lblCacheStructure.setPreferredSize(new Dimension(193, 14));
            this.lblCacheStructure.setHorizontalAlignment(0);
            this.lblCacheStructure.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, new Color(0, 0, 0)));
            this.lblCacheStructure.setBackground(new Color(196, 225, 225));
            this.lblCacheStructure.setOpaque(true);
            this.lblCacheStructure.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.lblCacheMouseClicked(evt);
                }
            });
        }
        return this.lblCacheStructure;
    }

    private JLabel getLblMEMTitle() {
        if (this.lblMEMTitle == null) {
            this.lblMEMTitle = new JLabel();
            this.lblMEMTitle.setText("MEM");
            this.lblMEMTitle.setHorizontalAlignment(0);
            this.lblMEMTitle.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, new Color(0, 0, 0)));
            this.lblMEMTitle.setOpaque(true);
            this.lblMEMTitle.setBackground(new Color(255, 217, 217));
            this.lblMEMTitle.setPreferredSize(new Dimension(29, 16));
        }
        return this.lblMEMTitle;
    }

    private JPanel getPnlSimulation() {
        if (this.pnlSimulation == null) {
            this.pnlSimulation = new JPanel();
            this.pnlSimulation.setBounds(278, 1, 267, 162);
            this.pnlSimulation.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Simulacija", 2, 0, new Font("Tahoma", 1, 11), new Color(0, 0, 0)));
            this.pnlSimulation.setLayout(null);
            this.pnlSimulation.add(this.getBtnCLK());
            this.pnlSimulation.add(this.getBtnOper());
            this.pnlSimulation.add(this.getBtnBack());
            this.pnlSimulation.add(this.getBtnRegisters());
            this.pnlSimulation.add(this.getBtnTAB());
            this.pnlSimulation.add(this.getBtnTAG());
            this.pnlSimulation.add(this.getBtnDATA());
            this.pnlSimulation.add(this.getBtnInit());
            this.pnlSimulation.add(this.getBtnReset());
            this.pnlSimulation.add(this.getBtnSave());
            this.pnlSimulation.add(this.getBtnLoad());
            this.pnlSimulation.add(this.getBtnProg());
            this.pnlSimulation.add(this.getLblTclk());
            this.pnlSimulation.add(this.getTxtTclk());
        }
        return this.pnlSimulation;
    }

    private JButton getBtnOper() {
        if (this.btnOper == null) {
            this.btnOper = new JButton();
            this.btnOper.setBounds(12, 73, 75, 27);
            this.btnOper.setText("OPR+");
            this.btnOper.setMargin(new Insets(1, 1, 1, 1));
            this.btnOper.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnOperMouseClicked(evt);
                    CacheGlobal.this.refreshStepDescription();
                }
            });
        }
        return this.btnOper;
    }

    private JTabbedPane getTabDEcription() {
        if (this.tabDEcription == null) {
            this.tabDEcription = new JTabbedPane();
            this.tabDEcription.setBounds(8, 1, 270, 162);
            this.tabDEcription.addTab("CPU ", this.getPnlCPUInfo());
            this.tabDEcription.addTab("KE\u0160", this.getPnlCacheInfo());
        }
        return this.tabDEcription;
    }

    private Component convertJEditor2JPane(JEditorPane editor) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setSize(new Dimension(300, 130));
        panel.add((Component)editor, "Center");
        JScrollPane editorScrollPane = new JScrollPane(panel);
        editorScrollPane.setSize(new Dimension(263, 135));
        JPanel result = new JPanel(new BorderLayout());
        result.setSize(new Dimension(265, 135));
        result.add((Component)editorScrollPane, "Center");
        return editorScrollPane;
    }

    private JPanel getPnlCPUInfo() {
        if (this.pnlCPUInfo == null) {
            this.pnlCPUInfo = new JPanel();
            this.pnlCPUInfo.setLayout(null);
            this.pnlCPUInfo.add(this.convertJEditor2JPane(this.getTxtCPUInfo()));
        }
        return this.pnlCPUInfo;
    }

    private JPanel getPnlCacheInfo() {
        if (this.pnlCacheInfo == null) {
            this.pnlCacheInfo = new JPanel();
            this.pnlCacheInfo.setLayout(null);
            this.pnlCacheInfo.add(this.convertJEditor2JPane(this.getTxtCacheInfo()));
        }
        return this.pnlCacheInfo;
    }

    private JEditorPane getTxtCPUInfo() {
        if (this.txtCPUInfo == null) {
            this.txtCPUInfo = new JEditorPane();
            this.txtCPUInfo.setContentType("text/html");
            this.txtCPUInfo.setBounds(6, 6, 254, 130);
            this.txtCPUInfo.setEditable(false);
        }
        return this.txtCPUInfo;
    }

    private JEditorPane getTxtCacheInfo() {
        if (this.txtCacheInfo == null) {
            this.txtCacheInfo = new JEditorPane();
            this.txtCacheInfo.setContentType("text/html");
            this.txtCacheInfo.setBounds(6, 6, 254, 130);
            this.txtCacheInfo.setEditable(false);
        }
        return this.txtCacheInfo;
    }

    private JButton getBtnRegisters() {
        if (this.btnRegisters == null) {
            this.btnRegisters = new JButton();
            this.btnRegisters.setText("REG");
            this.btnRegisters.setBounds(97, 45, 75, 26);
            this.btnRegisters.setMargin(new Insets(1, 1, 1, 1));
            this.btnRegisters.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnRegistersMouseClicked(evt);
                }
            });
        }
        return this.btnRegisters;
    }

    protected abstract void btnRegistersMouseClicked(MouseEvent var1);

    private JButton getBtnTAB() {
        if (this.btnTAB == null) {
            this.btnTAB = new JButton();
            this.btnTAB.setText("TAB");
            this.btnTAB.setBounds(98, 74, 73, 26);
            this.btnTAB.setSize(75, 26);
            this.btnTAB.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    SimObject.instance().getMainFrame().showTAB();
                }
            });
        }
        return this.btnTAB;
    }

    private JButton getBtnTAG() {
        if (this.btnTAG == null) {
            this.btnTAG = new JButton();
            this.btnTAG.setText("TAG");
            this.btnTAG.setBounds(98, 102, 74, 25);
            this.btnTAG.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.showTAG();
                }
            });
        }
        return this.btnTAG;
    }

    private JButton getBtnDATA() {
        if (this.btnDATA == null) {
            this.btnDATA = new JButton();
            this.btnDATA.setText("DATA");
            this.btnDATA.setBounds(98, 129, 74, 27);
            this.btnDATA.setSize(74, 26);
            this.btnDATA.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.showDATA();
                }
            });
        }
        return this.btnDATA;
    }

    protected abstract void showDATA();

    protected abstract void showTAG();

    private JButton getBtnInit() {
        if (this.btnInit == null) {
            this.btnInit = new JButton();
            this.btnInit.setText("INIT");
            this.btnInit.setBounds(183, 129, 75, 26);
            this.btnInit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnInitMouseClicked(evt);
                }
            });
        }
        return this.btnInit;
    }

    private JButton getBtnReset() {
        if (this.btnReset == null) {
            this.btnReset = new JButton();
            this.btnReset.setText("RESET");
            this.btnReset.setBounds(12, 129, 75, 28);
            this.btnReset.setSize(75, 26);
            this.btnReset.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.reset();
                }
            });
        }
        return this.btnReset;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText("SAVE");
            this.btnSave.setBounds(183, 72, 75, 25);
            this.btnSave.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnSaveMouseClicked(evt);
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnLoad() {
        if (this.btnLoad == null) {
            this.btnLoad = new JButton();
            this.btnLoad.setText("LOAD");
            this.btnLoad.setBounds(183, 98, 75, 26);
            this.btnLoad.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnLoadMouseClicked(evt);
                }
            });
        }
        return this.btnLoad;
    }

    private JButton getBtnProg() {
        if (this.btnProg == null) {
            this.btnProg = new JButton();
            this.btnProg.setText("PRG+");
            this.btnProg.setBounds(12, 102, 75, 25);
            this.btnProg.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    CacheGlobal.this.btnProgMouseClicked(evt);
                    CacheGlobal.this.refreshStepDescription();
                }
            });
        }
        return this.btnProg;
    }

    private void btnOperMouseClicked(MouseEvent evt) {
        SignalCache s = SimObject.instance().getSignals();
        int nextEntry = s.getCurrentEntry() + 1;
        while (s.getCurrentEntry() < nextEntry && s.isTV() && nextEntry < 32) {
            this.btnCLKMouseClicked(evt);
        }
    }

    private void btnProgMouseClicked(MouseEvent evt) {
        SignalCache s = SimObject.instance().getSignals();
        while (s.isTV() || Utility.BoolToDec(s.getCACHECNT()) != 0) {
            s.clock();
        }
        this.btnCLKMouseClicked(evt);
    }

    protected abstract void reset();

    private void btnSaveMouseClicked(MouseEvent evt) {
        try {
            FileOutputStream fileOut = new FileOutputStream("SimObject.sim");
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(SimObject.instance().getSignals());
            out.close();
            fileOut.close();
            JOptionPane.showMessageDialog(this, "Snimanje simulacije je zavrseno.", "Snimanje", 1);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void btnLoadMouseClicked(MouseEvent evt) {
        try {
            FileInputStream fileIn = new FileInputStream("SimObject.sim");
            ObjectInputStream in = new ObjectInputStream(fileIn);
            SimObject.instance().setSignals((SignalCache)in.readObject());
            in.close();
            fileIn.close();
            JOptionPane.showMessageDialog(this, "Ucitavanje simulacije je zavrseno.", "Ucitavanje", 1);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void btnInitMouseClicked(MouseEvent evt) {
        MainJApplet main = SimObject.instance().getMainFrame();
        CardLayout cl = (CardLayout)main.getMainPanel().getLayout();
        if (cl != null) {
            cl.first(main.getMainPanel());
        }
        main.setCurrentState(0);
        main.setVisible(true);
        SimObject.instance().getSignals().setMEM(new boolean[(int)Math.pow(2.0, 16.0)][8]);
        this.setVisible(false);
    }

    protected void refreshStepDescription() {
        SignalCache s = SimObject.instance().getSignals();
        int cacheStep = Utility.BoolToDec(s.getCACHECNT());
        int cpuStep = Utility.BoolToDec(s.getCPUCNT());
        this.txtCacheInfo.setText(s.getCacheDesc().getStep(cacheStep));
        this.txtCPUInfo.setText(s.getCpuDesc().getStep(cpuStep));
    }

    protected void setTclk() {
        SignalCache s = SimObject.instance().getSignals();
        this.txtTclk.setText(Integer.toString(s.getTclk()));
    }

    private JLabel getLblTclk() {
        if (this.lblTclk == null) {
            this.lblTclk = new JLabel();
            this.lblTclk.setText("Tclk");
            this.lblTclk.setBounds(17, 19, 47, 14);
        }
        return this.lblTclk;
    }

    private JTextField getTxtTclk() {
        if (this.txtTclk == null) {
            this.txtTclk = new JTextField();
            this.txtTclk.setText("0");
            this.txtTclk.setBounds(51, 16, 35, 21);
            this.txtTclk.setEditable(false);
            this.txtTclk.setHorizontalAlignment(11);
        }
        return this.txtTclk;
    }
}

