<?
	session_start();

	require_once 'aspects.php';

	require_once 'todo.php';

	/* load settings */
	require_once 'config.php';

	/* load external functions for setting up new game */
	require 'chessutils.php';
	require 'chessconstants.php';
	require 'newgame.php';
	require 'chessdb.php';
	
	/* allow WebChess to be run on PHP systems < 4.1.0, using old http vars */
	fixOldPHPVersions();

	/* if this page is accessed directly (ie: without going through login), */
	/* player is logged off by default */
	if (!isset($_SESSION['playerID']))
		$_SESSION['playerID'] = -1;
	
	ToDo::CleanUpOldGames();
	
	$tmpNewUser = false;
	$errMsg = "";
	switch($_POST['ToDo'])
	{
		case 'NewUser':
			Todo::NewUser();
			/* no break, login user */
			
		case 'Login':
			ToDo::Login();
			break;

		case 'Logout':
			ToDo::Logout();
			break;

		case 'InvitePlayer':
			ToDo::InvitePlayer();
			break;

		case 'ResponseToInvite':
			ToDo::ResponseToInvite();
			break;

		case 'WithdrawRequest':
			ToDo::WithdrawRequest();
			break;

		case 'UpdatePersonalInfo':
			ToDo::UpdatePersonalInfo();
			break;
		
		case 'UpdatePrefs':
			ToDo::UpdatePrefs();
			break;

		case 'TestEmail':
			ToDo::TestEmail();
			break;
	}

	/* set default playing mode to different PCs (as opposed to both players sharing a PC) */
	$_SESSION['isSharedPC'] = false;

	require 'htmlprintmenu.php';
	HTMLPrintMenu();



?>
