extensions [nw]
turtles-own
[
  ;; this is used to mark turtles we have already visited
  explored?
]

globals
[
  component-size          ;; number of turtles explored so far in the current component
  giant-component-size    ;; number of turtles in the giant component
  giant-start-node        ;; node from where we started exploring the giant component
  asp                     ;; average shortest path
]

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  set-default-shape turtles "circle"
  make-turtles
  set asp false
  reset-ticks
end

to make-turtles
  crt num-nodes
  layout-circle turtles max-pxcor - 1
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Network wiring procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to all-random
  setup
  let thiswho 0
  set asp false

  if (not any? turtles) [make-turtles]

  ask links [
    die
  ]

  ask turtles [
    set shape "circle"
    set size 3
  ]

  ifelse prob-or-num? [
   ask turtles [
     set thiswho who
     ask other turtles with [who > thiswho] [
       if (random-float 1 < prob-link) [
         create-link-with myself
       ]
     ]
   ]
  ] [
   repeat (floor (num-neighbors * num-nodes / 2)) [
     ask one-of turtles [
       ask one-of other turtles with [not link-neighbor? myself] [
         create-link-with myself
       ]
     ]
   ]
  ]

  find-all-components
  color-giant-component
  set-current-plot "degree distribution"
  set-plot-x-range 0 (max [count link-neighbors] of turtles)
;  set asp network:mean-link-path-length (turtles with [color = red]) links
  tick
end

to introduction
  setup
  let friend nobody
  let thiswho 0
  let num-links-want 0
  set asp false

  if not any? turtles [make-turtles]

  ask links [
    die
  ]

  ask turtles [
    set shape "face happy"
    set size 3
    set color pink
  ]

  ifelse prob-or-num? [
    set num-links-want prob-link * ((count turtles) * (count turtles - 1) / 2)
  ][
    set num-links-want (floor (num-nodes * num-neighbors / 2))
  ]

  let num-have 0
  while [num-have < num-links-want] [
    ask one-of turtles [
      set friend self
      set thiswho who
      ifelse ((random-float 1.0 < prob-intro) and (any? link-neighbors))[
        ask one-of link-neighbors [
          if any? link-neighbors with [who != thiswho] [
            ask one-of link-neighbors with [who != thiswho] [
              if not link-neighbor? friend [
                create-link-with friend
                set num-have (num-have + 1)
              ]
            ]
          ]
        ]
      ]
      [
        ask one-of other turtles with [not link-neighbor? self] [
          create-link-with friend
          set num-have (num-have + 1)
        ]
      ]
    ]
  ]

  find-all-components
  color-giant-component
  set-current-plot "degree distribution"
  set-plot-x-range 0 (max [count link-neighbors] of turtles)
;  set asp network:mean-link-path-length (turtles with [color = red]) links
  tick
end

to static-geo
  setup
  let thiswho 0
  set asp false

  if not any? turtles [make-turtles]

  ask links [
    die
  ]

  ask turtles [
    set shape "house"
    set color white
    set xcor random-xcor
    set ycor random-ycor
    set size 5
  ]

  ask turtles [
    set thiswho who
    ask min-n-of num-neighbors other turtles [distance myself] [
      if not (link-neighbor? myself) [
        create-link-with myself
      ]
    ]
  ]
  find-all-components
  color-giant-component
  set-current-plot "degree distribution"
  set-plot-x-range 0 (max [count link-neighbors] of turtles)
 ; set asp network:mean-link-path-length (turtles with [color = red]) links
  tick
end

to growth
  ca
  reset-ticks

  crt (num-neighbors + 1) [
    set shape "person"
    set size 5
  ]

  ask turtles [
    ask other turtles with [not link-neighbor? myself] [
      create-link-with myself
    ]
    repeat 3 [do-layout]
  ]

  repeat (num-nodes - num-neighbors - 1) [
    crt 1 [
          set shape "person"
          set size 5
          set xcor random-xcor
          set ycor random-ycor
          repeat 50 [do-layout]
    ]
    ask n-of (floor (num-neighbors / 2)) turtles [
        create-link-with one-of other turtles with [not link-neighbor? self]
    ]
    if (random-float 1 < (num-neighbors / 2 - floor (num-neighbors / 2))) [
        ask one-of turtles [
          create-link-with one-of other turtles with [not link-neighbor? self]
        ]
    ]
  ]

  repeat 500 [do-layout]
  find-all-components
  color-giant-component
  set-current-plot "degree distribution"
  set-plot-x-range 0 (max [count link-neighbors] of turtles)
  tick
;  set asp network:mean-link-path-length (turtles with [color = red]) links
end

to rand-encounter
  setup
  let thiswho 0

  if not any? turtles [make-turtles]
  ask links [
    die
  ]

  ask turtles [
    set shape "person"
    set size 5
    set xcor random-xcor
    set ycor random-ycor
    set color (gray + 2)
  ]

  let links-wanted num-nodes * num-neighbors / 2

  while [(count links) < links-wanted] [
    ask turtles [
      rt random 360
      forward 1
      ask other turtles-on patch-here [
        if not link-neighbor? myself [
          create-link-with myself
        ]
      ]
    ]
  ]
  find-all-components
  color-giant-component
  set-current-plot "degree distribution"
  set-plot-x-range 0 (max [count link-neighbors] of turtles)
;  set asp network:mean-link-path-length (turtles with [color = red]) links
  tick
end

to calc-asp
  nw:set-context (turtles with [color = red]) links
  set asp nw:mean-path-length
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Network Exploration ;;;
;;; code by Uri Wilensky ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; to find all the connected components in the network, their sizes and starting turtles
to find-all-components
  set giant-component-size 0
  ask turtles [ set explored? false ]
  ;; keep exploring till all turtles get explored
  loop
  [
    ;; pick a node that has not yet been explored
    let start one-of turtles with [ not explored? ]
    if start = nobody [ stop ]
    ;; reset the number of turtles found to 0
    ;; this variable is updated each time we explore an
    ;; unexplored node.
    set component-size 0
    ;; at this stage, we recolor everything to light gray
    ask start [ explore (gray + 2) ]
    ;; the explore procedure updates the component-size variable.
    ;; so check, have we found a new giant component?
    if component-size > giant-component-size
    [
      set giant-component-size component-size
      set giant-start-node start
    ]
  ]
end

;; Finds all turtles reachable from this node (and recolors them)
to explore [new-color]  ;; node procedure
  if explored? [ stop ]
  set explored? true
  set component-size component-size + 1
  ;; color the node
  set color new-color
  ask link-neighbors [ explore new-color ]
end

;; color the giant component red
to color-giant-component
  ask turtles [ set explored? false ]
  ask giant-start-node [ explore red ]
  ask links [ set color [color] of end1 ]  ;; recolor all edges
end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Edge Operations ;;;
;;;;;;;;;;;;;;;;;;;;;;;

;; pick a random missing edge and create it
to add-edge
  let node1 one-of turtles
  let node2 one-of turtles
  ask node1 [
    ifelse link-neighbor? node2 or node1 = node2
    ;; if there's already an edge there, then go back
    ;; and pick new turtles
    [ add-edge ]
    ;; else, go ahead and make it
    [ create-link-with node2 ]
  ]

end

;;;;;;;;;;;;;;
;;; Layout ;;;
;;;;;;;;;;;;;;
to layout
  ;; the number 10 here is arbitrary; more repetitions slows down the
  ;; model, but too few gives poor layouts
  repeat 10 [
    do-layout
    display  ;; so we get smooth animation
  ]
end

to do-layout
  layout-spring (turtles with [any? link-neighbors]) links spring-constant spring-length repulsion-strength
end


; Original Copyright 2005 Uri Wilensky.
; Modified by Lada Adamic
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
328
10
716
399
-1
-1
4.18
1
10
1
1
1
0
0
0
1
-45
45
-45
45
0
0
1
ticks
30.0

BUTTON
7
345
109
378
redo layout
do-layout
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
2
12
158
45
num-nodes
num-nodes
0
100
50.0
1
1
NIL
HORIZONTAL

BUTTON
3
141
111
174
Erdos-Renyi
all-random
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
123
142
295
175
prob-link
prob-link
0
0.2
0.08
0.01
1
NIL
HORIZONTAL

BUTTON
2
224
113
257
NIL
static-geo
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
124
253
296
286
num-neighbors
num-neighbors
0
5
1.0
1
1
NIL
HORIZONTAL

BUTTON
2
294
113
327
NIL
growth
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
124
360
296
393
spring-constant
spring-constant
0
2
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
124
325
296
358
spring-length
spring-length
0
20
7.0
1
1
NIL
HORIZONTAL

SLIDER
124
395
296
428
repulsion-strength
repulsion-strength
0
5
2.8
0.2
1
NIL
HORIZONTAL

BUTTON
3
258
111
291
NIL
rand-encounter\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
3
178
112
211
NIL
introduction
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
123
178
295
211
prob-intro
prob-intro
0
1
0.83
0.01
1
NIL
HORIZONTAL

TEXTBOX
126
306
276
324
layout options
11
0.0
1

MONITOR
4
89
55
134
GC size
giant-component-size
0
1
11

MONITOR
56
89
110
134
av. deg
2 * (count links) / (count turtles)
2
1
11

SWITCH
3
48
158
81
prob-or-num?
prob-or-num?
0
1
-1000

PLOT
166
10
326
137
degree distribution
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [count link-neighbors] of turtles"

MONITOR
110
89
167
134
ASP
asp
1
1
11

BUTTON
7
385
119
418
calculate ASP
calc-asp
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

You can generate networks using several different models, starting with the Erdös-Renyi (the "randomest") network model, and a few variations that might represent 
e.g. meeting people through your friends (INTRODUCTION model), linking houses or cities with roads (STATIC GEO model), literally running into people and becoming friends (RAND ENCOUNTER model), and adding new nodes to the network (GROWTH). 

## HOW IT WORKS

All except for the GROWTH model start with a fixed number of nodes (detemined by the NUM-NODES). Then edges are added, but just how depends on the model you choose.

## HOW TO USE IT

The NUM-NODES

Click on LAYOUT to use a spring layout algorithm to reposition the nodes (you will typically want to keep this off while applying the network construction algorithms).

With the NUM-NODES slider you determine the number of nodes in the network.

The GC SIZE monitor box updates with the size of the largest component.

The AV. DEG monitor box reports on the average degree in the network.

The ASP monitor reports on the average shortest path between nodes in the largest connected component only.

The following are the network construction algorithms:

ERDÖS-RENYI constructs a random graph by adding an edge between each pair of nodes with probability PROB-LINK.

INTRODUCTION similar to ERDÖS-RENYI, however, random edges are added only with probability (1 - PROB-INTRO). The rest of the time the nodes try to get one of their friends to introduce them to someone they know. 

STATIC-GEO randomly places nodes on a 2-D square area. Keep Layout? OFF so that node positions don't change while network is being built. Each node tries to connect to its NUM-NEIGHBORS closest neighbors. This means that some nodes end up with more neighbors, because they are the closest choice to some other node even though they already have plenty of closer neighbors.

RAND-ENCOUNTER places nodes randomly on a 2D square area. Keep Layout? OFF so that nodes are moving independently of the links they have (you don't want them tied down to their friends :) ).They move around randomly until they occupy the same "patch" as another node, at which point they connect. 

GROWTH starts out with (NUM-NEIGHBORS + 1) nodes forming a fully connected clique. After this, nodes are added one by one. As nodes are added NUM-NEIGHBORS / 2 edges are added as well (with some randomness so that one ends up with approximately the correct average degree for the entire graph when NUM-NEIGHBORS is odd.

REDO LAYOUT will repeatedly apply a spring-layout algorithm to the network. In the long run this can make your computer run hot, so remember to switch it off if you have NetLogo running and are not actively using it. There are also several parameters that you can adjust so that sparse networks get pulled together more tightly, but dense networks are spread out.

## THINGS TO NOTICE

Try looking at how evenly the edges are distributed among the nodes in the different models. Are some nodes better connected than others? How does this come about.

How many closed traids do you see in each network? Which models promote closed triads and in which are they rare? Can you explain why?

Observe differences in the size of the giant connected component for the ER graph and one of the other models using the same average number of neighbors or probability of linking.

## THINGS TO TRY

Try varying the density of the network. How is the size of the giant component affected? Is the transition gradual or sudden as a function of the network density?

In the INTRODUCTION model, try varying the probability of introductions as opposed to random encounters. How does this affect the eveneness of the degree distribution and the number of closed triads formed?

## COPYRIGHT AND LICENSE

This model was adapted by Lada Adamic from Uri Wilensky's Giant Component model in NetLogo's models library http://ccl.northwestern.edu/netlogo/models/GiantComponent.

![CC BY-NC-SA 3.0](http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.2
@#$#@#$#@
set layout? false
setup repeat 175 [ go ]
repeat 35 [ layout ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
