#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdint.h>
// #pragma pack(1)

typedef struct {
    double x, y, z;
    long r, g, b;
    char active;
} Point;

void array_of_structs ( char *input_file_path, int iterations ) {
    FILE *input_file = fopen ( input_file_path, "r" );
    if ( input_file == NULL ) {
        exit ( 1 );
    }
    
    int length = 0;
    fscanf ( input_file, "%d", &length );
    
    Point *points = malloc ( length * sizeof ( Point ) );
    
    if ( points == NULL ) {
        exit ( 1 );
    }
    
    for ( int i = 0; i < length; ++i ) {
        fscanf (
            input_file,
            "%lf %lf %lf %ld %ld %ld %c",
            &points[i].x,
            &points[i].y,
            &points[i].z,
            &points[i].r,
            &points[i].g,
            &points[i].b,
            &points[i].active
        );
    }
    
    fclose ( input_file );
    
    // calculate center
    clock_t start = clock ( );
   
    Point center = { 0 };
    for ( int iteration = 0; iteration < iterations; ++iteration ) {
        center.x = 0;
        center.y = 0;
        center.z = 0;
        
        for ( int i = 0; i < length; ++i ) {
            center.x += points[i].x;
            center.y += points[i].y;
            center.z += points[i].z;
        }
    }
    
    center.x /= length;
    center.y /= length;
    center.z /= length;
    
    clock_t end = clock ( );
    
    double elapsed_in_ms = ( end - start ) * 1. / CLOCKS_PER_SEC * 1000;
    
    printf ( "CENTRE = { %lf, %lf, %lf }\n", center.x, center.y, center.z );
    printf ( "ELAPSED (ms) = %lf\n", elapsed_in_ms );
    
    free ( points );
}

typedef struct {
    double *x, *y, *z;
    long *r, *g, *b;
    char *active;
} Points;

unsigned int get_cache_line_size ( int id ) {
    uint32_t eax = 4;
    uint32_t ebx;
    uint32_t ecx = id;
    uint32_t edx;
    
    __asm__ (
        "cpuid":
        "+a" (eax),
        "=b" (ebx),
        "+c" (ecx),
        "=d" (edx)
        );
    
    int cache_type = eax & 0x1F;
    
    if ( cache_type == 0 ) {
        return -1;
    }
    
    return ( ebx & 0xFFF ) + 1;
}

void* aligned_malloc ( size_t size, unsigned int alignment ) {
    void *memory_block = malloc ( size + alignment + sizeof ( size_t ) );
    
    if ( memory_block == NULL ) {
        return NULL;
    }
    
    size_t address = ( size_t ) memory_block + alignment + sizeof ( size_t );
    
    void * result = ( void* ) ( address - ( address % alignment ) );
    
    *( ( size_t* ) result - 1 ) = ( size_t ) memory_block;
    
    return result;
}

void aligned_free ( void *pointer ) {
    void *memory_block = ( void* )( *( ( size_t* )pointer - 1 ) );
    free ( memory_block );
}

void struct_of_arrays ( char *input_file_path, int iterations ) {
    FILE *input_file = fopen ( input_file_path, "r" );
    if ( input_file == NULL ) {
        exit ( 1 );
    }
    
    int length = 0;
    fscanf ( input_file, "%d", &length );
    
    Points points = { NULL, NULL, NULL, NULL, NULL, NULL, NULL };
    
    unsigned int cache_line_size = get_cache_line_size ( 0 );
    
    points.x      = aligned_malloc ( length * sizeof ( double ), cache_line_size );
    points.y      = aligned_malloc ( length * sizeof ( double ), cache_line_size );
    points.z      = aligned_malloc ( length * sizeof ( double ), cache_line_size );
    points.r      = aligned_malloc ( length * sizeof ( long ), cache_line_size );
    points.g      = aligned_malloc ( length * sizeof ( long ), cache_line_size );
    points.b      = aligned_malloc ( length * sizeof ( long ), cache_line_size );
    points.active = aligned_malloc ( length * sizeof ( char ), cache_line_size );
    
    if ( points.x == NULL || points.y == NULL || points.z == NULL || points.z == NULL || points.r == NULL || points.g == NULL || points.b == NULL ) {
        exit ( 1 );
    }
    
    for ( int i = 0; i < length; ++i ) {
        fscanf (
            input_file,
            "%lf %lf %lf %ld %ld %ld %c",
            &points.x[i],
            &points.y[i],
            &points.z[i],
            &points.r[i],
            &points.g[i],
            &points.b[i],
            &points.active[i]
        );
    }
    
    fclose ( input_file );
    
    // calculate center
    clock_t start = clock ( );
    
    Point center = { 0 };
    for ( int iteration = 0; iteration < iterations; ++iteration ) {
        center.x = 0;
        center.y = 0;
        center.z = 0;
        
        for ( int i = 0; i < length; ++i ) {
            center.x += points.x[i];
            center.y += points.y[i];
            center.z += points.z[i];
        }
    }
    
    center.x /= length;
    center.y /= length;
    center.z /= length;
    
    clock_t end = clock ( );
    
    double elapsed_in_ms = ( end - start ) * 1. / CLOCKS_PER_SEC * 1000;
    
    printf ( "CENTRE = { %lf, %lf, %lf }\n", center.x, center.y, center.z );
    printf ( "ELAPSED (ms) = %lf\n", elapsed_in_ms );
    
    aligned_free ( points.x );
    aligned_free ( points.y );
    aligned_free ( points.z );
    aligned_free ( points.r );
    aligned_free ( points.g );
    aligned_free ( points.b );
    aligned_free ( points.active );
}


int main ( int argc, char **argv ) {
    int type       = atoi ( argv[1] );
    int iterations = atoi ( argv[2] );
    
    switch ( type ) {
        case 0: {
            array_of_structs ( argv[3], iterations );
            break;
        }
        case 1: {
            struct_of_arrays ( argv[3], iterations );
            break;
        }
    }
    
    return 0;
}