#include <stdlib.h>
#include <time.h>
#include <stdio.h>

int binary_search_v0 ( int *array, int array_length, int key ) {
    int low  = 0;
    int high = array_length - 1;
    
    while ( low <= high ) {
        int middle = ( low + high ) / 2;
        
        if ( array[middle] == key ) {
            return middle;
        } else if ( array[middle] < key ) {
            low = middle + 1;
        } else if ( array[middle] > key ) {
            high = middle - 1;
        }
    }
    
    return -1;
}

int binary_search_v1 ( int *array, int array_length, int key ) {
    int low  = 0;
    int high = array_length - 1;
    
    while ( low <= high ) {
        int middle = ( low + high ) / 2;
    
        int new_low  = middle + 1;
        int new_high = middle - 1;
        
        __builtin_prefetch ( &array[( new_low + high ) / 2], 0, 3 );
        __builtin_prefetch ( &array[( low + new_high ) / 2], 0, 3 );
    
        if ( array[middle] == key ) {
            return middle;
        } else if ( array[middle] < key ) {
            low = new_low;
            
        } else if ( array[middle] > key ) {
            high = new_high;
        }
    }
    return -1;
}

int main ( int argc, char **argv ) {
    int type       = atoi ( argv[1] );
    int iterations = atoi ( argv[2] );
    
    FILE *input = fopen ( argv[3], "r" );
    if ( input == NULL ) {
        exit ( 1 );
    }
    
    int array_length = 0;
    fscanf ( input, "%d", &array_length );
    
    int *array   = ( int* ) malloc ( array_length * sizeof ( int ) );
    if ( array == NULL ) {
        exit ( 1 );
    }
    
    for ( int i = 0; i < array_length; ++i ) {
        fscanf ( input, "%d", &array[i] );
    }
    
    int keys_length = 0;
    fscanf ( input, "%d", &keys_length );
    
    int *keys = ( int* ) malloc ( keys_length * sizeof ( int ) );
    if ( keys == NULL ) {
        exit ( 1 );
    }
    
    for ( int i = 0; i < keys_length; ++i ) {
        fscanf ( input, "%d", &keys[i] );
    }
    
    fclose ( input );
    
    clock_t start = clock ( );
    
    for ( int iteration = 0; iteration < iterations; ++iteration ) {
        switch ( type ) {
            case 0: {
                for ( int i = 0; i < keys_length; ++i ) {
                    binary_search_v0 ( array, array_length, keys[i] );
                    break;
                }
            }
            case 1: {
                for ( int i = 0; i < keys_length; ++i ) {
                    binary_search_v1 ( array, array_length, keys[i] );
                    break;
                }
            }
        }
    }
    
    clock_t end = clock ( );
    
    double elapsed_in_ms = ( end - start ) * 1. / CLOCKS_PER_SEC * 1000;
    
    printf ( "ELAPSED (ms) = %lf\n", elapsed_in_ms );
    
    free ( array );
    free ( keys );
    
    return 0;
}