/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiImageLabel;
import gui.GuiLine;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import gui.components.DCGui;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.AND;
import logic.components.DC;
import logic.components.NOT;
import logic.components.OR;
import shemes.AbstractSchema;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;
import util.Router;

public class SignaliUpravljackeJedinice
extends AbstractSchema {
    public static final String DNAME = "Uprav1";
    private DC DC7;
    private List<NOT> notList;
    private List<AND> andList;
    private OR OR1;

    public SignaliUpravljackeJedinice() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("SignaliUpravljackeJedinice.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.DC7 = new DC(5);
        this.notList = new ArrayList<NOT>(32);
        this.andList = new ArrayList<AND>(32);
        int i = 0;
        while (i < 32) {
            this.notList.add(i, null);
            this.andList.add(i, null);
            ++i;
        }
        HashSet<Integer> usedExits = new HashSet<Integer>();
        int i2 = 0;
        while (i2 < Parameters.controlUnitDecoder.length) {
            String[] data = Parameters.controlUnitDecoder[i2];
            int index = Integer.parseInt(data[0]);
            if (data[1].length() > 0) {
                usedExits.add(index);
            }
            if (data.length > 3) {
                Pin outPin = this.DC7.getOutPin(index);
                outPin.setName(data[3]);
            }
            ++i2;
        }
        this.OR1 = new OR(usedExits.size());
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.DC7.setE(new Pin(true, "1"));
        this.DC7.setInPin(0, NameConnector.getPin("Counter.CW103"));
        this.DC7.setInPin(1, NameConnector.getPin("Counter.CW102"));
        this.DC7.setInPin(2, NameConnector.getPin("Counter.CW101"));
        this.DC7.setInPin(3, NameConnector.getPin("Counter.CW100"));
        this.DC7.setInPin(4, NameConnector.getPin("Counter.CW99"));
        HashSet<Integer> usedExits = new HashSet<Integer>();
        int i = 0;
        while (i < Parameters.controlUnitDecoder.length) {
            String[] data = Parameters.controlUnitDecoder[i];
            int index = Integer.parseInt(data[0]);
            if (data[1].length() > 0) {
                Pin pin;
                if (data[2].equals("#")) {
                    pin = NameConnector.getPin(data[1]);
                    NOT not = new NOT();
                    this.notList.set(index, not);
                    not.setInPin(0, pin);
                    AND and = new AND();
                    this.andList.set(index, and);
                    and.setInPin(0, this.DC7.getOutPin(index));
                    and.setInPin(1, not.getOutPin(0));
                } else {
                    pin = NameConnector.getPin(data[1]);
                    AND and = new AND();
                    this.andList.set(index, and);
                    and.setInPin(0, this.DC7.getOutPin(index));
                    and.setInPin(1, pin);
                }
                usedExits.add(index);
            }
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < this.DC7.getOutPins().length) {
            if (usedExits.contains(i)) {
                this.OR1.setInPin(j++, this.andList.get(i).getOutPin(0));
            }
            ++i;
        }
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Uprav1.png");
        String[] dcArgs = new String[]{"DC", "DC", "5", "1", "mCW99", "mCW100", "mCW101", "mCW102", "mCW103", "..."};
        DCGui dcGui = new DCGui(this.DC7, 75, 50, dcArgs, false);
        this.gui.addDrawables(dcGui.getDrawables());
        this.drawAll(this.DC7.getOutPins().length, dcGui);
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        Pin[] pinArray = this.DC7.getOutPins();
        int n = pinArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pin pin = pinArray[n2];
            String name = pin.getName();
            if (name != null && name.length() > 0) {
                result.add(new Element<String, Pin>(name, pin));
            }
            ++n2;
        }
        result.add(new Element<String, Pin>("branch", this.OR1.getOutPin(0)));
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        return result;
    }

    protected Point drawOne(int i, Point[] coordinates) {
        AND and = this.andList.get(i);
        NOT not = this.notList.get(i);
        Pin pin = this.DC7.getOutPin(i);
        String name = pin.getName();
        if (and != null) {
            ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
            ArrayList<Point> points = new ArrayList<Point>();
            points.add(coordinates[0]);
            points.add(coordinates[1]);
            points.add(coordinates[2]);
            points.add(coordinates[3]);
            points.add(coordinates[4]);
            points.add(coordinates[5]);
            sections.add(points);
            GuiPinLine line = new GuiPinLine(sections, pin);
            this.gui.addDrawable(line);
            GuiImageLabel im = new GuiImageLabel(coordinates[8].x + 16, coordinates[8].y - 1, "src/images/AND.png");
            this.gui.addDrawable(im);
            sections = new ArrayList();
            points = new ArrayList();
            points.add(coordinates[9]);
            points.add(coordinates[10]);
            sections.add(points);
            line = new GuiPinLine(sections, and.getOutPin(0));
            this.gui.addDrawable(line);
            Pin pin2 = null;
            if (not == null) {
                pin2 = and.getInPin(1);
            } else {
                pin2 = not.getInPin(0);
                GuiImageLabel imInv = new GuiImageLabel(coordinates[7].x - 4, coordinates[7].y - 3, "src/images/INV.png");
                this.gui.addDrawable(imInv);
                coordinates[7].x -= 5;
            }
            sections = new ArrayList();
            points = new ArrayList();
            points.add(coordinates[6]);
            points.add(coordinates[7]);
            sections.add(points);
            line = new GuiPinLine(sections, pin2);
            this.gui.addDrawable(line);
            String conditionName = this.getConditionName(i);
            GuiTextLabel label = new GuiTextLabel(coordinates[6].x - 5, coordinates[6].y, conditionName, 12, 1);
            this.gui.addDrawable(label);
            return coordinates[10];
        }
        if (name != null && !name.equals("")) {
            ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
            ArrayList<Point> points = new ArrayList<Point>();
            points.add(coordinates[0]);
            points.add(coordinates[1]);
            points.add(coordinates[2]);
            points.add(coordinates[3]);
            sections.add(points);
            GuiPinLine line = new GuiPinLine(sections, pin);
            this.gui.addDrawable(line);
            GuiTextLabel label = new GuiTextLabel(coordinates[3].x + 5, coordinates[6].y - 10, name, 12);
            this.gui.addDrawable(label);
        }
        return null;
    }

    private String getConditionName(int id) {
        String result = "";
        int i = 0;
        while (i < Parameters.controlUnitDecoder.length) {
            String[] data = Parameters.controlUnitDecoder[i];
            if (Integer.parseInt(data[0]) == id) {
                result = data[1];
                break;
            }
            ++i;
        }
        return result;
    }

    protected void drawAll(List<Point[]> coordinates) {
        Point start = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Point end = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i < coordinates.size()) {
            Point p = this.drawOne(i, coordinates.get(i));
            Router.findMinMax(start, end, p);
            ++i;
        }
        this.drawOr(start, end);
    }

    protected void drawAll(int n, DCGui dcGui) {
        LinkedList<Point> a = new LinkedList<Point>();
        int i = 0;
        while (i < n) {
            a.add(dcGui.getOutPortPosition(i));
            ++i;
        }
        List<Point[]> coordinates = Router.rout(a, 300, 28);
        this.drawAll(coordinates);
    }

    protected void drawOr(Point start, Point end) {
        OR or = this.OR1;
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(end.x + 23, (end.y + start.y) / 2));
        points.add(new Point(end.x + 63, (end.y + start.y) / 2));
        sections.add(points);
        GuiLine line = new GuiPinLine(sections, or.getOutPin(0));
        this.gui.addDrawable(line);
        GuiImageLabel im = new GuiImageLabel(end.x, (end.y + start.y) / 2 - 10, "src/images/OR.png");
        this.gui.addDrawable(im);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(end.x, start.y - 10));
        points.add(new Point(end.x, (end.y + start.y) / 2 - 10));
        sections.add(points);
        line = new GuiLine(sections);
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(end.x, (end.y + start.y) / 2 + 10));
        points.add(new Point(end.x, end.y + 10));
        sections.add(points);
        line = new GuiLine(sections);
        this.gui.addDrawable(line);
        GuiTextLabel label = new GuiTextLabel(end.x + 70, (end.y + start.y) / 2, "branch", 12);
        this.gui.addDrawable(label);
    }
}

