/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.BoolsToInt;
import logic.components.CD;
import logic.components.CLK;
import logic.components.IntToBools;
import logic.components.IntToInt;
import logic.components.REG;
import logic.components.TSB;
import shemes.AbstractSchema;
import shemes.components.Bus1;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;

public class Intr3
extends AbstractSchema {
    public static final String DNAME = "Intr3";
    private CD CD1;
    private CD CD2;
    private BoolsToInt UINT;
    private BoolsToInt UEXT;
    private TSB TSBUINTout3;
    private TSB TSBUEXTout3;
    private IntToInt IBUS3low;
    private REG BR;
    private IntToBools BRbits;
    private BoolsToInt IVTDSP;
    private TSB TSBIVTDSPout3;
    private REG IVTP;
    private TSB TSBIVTPout1;

    public Intr3() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("Intr3.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.CD1 = new CD(4);
        this.CD2 = new CD(8);
        this.UINT = new BoolsToInt(8);
        this.UEXT = new BoolsToInt(8);
        this.TSBUINTout3 = new TSB("UINTout3");
        this.TSBUINTout3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.TSBUEXTout3 = new TSB("EXTout3");
        this.TSBUEXTout3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.IBUS3low = new IntToInt(Parameters.sizeIBUS3, 8);
        this.BR = new REG(1, "BR");
        this.BR.getOutPin(0).setIsInt();
        this.BR.getOutPin(0).setNumOfLines(8);
        this.BRbits = new IntToBools(8);
        this.IVTDSP = new BoolsToInt(Parameters.sizeIBUS2);
        this.TSBIVTDSPout3 = new TSB("IVTDSPout3");
        this.TSBIVTDSPout3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.IVTP = new REG(1, "IVTP");
        this.IVTP.getOutPin(0).setIsInt();
        this.IVTP.getOutPin(0).setNumOfLines(Parameters.sizeIVTP);
        this.IVTP.initVal(Parameters.valIVTP);
        this.TSBIVTPout1 = new TSB("IVTPout1");
        this.TSBIVTPout1.getOutPin(0).setNumOfLines(Parameters.sizeIBUS1);
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.CD1.setE(new Pin(true, "1"));
        this.CD1.setInPin(0, NameConnector.getPin("Exec2.PSWT"));
        this.CD1.setInPin(1, NameConnector.getPin("Intr1.PRINM"));
        this.CD1.setInPin(2, NameConnector.getPin("Intr1.PRADR"));
        this.CD1.setInPin(3, NameConnector.getPin("Intr1.PRCOD"));
        this.UINT.setInPin(0, this.CD1.getOutPin(0));
        this.UINT.setInPin(1, this.CD1.getOutPin(1));
        int i = 2;
        while (i < 8) {
            this.UINT.setInPin(i, new Pin(false, "0"));
            ++i;
        }
        this.TSBUINTout3.setInPin(0, this.UINT.getOutPin(0));
        this.TSBUINTout3.setE(NameConnector.getPin("Oper1.UINTout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBUINTout3.getOutPin(0));
        this.CD2.setE(new Pin(true, "1"));
        this.CD2.setInPin(0, new Pin(false, "0"));
        this.CD2.setInPin(1, NameConnector.getPin("Intr2.irm1"));
        this.CD2.setInPin(2, NameConnector.getPin("Intr2.irm2"));
        this.CD2.setInPin(3, NameConnector.getPin("Intr2.irm3"));
        this.CD2.setInPin(4, NameConnector.getPin("Intr2.irm4"));
        this.CD2.setInPin(5, NameConnector.getPin("Intr2.irm5"));
        this.CD2.setInPin(6, NameConnector.getPin("Intr2.irm6"));
        this.CD2.setInPin(7, NameConnector.getPin("Intr2.irm7"));
        this.UEXT.setInPin(0, this.CD2.getOutPin(0));
        this.UEXT.setInPin(1, this.CD2.getOutPin(1));
        this.UEXT.setInPin(2, this.CD2.getOutPin(2));
        this.UEXT.setInPin(3, new Pin(true, "1"));
        i = 4;
        while (i < 8) {
            this.UEXT.setInPin(i, new Pin(false, "0"));
            ++i;
        }
        this.TSBUEXTout3.setInPin(0, this.UEXT.getOutPin(0));
        this.TSBUEXTout3.setE(NameConnector.getPin("Oper1.UEXTout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBUEXTout3.getOutPin(0));
        this.IBUS3low.setInPin(0, NameConnector.getPin("Bus1.IBUS3"));
        this.BR.setInPin(0, this.IBUS3low.getOutPin(0));
        this.BR.setPinLd(NameConnector.getPin("Oper1.ldBR"));
        this.BR.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.BRbits.setInPin(0, this.BR.getOutPin(0));
        this.IVTDSP.setInPin(0, new Pin(false, "0"));
        i = 0;
        while (i < 8) {
            this.IVTDSP.setInPin(1 + i, this.BRbits.getOutPin(i));
            ++i;
        }
        i = 9;
        while (i < Parameters.sizeIBUS2) {
            this.IVTDSP.setInPin(i, new Pin(false, "0"));
            ++i;
        }
        this.TSBIVTDSPout3.setInPin(0, this.IVTDSP.getOutPin(0));
        this.TSBIVTDSPout3.setE(NameConnector.getPin("Oper1.IVTDSPout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBIVTDSPout3.getOutPin(0));
        this.IVTP.setInPin(0, NameConnector.getPin("Bus1.IBUS3"));
        this.IVTP.setPinLd(NameConnector.getPin("Oper1.ldIVTP"));
        this.IVTP.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.TSBIVTPout1.setInPin(0, this.IVTP.getOutPin(0));
        this.TSBIVTPout1.setE(NameConnector.getPin("Oper1.IVTPout1"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS1(this.TSBIVTPout1.getOutPin(0));
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Intr3.png");
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(500, 42));
        points.add(new Point(500, 693));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(481, 57));
        points.add(new Point(481, 678));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(462, 72));
        points.add(new Point(462, 663));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 117));
        points.add(new Point(161, 117));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr1.PRCOD"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 132));
        points.add(new Point(161, 132));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr1.PRADR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 147));
        points.add(new Point(161, 147));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr1.PRINM"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 162));
        points.add(new Point(161, 162));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Exec2.PSWT"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(229, 72));
        points.add(new Point(236, 72));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(229, 102));
        points.add(new Point(236, 102));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(229, 117));
        points.add(new Point(236, 117));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(206, 132));
        points.add(new Point(236, 132));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD1.getOutPin(1));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(206, 147));
        points.add(new Point(236, 147));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(258, 109));
        points.add(new Point(364, 109));
        sections.add(points);
        line = new GuiPinLine(sections, this.UINT.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(376, 115));
        points.add(new Point(376, 120));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.UINTout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(386, 109));
        points.add(new Point(462, 109));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBUINTout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 307));
        points.add(new Point(161, 307));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 292));
        points.add(new Point(161, 292));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr2.irm1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 277));
        points.add(new Point(161, 277));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr2.irm2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 262));
        points.add(new Point(161, 262));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr2.irm3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 247));
        points.add(new Point(161, 247));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr2.irm4"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 232));
        points.add(new Point(161, 232));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr2.irm5"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 217));
        points.add(new Point(161, 217));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr2.irm6"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(154, 202));
        points.add(new Point(161, 202));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Intr2.irm7"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(229, 194));
        points.add(new Point(236, 194));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(229, 224));
        points.add(new Point(236, 224));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(true, "1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(206, 240));
        points.add(new Point(236, 240));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD2.getOutPin(2));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(206, 255));
        points.add(new Point(236, 255));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD2.getOutPin(1));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(206, 270));
        points.add(new Point(236, 270));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(258, 232));
        points.add(new Point(364, 232));
        sections.add(points);
        line = new GuiPinLine(sections, this.UEXT.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(376, 236));
        points.add(new Point(376, 243));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.UEXTout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(386, 232));
        points.add(new Point(462, 232));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBUEXTout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(278, 351));
        points.add(new Point(278, 328));
        points.add(new Point(462, 328));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS3low.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(195, 360));
        points.add(new Point(203, 360));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(195, 379));
        points.add(new Point(203, 379));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldBR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(278, 388));
        points.add(new Point(278, 421));
        sections.add(points);
        line = new GuiPinLine(sections, this.BR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(308, 434));
        points.add(new Point(308, 440));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(218, 434));
        points.add(new Point(218, 440));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(248, 434));
        points.add(new Point(248, 440));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(263, 434));
        points.add(new Point(263, 440));
        sections.add(points);
        line = new GuiPinLine(sections, this.BRbits.getOutPin(7));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(293, 434));
        points.add(new Point(293, 440));
        sections.add(points);
        line = new GuiPinLine(sections, this.BRbits.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(252, 464));
        points.add(new Point(252, 490));
        points.add(new Point(364, 490));
        sections.add(points);
        line = new GuiPinLine(sections, this.IVTDSP.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(376, 495));
        points.add(new Point(376, 501));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.IVTDSPout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(386, 490));
        points.add(new Point(462, 490));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBIVTDSPout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(278, 558));
        points.add(new Point(278, 535));
        points.add(new Point(462, 535));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(195, 567));
        points.add(new Point(202, 567));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(195, 586));
        points.add(new Point(202, 586));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldIVTP"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(278, 596));
        points.add(new Point(278, 622));
        points.add(new Point(364, 622));
        sections.add(points);
        line = new GuiPinLine(sections, this.IVTP.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(376, 627));
        points.add(new Point(376, 633));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.IVTPout1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(386, 622));
        points.add(new Point(500, 622));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBIVTPout1.getOutPin(0));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(504, 118, NameConnector.getPin("Bus1.IBUS1")));
        this.gui.addDrawable(new GuiPinLabel(485, 138, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(466, 158, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(302, 532, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(302, 324, this.IBUS3low.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(286, 124, this.UINT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(423, 124, this.TSBUINTout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(286, 247, this.UEXT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(423, 247, this.TSBUEXTout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(281, 417, this.BR.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(281, 505, this.IVTDSP.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(281, 637, this.IVTP.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(415, 618, this.TSBIVTPout1.getOutPin(0)));
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        result.add(new Element<String, Pin>("UINT", this.UINT.getOutPin(0)));
        result.add(new Element<String, Pin>("UEXT", this.UEXT.getOutPin(0)));
        result.add(new Element<String, Pin>("BR", this.BR.getOutPin(0)));
        result.add(new Element<String, Pin>("IVTP", this.IVTP.getOutPin(0)));
        result.add(new Element<String, Pin>("IVTDSP", this.IVTDSP.getOutPin(0)));
        result.add(new Element<String, Pin>("IVTPout", this.TSBIVTPout1.getOutPin(0)));
        result.add(new Element<String, Pin>("IVTDSPout", this.TSBIVTDSPout3.getOutPin(0)));
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        result.add(new Element<String, REG>("BR", this.BR));
        result.add(new Element<String, REG>("IVTP", this.IVTP));
        return result;
    }

    public REG RegBR() {
        return this.BR;
    }

    public REG RegIVTP() {
        return this.IVTP;
    }
}

