/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.components.AndGui;
import gui.components.DrawableComponent;
import gui.components.DrawableComponentAbstract;
import gui.components.IntToBoolsGui;
import gui.components.NandGui;
import gui.components.NorGui;
import gui.components.NotGui;
import gui.components.OrGui;
import gui.components.TwoOneGui;
import gui.components.XorGui;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import logic.LogicComponent;
import logic.LogicComponentFactory;
import logic.Pin;
import logic.components.AND;
import logic.components.IntToBools;
import logic.components.NAND;
import logic.components.NOR;
import logic.components.NOT;
import logic.components.OR;
import logic.components.TwoOne;
import logic.components.XOR;
import shemes.AbstractSchema;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;
import util.ValidationElement;

public class Fetch3
extends AbstractSchema {
    public static final String DNAME = "Fetch3";
    private final int startX = 50;
    private final int startY = 0;
    static String[] okComponents = new String[]{"AND", "OR", "NAND", "NOR", "XOR", "NOT", "SPLIT"};
    static Set<String> supportedComponents = new HashSet<String>();

    static {
        String[] stringArray = okComponents;
        int n = okComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String comp = stringArray[n2];
            supportedComponents.add(comp);
            ++n2;
        }
    }

    public Fetch3() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("Fetch3.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.components = new HashMap();
        int i = 0;
        while (i < Parameters.fetch3Conections.length) {
            String[] data = Parameters.fetch3Conections[i];
            LogicComponent component = LogicComponentFactory.loadComponent(data, null);
            this.components.put(data[1], component);
            ++i;
        }
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        String[][] stringArray = Parameters.fetch3Conections;
        int n = Parameters.fetch3Conections.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data = stringArray[n2];
            LogicComponent component = this.getLogicComponent(data[1]);
            int i = 0;
            while (i < component.getInPins().length) {
                Pin x = NameConnector.getPin(data[3 + i]);
                component.setInPin(i, x);
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Fetch3.png");
        List<LogicComponent> comp = this.extractComponents();
        int numColumns = (int)Math.ceil(Math.sqrt(comp.size()));
        int numRows = (int)Math.ceil((double)comp.size() * 1.0 / (double)numColumns);
        int y = 0;
        int cnt = 0;
        int i = 0;
        while (i < numRows && cnt < comp.size()) {
            int max = 0;
            int x = 50;
            int j = 0;
            while (j < numColumns && cnt < comp.size()) {
                LogicComponent component = comp.get(cnt);
                DrawableComponent compGui = this.loadGuiComponent(component, x, y);
                this.gui.addDrawables(compGui.getDrawables());
                x += compGui.getWidth();
                if (max < compGui.getHeight()) {
                    max = compGui.getHeight();
                }
                ++cnt;
                ++j;
            }
            y += max;
            ++i;
        }
    }

    private List<LogicComponent> extractComponents() {
        LinkedList<LogicComponent> result = new LinkedList<LogicComponent>();
        LinkedList comps = new LinkedList(this.components.values());
        LinkedList temp = new LinkedList(this.components.values());
        for (LogicComponent component : comps) {
            if (!(component instanceof AND)) continue;
            if (component.getInPins().length == 2) {
                LogicComponent left = this.getComponent(component.getInPin(0));
                LogicComponent right = this.getComponent(component.getInPin(1));
                if (left != null && right != null && left instanceof OR && right instanceof OR) {
                    TwoOne t = new TwoOne(left, right, component);
                    result.add(t);
                    temp.remove(left);
                    temp.remove(right);
                } else {
                    result.add(component);
                }
            } else {
                result.add(component);
            }
            temp.remove(component);
        }
        result.addAll(temp);
        return result;
    }

    private LogicComponent getComponent(Pin out) {
        for (LogicComponent component : this.components.values()) {
            Pin[] pinArray = component.getOutPins();
            int n = pinArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pin pin = pinArray[n2];
                if (out == pin) {
                    return component;
                }
                ++n2;
            }
        }
        return null;
    }

    private DrawableComponent loadGuiComponent(LogicComponent component, int x, int y) {
        DrawableComponentAbstract compGui = null;
        if (component instanceof OR) {
            compGui = new OrGui(component, x, y, null, true, true);
        } else if (component instanceof AND) {
            compGui = new AndGui(component, x, y, null, true, true);
        } else if (component instanceof NAND) {
            compGui = new NandGui(component, x, y, null, true, true);
        } else if (component instanceof NOR) {
            compGui = new NorGui(component, x, y, null, true, true);
        } else if (component instanceof XOR) {
            compGui = new XorGui(component, x, y, null, true, true);
        } else if (component instanceof NOT) {
            compGui = new NotGui(component, x, y, null, true, true);
        } else if (component instanceof TwoOne) {
            compGui = new TwoOneGui(component, x, y, null, true, true);
        } else if (component instanceof IntToBools) {
            compGui = new IntToBoolsGui(component, x, y, null, true, true);
        }
        return compGui;
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        for (LogicComponent logicComponent : this.components.values()) {
            Pin[] pinArray = logicComponent.getOutPins();
            int n = pinArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pin outputPin = pinArray[n2];
                String key = outputPin.getName();
                key = key.toLowerCase();
                result.add(new Element<String, Pin>(key, outputPin));
                ++n2;
            }
        }
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        String[][] stringArray = Parameters.fetch3Conections;
        int n = Parameters.fetch3Conections.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data = stringArray[n2];
            LogicComponent component = this.getLogicComponent(data[1]);
            result.add(new Element<String, LogicComponent>(component.getName(), component));
            ++n2;
        }
        return result;
    }

    private LogicComponent getLogicComponent(String name) {
        return (LogicComponent)this.components.get(name);
    }

    @Override
    public List<Element<String[], ValidationElement>> validate() {
        String[][] args = Parameters.fetch3Conections;
        List<Element<String[], ValidationElement>> result = this.validate(args, supportedComponents, null, null);
        return result;
    }
}

