/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.components.DCGui;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import logic.LogicComponent;
import logic.LogicComponentFactory;
import logic.Pin;
import logic.components.DC;
import shemes.AbstractSchema;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;
import util.ValidationElement;

public class Fetch2
extends AbstractSchema {
    public static final String DNAME = "Fetch2";
    private List<DC> dcs;
    private Map<DC, String[]> connections;
    private final int startX = 50;
    private final int startY = 0;
    static String[] okComponents = new String[]{"DC"};
    static Set<String> supportedComponents = new HashSet<String>();

    static {
        String[] stringArray = okComponents;
        int n = okComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String comp = stringArray[n2];
            supportedComponents.add(comp);
            ++n2;
        }
    }

    public Fetch2() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("Fetch2.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.dcs = new LinkedList<DC>();
        this.components = new HashMap();
        this.connections = new HashMap<DC, String[]>();
        int i = 0;
        while (i < Parameters.fetch2Conections.length) {
            String[] data = Parameters.fetch2Conections[i];
            DC dc = (DC)LogicComponentFactory.loadComponent(data, null);
            this.dcs.add(dc);
            this.components.put(data[1], dc);
            this.connections.put(dc, data);
            ++i;
        }
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        for (DC dc : this.dcs) {
            Pin[] pinArray = dc.getOutPins();
            int n = pinArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pin outputPin = pinArray[n2];
                String key = outputPin.getName();
                key = key.toLowerCase();
                result.add(new Element<String, Pin>(key, outputPin));
                ++n2;
            }
        }
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        return result;
    }

    @Override
    public void initConections() {
        String[][] stringArray = Parameters.fetch2Conections;
        int n = Parameters.fetch2Conections.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data = stringArray[n2];
            DC dc = (DC)this.components.get(data[1]);
            Pin e = NameConnector.getPin(data[3]);
            dc.setE(e);
            int size = Integer.parseInt(data[2]);
            int i = 0;
            while (i < size) {
                Pin x = NameConnector.getPin(data[i + 4]);
                dc.setInPin(i, x);
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Fetch2.png");
        int numColumns = (int)Math.ceil(Math.sqrt(this.components.size()));
        int numRows = (int)Math.ceil((double)this.components.size() * 1.0 / (double)numColumns);
        int y = 0;
        int cnt = 0;
        int i = 0;
        while (i < numRows && cnt < this.components.size()) {
            int maxY = 0;
            int x = 50;
            int j = 0;
            while (j < numColumns && cnt < this.components.size()) {
                DC dc = this.dcs.get(cnt);
                DCGui dcGui = new DCGui(dc, x, y, this.connections.get(dc), true);
                this.gui.addDrawables(dcGui.getDrawables());
                x += dcGui.getWidth();
                if (maxY < dcGui.getHeight()) {
                    maxY = dcGui.getHeight();
                }
                ++cnt;
                ++j;
            }
            y += maxY;
            ++i;
        }
    }

    @Override
    public List<Element<String[], ValidationElement>> validate() {
        String[][] args = Parameters.fetch2Conections;
        List<Element<String[], ValidationElement>> result = this.validate(args, supportedComponents, null, null);
        return result;
    }
}

