/*
 * Decompiled with CFR 0.152.
 */
package shemes;

import gui.Drawable;
import gui.GuiComponent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import logic.ComplexLogicComponent;
import logic.LogicComponent;
import logic.Pin;
import shemes.Schema;
import util.Element;
import util.NameConnector;
import util.ValidationElement;

public abstract class AbstractSchema
implements Schema {
    protected LogicComponent logicComponent;
    protected Map<String, LogicComponent> components;
    protected GuiComponent gui = null;
    protected List<Schema> subSchemes = new LinkedList<Schema>();
    public String componentName = null;
    protected String displayName = null;
    List<Drawable> schemaInterface;

    @Override
    public void initComponent() {
        for (Schema schema : this.subSchemes) {
            schema.initComponent();
        }
    }

    @Override
    public void initConections() {
        for (Schema schema : this.subSchemes) {
            schema.initConections();
        }
    }

    @Override
    public void initGui() {
        for (Schema schema : this.subSchemes) {
            schema.initGui();
        }
    }

    @Override
    public GuiComponent getGui() {
        return this.gui;
    }

    @Override
    public List<Schema> getSchemes() {
        return this.subSchemes;
    }

    @Override
    public void addScheme(Schema schema) {
        this.subSchemes.add(schema);
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public static Schema getSchenaWithGui(Schema schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getGui() != null) {
            return schema;
        }
        for (Schema s : schema.getSchemes()) {
            Schema result = AbstractSchema.getSchenaWithGui(s);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Schema getSchenaWithGui(Schema schema, String name) {
        if (schema == null) {
            return null;
        }
        if (schema.getGui() != null && schema.getName().equals(name)) {
            return schema;
        }
        for (Schema s : schema.getSchemes()) {
            Schema result = AbstractSchema.getSchenaWithGui(s, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract List<Element<String, LogicComponent>> getComponents();

    public abstract List<Element<String, Pin>> getPins();

    public void putComponents() {
        List<Element<String, LogicComponent>> list = this.getComponents();
        for (Element<String, LogicComponent> element : list) {
            if (!((LogicComponent)element.value).isSeq()) continue;
            NameConnector.addComponent(this.componentName, (String)element.name, (LogicComponent)element.value);
        }
    }

    public void putPins() {
        List<Element<String, Pin>> list = this.getPins();
        for (Element<String, Pin> element : list) {
            NameConnector.addPin(this.componentName, (String)element.name, (Pin)element.value);
        }
    }

    @Override
    public LogicComponent getLogicComponent() {
        if (this.logicComponent == null) {
            List<Element<String, LogicComponent>> componentElements = this.getComponents();
            LinkedList<LogicComponent> components = new LinkedList<LogicComponent>();
            for (Element<String, LogicComponent> element : componentElements) {
                components.add((LogicComponent)element.value);
            }
            List<Element<String, Pin>> pinElements = this.getPins();
            LinkedList<Pin> pins = new LinkedList<Pin>();
            for (Element<String, Pin> element : pinElements) {
                pins.add((Pin)element.value);
            }
            this.logicComponent = new ComplexLogicComponent(components, pins);
        }
        return this.logicComponent;
    }

    @Override
    public List<Drawable> getInterface() {
        LinkedList<Drawable> result = new LinkedList<Drawable>();
        return result;
    }

    @Override
    public List<Element<String[], ValidationElement>> validate() {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        for (Schema subScheme : this.subSchemes) {
            List<Element<String[], ValidationElement>> tmp = subScheme.validate();
            result.addAll(tmp);
        }
        return result;
    }

    protected List<Element<String[], ValidationElement>> validate(String[][] args, Set<String> supportedComponents, Set<String> supportedNames, Set<String> requiredNames) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        HashSet<String> componentNames = new HashSet<String>();
        HashSet<String> cRequiredNames = new HashSet<String>();
        if (requiredNames != null) {
            cRequiredNames.addAll(requiredNames);
        }
        HashSet<String> pinNames = new HashSet<String>();
        String[][] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Element<String[], ValidationElement> element;
            ValidationElement vElement;
            String[] arg = stringArray[n2];
            String name = arg[1];
            if (supportedNames != null && !supportedNames.contains(name)) {
                vElement = new ValidationElement(4, "Unknown component name: " + name);
                element = new Element<String[], ValidationElement>(arg, vElement);
                result.add(element);
            }
            if (componentNames.contains(name)) {
                vElement = new ValidationElement(2, "Duplicate name: " + name);
                element = new Element<String[], ValidationElement>(arg, vElement);
                result.add(element);
            }
            componentNames.add(name);
            String type = arg[0];
            if (supportedComponents != null && !supportedComponents.contains(type)) {
                ValidationElement vElement2 = new ValidationElement(5, "Unsupported component: " + type);
                Element<String[], ValidationElement> element2 = new Element<String[], ValidationElement>(arg, vElement2);
                result.add(element2);
            } else {
                String pinName = arg[arg.length - 1];
                if (pinNames.contains(pinName)) {
                    ValidationElement vElement3 = new ValidationElement(6, "Duplicate pin name: " + pinName);
                    Element<String[], ValidationElement> element3 = new Element<String[], ValidationElement>(arg, vElement3);
                    result.add(element3);
                }
                pinNames.add(pinName);
                LogicComponent component = this.components.get(name);
                result.addAll(component.validateComponent(arg));
            }
            cRequiredNames.remove(name);
            ++n2;
        }
        for (String requiredName : cRequiredNames) {
            ValidationElement vElement = new ValidationElement(8, "Recuired component: " + requiredName);
            Element<String[], ValidationElement> element = new Element<String[], ValidationElement>(new String[0], vElement);
            result.add(element);
        }
        return result;
    }
}

