/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JPanel;
import main.SimulatorActions;
import shemes.AbstractSchema;
import shemes.Schema;

public class TreePanel
extends JPanel {
    private static final String LEVELSEPARATOR = "    ";
    private static final long serialVersionUID = 1L;
    List listOfShemes = new List();
    Map<String, Schema> names = new LinkedHashMap<String, Schema>();

    public TreePanel(java.util.List<Schema> schemas) {
        for (String name : this.extractNames(schemas, this.names)) {
            this.listOfShemes.add(name);
        }
        this.listOfShemes.addItemListener(new ListOfSchemesItemListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.listOfShemes, "Center");
    }

    private java.util.List<String> extractNames(java.util.List<Schema> schemas, Map<String, Schema> names) {
        LinkedList<String> result = new LinkedList<String>();
        LinkedHashMap<Schema, String> shemaNames = new LinkedHashMap<Schema, String>();
        this.extractNames(schemas, shemaNames, "");
        for (Map.Entry schema : shemaNames.entrySet()) {
            names.put((String)schema.getValue(), (Schema)schema.getKey());
            result.add((String)schema.getValue());
        }
        return result;
    }

    private void extractNames(java.util.List<Schema> schemas, Map<Schema, String> schemasNames, String level) {
        for (Schema schema : schemas) {
            String oldName = schemasNames.get(schema);
            String name = String.valueOf(level) + schema.getDisplayName();
            if (oldName != null && oldName.length() >= name.length()) continue;
            schemasNames.put(schema, name);
            java.util.List<Schema> newList = schema.getSchemes();
            if (newList == null || level.length() >= 20) continue;
            this.extractNames(newList, schemasNames, LEVELSEPARATOR + level);
        }
    }

    private Schema getSchema(String name) {
        Schema schema = this.names.get(name);
        if ((schema = AbstractSchema.getSchenaWithGui(schema)) == null) {
            return null;
        }
        return schema;
    }

    public void changeSchema(Schema newSchema) {
        this.validate();
        this.repaint();
    }

    public class ListOfSchemesItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent arg0) {
            String selectedText = TreePanel.this.listOfShemes.getSelectedItem();
            Schema currentScheme = TreePanel.this.getSchema(selectedText);
            SimulatorActions.changeSchema(currentScheme);
        }
    }
}

