/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Font;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.undo.CompoundEdit;
import main.EditorHighlight;
import main.SimulatorActions;
import main.UndoRedo;
import util.MicrocodeConverter;

public class MicrocodeEditorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "MicrocodeEditor";
    boolean changed = false;
    boolean setting = false;
    JTextPane original;
    JTextArea converted;
    Document document;
    EditorHighlight editorHighlight;
    static final String[] KEYWORDS = new String[]{"br", ",br", "if", "(if", "then"};
    static Set<String> keyWords = new HashSet<String>();

    static {
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            keyWords.add(word);
            ++n2;
        }
    }

    public MicrocodeEditorPanel() {
        MicrocodeConverter microcode = MicrocodeConverter.microcodeConverter;
        this.setLayout(new BoxLayout(this, 0));
        this.original = new JTextPane();
        this.original.setFont(new Font("Consolas", 0, 14));
        this.original.setForeground(Color.BLACK);
        this.document = new CustomUndoDocument();
        this.original.setDocument(this.document);
        this.document.addDocumentListener(new MyDocumentListener());
        this.add("West", this.original);
        this.converted = new JTextArea(microcode.getConverted());
        this.converted.setEditable(false);
        this.converted.setFont(new Font("Consolas", 0, 14));
        this.converted.setForeground(new Color(63, 127, 95));
        this.add("East", this.converted);
        UndoRedo undoRedo = new UndoRedo(NAME);
        undoRedo.undoredo(this.original);
        this.editorHighlight = new EditorHighlight(this.original, Color.YELLOW);
        this.original.addCaretListener(this.editorHighlight);
    }

    public void update() {
        ((CustomUndoDocument)this.document).start();
        MicrocodeConverter microcode = MicrocodeConverter.microcodeConverter;
        this.setting = true;
        this.updateDodument(this.original.getDocument(), microcode.getLines());
        this.converted.setText(microcode.getConverted());
        this.setting = false;
        ((CustomUndoDocument)this.document).stop();
    }

    protected Document updateDodument(Document document, List<MicrocodeConverter.Line> lines) {
        try {
            document.remove(0, document.getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (MicrocodeConverter.Line line : lines) {
            if (line.microcode.status == 1) {
                this.addCommentLine(document, line);
                continue;
            }
            List<String> errors = line.microcode.getErrors();
            if (errors != null) {
                this.addErrorLine(document, line);
                continue;
            }
            this.addCommandLine(document, line);
        }
        return document;
    }

    private void addErrorLine(Document document, MicrocodeConverter.Line line) {
        try {
            StyleContext context = new StyleContext();
            Style style = context.getStyle("default");
            style.addAttribute(StyleConstants.Foreground, new Color(255, 0, 0));
            style.addAttribute(StyleConstants.Underline, true);
            String text = String.valueOf(line.microcode.originalLine) + "\n";
            document.insertString(document.getLength(), text, style);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCommentLine(Document document, MicrocodeConverter.Line line) {
        try {
            StyleContext context = new StyleContext();
            Style style = context.getStyle("default");
            style.addAttribute(StyleConstants.Foreground, new Color(63, 127, 95));
            style.addAttribute(StyleConstants.Italic, true);
            String text = String.valueOf(line.microcode.originalLine) + "\n";
            document.insertString(document.getLength(), text, style);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCommandLine(Document document, MicrocodeConverter.Line line) {
        try {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            String text = String.valueOf(line.microcode.originalLine) + "\n";
            document.insertString(document.getLength(), text, attributes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CustomUndoDocument
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;
        private CompoundEdit compoundEdit;
        private boolean work = false;
        private int caretPosition;

        CustomUndoDocument() {
        }

        @Override
        protected void fireUndoableEditUpdate(UndoableEditEvent e) {
            if (this.work) {
                if (this.compoundEdit == null) {
                    super.fireUndoableEditUpdate(e);
                } else {
                    this.compoundEdit.addEdit(e.getEdit());
                }
            }
        }

        public void start() {
            if (this.work) {
                this.compoundEdit = new CompoundEdit();
                this.caretPosition = MicrocodeEditorPanel.this.original.getCaretPosition();
            }
        }

        public void stop() {
            if (this.work) {
                this.compoundEdit.end();
                super.fireUndoableEditUpdate(new UndoableEditEvent(this, this.compoundEdit));
                this.compoundEdit = null;
                if (MicrocodeEditorPanel.this.original.getDocument().getLength() > this.caretPosition) {
                    MicrocodeEditorPanel.this.original.setCaretPosition(this.caretPosition);
                }
            } else {
                this.work = true;
            }
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (!MicrocodeEditorPanel.this.setting && !MicrocodeEditorPanel.this.changed) {
                MicrocodeEditorPanel.this.changed = true;
                SimulatorActions.microcodeChanged();
            }
        }
    }
}

