/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import java.util.LinkedList;
import java.util.List;
import logic.AbstractLogicComponent;
import logic.Pin;
import util.Element;
import util.ValidationElement;

public class TSB
extends AbstractLogicComponent {
    private Pin enable;
    private Pin lastIn;
    private Pin lastE;

    public TSB(String name) {
        super(1, 1, name, 0);
        this.out[0].setIsInt();
        this.out[0].setHighZ(true);
        this.enable = new Pin("", true, 0, 0, true, false);
        this.lastIn = new Pin("", true, 0, 1, true, false);
        this.lastE = new Pin("", true, 0, 1, true, false);
    }

    @Override
    public void func() {
        if (this.lastIn.compare(this.in[0]) && this.lastE.compare(this.enable)) {
            return;
        }
        if (this.enable.getBoolVal()) {
            this.out[0].setHighZ(false);
            if (this.in[0].isHighZ()) {
                if (this.out[0].isBool()) {
                    this.out[0].setBoolVal(true);
                } else {
                    this.out[0].setIntVal(-1);
                }
            } else if (this.out[0].isBool()) {
                this.out[0].setBoolVal(this.in[0].getBoolVal());
            } else {
                this.out[0].setIntVal(this.in[0].getIntVal());
            }
        } else {
            this.out[0].setHighZ(true);
        }
        this.lastIn.copyVal(this.in[0]);
        this.lastE.copyVal(this.enable);
    }

    public Pin getE() {
        return this.enable;
    }

    public void setE(Pin enable) {
        this.enable = enable;
        enable.addChild(this);
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }

    public static TSB createTSB(String[] data) {
        TSB result = null;
        try {
            String name = data[1];
            result = new TSB(name);
            int size = Integer.parseInt(data[2]);
            result.getOutPin(0).setNumOfLines(size);
            result.getOutPin(0).setName(data[data.length - 1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.name) + " " + this.enable.getBoolVal() + " " + this.in[0].toString();
        return result;
    }

    @Override
    public List<Element<String[], ValidationElement>> validateComponent(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        int size = 0;
        try {
            size = Integer.parseInt(data[2]);
            if (size <= 0) {
                ValidationElement vElement = new ValidationElement(3, "size < 0: size=" + size);
                Element<String[], ValidationElement> manjeOdMin = new Element<String[], ValidationElement>(data, vElement);
                result.add(manjeOdMin);
            } else if (size != data.length - 5) {
                ValidationElement vElement = new ValidationElement(3, "size != number of elements: size=" + size + ", number of elements=" + (data.length - 5));
                Element<String[], ValidationElement> manjeOdMin = new Element<String[], ValidationElement>(data, vElement);
                result.add(manjeOdMin);
            }
        }
        catch (Exception e) {
            ValidationElement vElement = new ValidationElement(3, "size is not a number: size=" + size);
            Element<String[], ValidationElement> err = new Element<String[], ValidationElement>(data, vElement);
            result.add(err);
        }
        return result;
    }

    @Override
    public List<Element<String[], ValidationElement>> validateConnection(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        int i = 0;
        while (i < this.in.length) {
            Pin inPin = this.in[i];
            if (inPin == null) {
                ValidationElement vElement = new ValidationElement(7, "Pin[" + i + "] not connected: " + data[i + 4]);
                Element<String[], ValidationElement> notConnected = new Element<String[], ValidationElement>(data, vElement);
                result.add(notConnected);
            }
            ++i;
        }
        if (this.enable == null) {
            ValidationElement vElement = new ValidationElement(7, "Pin E not connected: ");
            Element<String[], ValidationElement> notConnected = new Element<String[], ValidationElement>(data, vElement);
            result.add(notConnected);
        }
        return result;
    }
}

