/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.Execution;
import logic.Pin;
import logic.components.CLK;
import util.Log;
import util.Mask;

public class REG
extends AbstractLogicComponent {
    private Pin clk;
    private Pin cl;
    private Pin ld;
    private Pin inc;
    private Pin dec;
    private Pin shr;
    private Pin shl;
    private Pin carry;
    private Pin ir;
    private Pin il;
    private int value = 0;
    private boolean c = false;
    private int init;

    public REG(int in, String name) {
        super(in, in, name, 1);
        if (in > 0) {
            Execution.addSequentialComponent(this);
        }
    }

    @Override
    public void func() {
        if (this.clk == null) {
            Log.errorDialog(":Error!!! Register " + this.name + " is not connected to clock.");
            return;
        }
        if (this.clk != null && !this.clk.getBoolVal()) {
            return;
        }
        int val = 0;
        if (this.cl != null && this.cl.getBoolVal()) {
            ++val;
        }
        if (this.ld != null && this.ld.getBoolVal()) {
            ++val;
        }
        if (this.inc != null && this.inc.getBoolVal()) {
            ++val;
        }
        if (this.dec != null && this.dec.getBoolVal()) {
            ++val;
        }
        if (this.shr != null && this.shr.getBoolVal()) {
            ++val;
        }
        if (this.shl != null && this.shl.getBoolVal()) {
            ++val;
        }
        if (val > 1) {
            Log.errorDialog(":Error!!! Multiple register action...");
            return;
        }
        if (this.cl != null && this.cl.getBoolVal()) {
            this.value = 0;
            this.c = false;
            return;
        }
        if (this.ld != null && this.ld.getBoolVal()) {
            this.value = this.getInput() & this.createMask();
            this.c = false;
            return;
        }
        if (this.shl != null && this.shl.getBoolVal()) {
            this.c = (this.value & 1 << this.in[0].getNumOfLines() - 1) == 1;
            this.value <<= 1;
            if (this.il != null && this.il.getBoolVal()) {
                this.value |= 1;
            }
            this.value &= this.createMask();
            return;
        }
        if (this.shr != null && this.shr.getBoolVal()) {
            this.c = (this.value & 1) == 1;
            this.value >>= 1;
            if (this.ir != null && this.ir.getBoolVal()) {
                this.value |= 1 << this.in[0].getNumOfLines() - 1;
            }
            this.value &= this.createMask();
            return;
        }
        if (this.inc != null && this.inc.getBoolVal()) {
            ++this.value;
            this.value &= this.createMask();
            this.c = this.value == 0;
            return;
        }
        if (this.dec != null && this.dec.getBoolVal()) {
            int mask = this.createMask();
            --this.value;
            this.value &= mask;
            this.c = this.value == mask;
            return;
        }
    }

    @Override
    public void propagate() {
        if (this.out[0].isBool()) {
            int priv = this.value;
            int j = 0;
            while (j < this.out.length) {
                boolean mod = (priv & 1) == 1;
                priv >>= 1;
                this.out[j].setBoolVal(mod);
                ++j;
            }
        } else {
            this.out[0].setIntVal(this.value);
        }
        if (this.carry != null) {
            this.carry.setBoolVal(this.c);
        }
    }

    private int getInput() {
        if (this.in[0].isBool()) {
            int suma = 0;
            int j = 0;
            while (j < this.in.length) {
                if (this.in[j].getBoolVal()) {
                    suma += 1 << j;
                }
                ++j;
            }
            return suma;
        }
        return this.in[0].getIntVal();
    }

    public void setPinInc(Pin inc) {
        this.inc = inc;
        inc.addChild(this);
    }

    public void setPinDec(Pin dec) {
        this.dec = dec;
        dec.addChild(this);
    }

    public void setPinCL(Pin cl) {
        this.cl = cl;
        cl.addChild(this);
    }

    public void setPinLd(Pin ld) {
        this.ld = ld;
        ld.addChild(this);
    }

    public int getVal() {
        return this.value;
    }

    public void initVal(int value) {
        this.value = value;
        this.init = value;
    }

    public void setVal(int val) {
        this.value = val & this.createMask();
        this.propagate();
    }

    public void setShr(Pin shr) {
        this.shr = shr;
        shr.addChild(this);
    }

    public void setShl(Pin shl) {
        this.shl = shl;
        shl.addChild(this);
    }

    public Pin getC() {
        return this.carry;
    }

    public void setIR(Pin ir) {
        this.ir = ir;
        ir.addChild(this);
    }

    public void setIL(Pin il) {
        this.il = il;
        il.addChild(this);
    }

    @Override
    public void init(boolean fullInit) {
        this.value = this.init;
        this.propagate();
    }

    public int createMask() {
        int size = this.getOutPin(0).isBool() ? this.out.length : this.getOutPin(0).getNumOfLines();
        try {
            return Mask.createMask(size);
        }
        catch (Exception e) {
            throw new RuntimeException("Maxima REG size 32: " + this.name + ": " + size);
        }
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.name) + "=" + this.value;
        return result;
    }

    public void setClk(CLK clk) {
        this.clk = clk.getClk();
        this.period = clk.getPeriod();
    }
}

